<instrumentationManifest xmlns="http://schemas.microsoft.com/win/2004/08/events">
    <instrumentation xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events">
        <events xmlns="http://schemas.microsoft.com/win/2004/08/events">
            <!--CLR Runtime Publisher-->
            <provider name="Microsoft-Windows-DotNETRuntime" guid="{e13c0d23-ccbc-4e12-931b-d9cc2eee27e4}" symbol="MICROSOFT_WINDOWS_DOTNETRUNTIME_PROVIDER" resourceFileName="%WINDIR%\Microsoft.NET\Framework64\v4.0.30319\clretwrc.dll" messageFileName="%WINDIR%\Microsoft.NET\Framework64\v4.0.30319\clretwrc.dll">
                <!--Keywords-->
                <keywords>
                    <keyword name="GCKeyword" mask="0x1" message="$(string.RuntimePublisher.GCKeywordMessage)" symbol="CLR_GC_KEYWORD"/>
                    <!-- Keyword mask 0x2 is now defunct -->
                    <keyword name="FusionKeyword" mask="0x4" message="$(string.RuntimePublisher.FusionKeywordMessage)" symbol="CLR_FUSION_KEYWORD"/>
                    <keyword name="LoaderKeyword" mask="0x8" message="$(string.RuntimePublisher.LoaderKeywordMessage)" symbol="CLR_LOADER_KEYWORD"/>
                    <keyword name="JitKeyword" mask="0x10" message="$(string.RuntimePublisher.JitKeywordMessage)" symbol="CLR_JIT_KEYWORD"/>
                    <keyword name="NGenKeyword" mask="0x20" message="$(string.RuntimePublisher.NGenKeywordMessage)" symbol="CLR_NGEN_KEYWORD"/>
                    <keyword name="StartEnumerationKeyword" mask="0x40" message="$(string.RuntimePublisher.StartEnumerationKeywordMessage)" symbol="CLR_STARTENUMERATION_KEYWORD"/>
                    <keyword name="EndEnumerationKeyword" mask="0x80" message="$(string.RuntimePublisher.EndEnumerationKeywordMessage)" symbol="CLR_ENDENUMERATION_KEYWORD"/>
                    <!-- Keyword mask 0x100 is now defunct -->
                    <!-- Keyword mask 0x200 is now defunct -->
                    <keyword name="SecurityKeyword" mask="0x400" message="$(string.RuntimePublisher.SecurityKeywordMessage)" symbol="CLR_SECURITY_KEYWORD"/>
                    <keyword name="AppDomainResourceManagementKeyword" mask="0x800" message="$(string.RuntimePublisher.AppDomainResourceManagementKeywordMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_KEYWORD"/>
                    <keyword name="JitTracingKeyword" mask="0x1000" message="$(string.RuntimePublisher.JitTracingKeywordMessage)" symbol="CLR_JITTRACING_KEYWORD"/>
                    <keyword name="InteropKeyword" mask="0x2000" message="$(string.RuntimePublisher.InteropKeywordMessage)" symbol="CLR_INTEROP_KEYWORD"/>
                    <keyword name="ContentionKeyword" mask="0x4000" message="$(string.RuntimePublisher.ContentionKeywordMessage)" symbol="CLR_CONTENTION_KEYWORD"/>
                    <keyword name="ExceptionKeyword" mask="0x8000" message="$(string.RuntimePublisher.ExceptionKeywordMessage)" symbol="CLR_EXCEPTION_KEYWORD"/>
                    <keyword name="ThreadingKeyword" mask="0x10000" message="$(string.RuntimePublisher.ThreadingKeywordMessage)" symbol="CLR_THREADING_KEYWORD"/>
                    <keyword name="JittedMethodILToNativeMapKeyword" mask="0x20000" message="$(string.RuntimePublisher.JittedMethodILToNativeMapKeywordMessage)" symbol="CLR_JITTEDMETHODILTONATIVEMAP_KEYWORD"/>
                    <keyword name="OverrideAndSuppressNGenEventsKeyword" mask="0x40000" message="$(string.RuntimePublisher.OverrideAndSuppressNGenEventsKeywordMessage)" symbol="CLR_OVERRIDEANDSUPPRESSNGENEVENTS_KEYWORD"/>
                    <keyword name="PerfTrackKeyword" mask="0x20000000" message="$(string.RuntimePublisher.PerfTrackKeywordMessage)" symbol="CLR_PERFTRACK_KEYWORD"/>
                    <keyword name="StackKeyword" mask="0x40000000" message="$(string.RuntimePublisher.StackKeywordMessage)" symbol="CLR_STACK_KEYWORD"/>
                </keywords>
                <!--Tasks-->
                <tasks>
                    <task name="GarbageCollection" symbol="CLR_GC_TASK" value="1" eventGUID="{044973cd-251f-4dff-a3e9-9d6307286b05}" message="$(string.RuntimePublisher.GarbageCollectionTaskMessage)">
                        <opcodes>
                            <!-- These opcode use to be 4 through 9 but we added 128 to them to avoid using the reserved range 0-10 -->
                            <opcode name="GCRestartEEEnd" message="$(string.RuntimePublisher.GCRestartEEEndOpcodeMessage)" symbol="CLR_GC_RESTARTEEEND_OPCODE" value="132"> </opcode>
                            <opcode name="GCHeapStats" message="$(string.RuntimePublisher.GCHeapStatsOpcodeMessage)" symbol="CLR_GC_HEAPSTATS_OPCODE" value="133"> </opcode>
                            <opcode name="GCCreateSegment" message="$(string.RuntimePublisher.GCCreateSegmentOpcodeMessage)" symbol="CLR_GC_CREATESEGMENT_OPCODE" value="134"> </opcode>
                            <opcode name="GCFreeSegment" message="$(string.RuntimePublisher.GCFreeSegmentOpcodeMessage)" symbol="CLR_GC_FREESEGMENT_OPCODE" value="135"> </opcode>
                            <opcode name="GCRestartEEBegin" message="$(string.RuntimePublisher.GCRestartEEBeginOpcodeMessage)" symbol="CLR_GC_RESTARTEEBEING_OPCODE" value="136"> </opcode>
                            <opcode name="GCSuspendEEEnd" message="$(string.RuntimePublisher.GCSuspendEEEndOpcodeMessage)" symbol="CLR_GC_SUSPENDEEND_OPCODE" value="137"> </opcode>
                            <opcode name="GCSuspendEEBegin" message="$(string.RuntimePublisher.GCSuspendEEBeginOpcodeMessage)" symbol="CLR_GC_SUSPENDEEBEGIN_OPCODE" value="10"> </opcode>
                            <opcode name="GCAllocationTick" message="$(string.RuntimePublisher.GCAllocationTickOpcodeMessage)" symbol="CLR_GC_ALLOCATIONTICK_OPCODE" value="11"> </opcode>
                            <opcode name="GCCreateConcurrentThread" message="$(string.RuntimePublisher.GCCreateConcurrentThreadOpcodeMessage)" symbol="CLR_GC_CREATECONCURRENTTHREAD_OPCODE" value="12"> </opcode>
                            <opcode name="GCTerminateConcurrentThread" message="$(string.RuntimePublisher.GCTerminateConcurrentThreadOpcodeMessage)" symbol="CLR_GC_TERMINATECONCURRENTTHREAD_OPCODE" value="13"> </opcode>
                            <opcode name="GCFinalizersEnd" message="$(string.RuntimePublisher.GCFinalizersEndOpcodeMessage)" symbol="CLR_GC_FINALIZERSEND_OPCODE" value="15"> </opcode>
                            <opcode name="GCFinalizersBegin" message="$(string.RuntimePublisher.GCFinalizersBeginOpcodeMessage)" symbol="CLR_GC_FINALIZERSBEGIN_OPCODE" value="19"> </opcode>
                        </opcodes>
                    </task>
                    <task name="WorkerThreadCreation" symbol="CLR_WORKERTHREADCREATE_TASK" value="2" eventGUID="{cfc4ba53-fb42-4757-8b70-5f5d51fee2f4}" message="$(string.RuntimePublisher.WorkerThreadCreationTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="IOThreadCreation" symbol="CLR_IOTHREADCREATE_TASK" value="3" eventGUID="{c71408de-42cc-4f81-9c93-b8912abf2a0f}" message="$(string.RuntimePublisher.IOThreadCreationTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="WorkerThreadRetirement" symbol="CLR_WORKERTHREADRETIRE_TASK" value="4" eventGUID="{efdf1eac-1d5d-4e84-893a-19b80f692176}" message="$(string.RuntimePublisher.WorkerThreadRetirementTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="IOThreadRetirement" symbol="CLR_IOTHREADRETIRE_TASK" value="5" eventGUID="{840c8456-6457-4eb7-9cd0-d28f01c64f5e}" message="$(string.RuntimePublisher.IOThreadRetirementTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="ThreadpoolSuspension" symbol="CLR_THREADPOOLSUSPEND_TASK" value="6" eventGUID="{c424b3e3-2ae0-416e-a039-410c5d8e5f14}" message="$(string.RuntimePublisher.ThreadpoolSuspensionTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="Exception" symbol="CLR_EXCEPTION_TASK" value="7" eventGUID="{300ce105-86d1-41f8-b9d2-83fcbff32d99}" message="$(string.RuntimePublisher.ExceptionTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="Contention" symbol="CLR_CONTENTION_TASK" value="8" eventGUID="{561410f5-a138-4ab3-945e-516483cddfbc}" message="$(string.RuntimePublisher.ContentionTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="CLRMethod" symbol="CLR_METHOD_TASK" value="9" eventGUID="{3044F61A-99B0-4c21-B203-D39423C73B00}" message="$(string.RuntimePublisher.MethodTaskMessage)">
                        <opcodes>
                            <!-- The following 2 opcodes are now defunct -->
                            <opcode name="DCStartComplete" message="$(string.RuntimePublisher.DCStartCompleteOpcodeMessage)" symbol="CLR_METHOD_DCSTARTCOMPLETE_OPCODE" value="14"> </opcode>
                            <opcode name="DCEndComplete" message="$(string.RuntimePublisher.DCEndCompleteOpcodeMessage)" symbol="CLR_METHOD_DCENDCOMPLETE_OPCODE" value="15"> </opcode>
                            <opcode name="MethodLoad" message="$(string.RuntimePublisher.MethodLoadOpcodeMessage)" symbol="CLR_METHOD_METHODLOAD_OPCODE" value="33"> </opcode>
                            <opcode name="MethodUnload" message="$(string.RuntimePublisher.MethodUnloadOpcodeMessage)" symbol="CLR_METHOD_METHODUNLOAD_OPCODE" value="34"> </opcode>
                            <!-- The following 2 opcodes are now defunct -->
                            <opcode name="MethodDCStart" message="$(string.RuntimePublisher.MethodDCStartOpcodeMessage)" symbol="CLR_METHOD_METHODDCSTART_OPCODE" value="35"> </opcode>
                            <opcode name="MethodDCEnd" message="$(string.RuntimePublisher.MethodDCEndOpcodeMessage)" symbol="CLR_METHOD_METHODDCEND_OPCODE" value="36"> </opcode>
                            <opcode name="MethodLoadVerbose" message="$(string.RuntimePublisher.MethodLoadVerboseOpcodeMessage)" symbol="CLR_METHOD_METHODLOADVERBOSE_OPCODE" value="37"> </opcode>
                            <opcode name="MethodUnloadVerbose" message="$(string.RuntimePublisher.MethodUnloadVerboseOpcodeMessage)" symbol="CLR_METHOD_METHODUNLOADVERBOSE_OPCODE" value="38"> </opcode>
                            <!-- The following 2 opcodes are now defunct -->
                            <opcode name="MethodDCStartVerbose" message="$(string.RuntimePublisher.MethodDCStartVerboseOpcodeMessage)" symbol="CLR_METHOD_METHODDCSTARTVERBOSE_OPCODE" value="39"> </opcode>
                            <opcode name="MethodDCEndVerbose" message="$(string.RuntimePublisher.MethodDCEndVerboseOpcodeMessage)" symbol="CLR_METHOD_METHODDCENDVERBOSE_OPCODE" value="40"> </opcode>
                            <opcode name="MethodJittingStarted" message="$(string.RuntimePublisher.MethodJittingStartedOpcodeMessage)" symbol="CLR_METHOD_METHODJITTINGSTARTED_OPCODE" value="42"> </opcode>
                            <opcode name="JitInliningSucceeded" message="$(string.RuntimePublisher.JitInliningSucceededOpcodeMessage)" symbol="CLR_JITINLININGSUCCEEDED_OPCODE" value="83"> </opcode>
                            <opcode name="JitInliningFailed" message="$(string.RuntimePublisher.JitInliningFailedOpcodeMessage)" symbol="CLR_JITINLININGFAILED_OPCODE" value="84"> </opcode>
                            <opcode name="JitTailCallSucceeded" message="$(string.RuntimePublisher.JitTailCallSucceededOpcodeMessage)" symbol="CLR_JITTAILCALLSUCCEEDED_OPCODE" value="85"> </opcode>
                            <opcode name="JitTailCallFailed" message="$(string.RuntimePublisher.JitTailCallFailedOpcodeMessage)" symbol="CLR_JITTAILCALLFAILED_OPCODE" value="86"> </opcode>
                            <opcode name="MethodILToNativeMap" message="$(string.RuntimePublisher.MethodILToNativeMapOpcodeMessage)" symbol="CLR_METHODILTONATIVEMAP_OPCODE" value="87"> </opcode>
                        </opcodes>
                    </task>
                    <task name="CLRLoader" symbol="CLR_LOADER_TASK" value="10" eventGUID="{D00792DA-07B7-40f5-97EB-5D974E054740}" message="$(string.RuntimePublisher.LoaderTaskMessage)">
                        <opcodes>
                            <opcode name="DomainModuleLoad" message="$(string.RuntimePublisher.DomainModuleLoadOpcodeMessage)" symbol="CLR_DOMAINMODULELOAD_OPCODE" value="45"> </opcode>
                            <opcode name="ModuleLoad" message="$(string.RuntimePublisher.ModuleLoadOpcodeMessage)" symbol="CLR_MODULELOAD_OPCODE" value="33"> </opcode>
                            <opcode name="ModuleUnload" message="$(string.RuntimePublisher.ModuleUnloadOpcodeMessage)" symbol="CLR_MODULEUNLOAD_OPCODE" value="34"> </opcode>
                            <!-- The following 2 opcodes are now defunct -->
                            <opcode name="ModuleDCStart" message="$(string.RuntimePublisher.ModuleDCStartOpcodeMessage)" symbol="CLR_MODULEDCSTART_OPCODE" value="35"> </opcode>
                            <opcode name="ModuleDCEnd" message="$(string.RuntimePublisher.ModuleDCEndOpcodeMessage)" symbol="CLR_MODULEDCEND_OPCODE" value="36"> </opcode>
                            <opcode name="AssemblyLoad" message="$(string.RuntimePublisher.AssemblyLoadOpcodeMessage)" symbol="CLR_ASSEMBLYLOAD_OPCODE" value="37"> </opcode>
                            <opcode name="AssemblyUnload" message="$(string.RuntimePublisher.AssemblyUnloadOpcodeMessage)" symbol="CLR_ASSEMBLYUNLOAD_OPCODE" value="38"> </opcode>
                            <opcode name="AppDomainLoad" message="$(string.RuntimePublisher.AppDomainLoadOpcodeMessage)" symbol="CLR_APPDOMAINLOAD_OPCODE" value="41"> </opcode>
                            <opcode name="AppDomainUnload" message="$(string.RuntimePublisher.AppDomainUnloadOpcodeMessage)" symbol="CLR_APPDOMAINUNLOAD_OPCODE" value="42"> </opcode>
                        </opcodes>
                    </task>
                    <task name="CLRStack" symbol="CLR_STACK_TASK" value="11" eventGUID="{d3363dc0-243a-4620-a4d0-8a07d772f533}" message="$(string.RuntimePublisher.StackTaskMessage)">
                        <opcodes>
                            <opcode name="CLRStackWalk" message="$(string.RuntimePublisher.CLRStackWalkOpcodeMessage)" symbol="CLR_STACK_STACKWALK_OPCODE" value="82"> </opcode>
                        </opcodes>
                    </task>
                    <task name="CLRStrongNameVerification" symbol="CLR_STRONGNAMEVERIFICATION_TASK" value="12" eventGUID="{15447A14-B523-46ae-B75B-023F900B4393}" message="$(string.RuntimePublisher.StrongNameVerificationTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="CLRAuthenticodeVerification" symbol="CLR_AUTHENTICODEVERIFICATION_TASK" value="13" eventGUID="{B17304D9-5AFA-4da6-9F7B-5A4FA73129B6}" message="$(string.RuntimePublisher.AuthenticodeVerificationTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="AppDomainResourceManagement" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_TASK" value="14" eventGUID="{88e83959-6185-4e0b-95b8-0e4a35df6122}" message="$(string.RuntimePublisher.AppDomainResourceManagementTaskMessage)">
                        <opcodes>
                            <opcode name="AppDomainMemAllocated" message="$(string.RuntimePublisher.AppDomainMemAllocatedOpcodeMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_APPDOMAINMEMALLOCATED_OPCODE" value="48"> </opcode>
                            <opcode name="AppDomainMemSurvived" message="$(string.RuntimePublisher.AppDomainMemSurvivedOpcodeMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_APPDOMAINMEMSURVIVED_OPCODE" value="49"> </opcode>
                            <opcode name="ThreadCreated" message="$(string.RuntimePublisher.ThreadCreatedOpcodeMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_THREADCREATED_OPCODE" value="50"> </opcode>
                            <opcode name="ThreadTerminated" message="$(string.RuntimePublisher.ThreadTerminatedOpcodeMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_THREADTERMINATED_OPCODE" value="51"> </opcode>
                            <opcode name="ThreadDomainEnter" message="$(string.RuntimePublisher.ThreadDomainEnterOpcodeMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_THREADDOMAINENTER_OPCODE" value="52"> </opcode>
                        </opcodes>
                    </task>
                    <task name="CLRILStub" symbol="CLR_IL_STUB" value="15" eventGUID="{D00792DA-07B7-40f5-0000-5D974E054740}" message="$(string.RuntimePublisher.ILStubTaskMessage)">
                        <opcodes>
                            <opcode name="ILStubGenerated" message="$(string.RuntimePublisher.ILStubGeneratedOpcodeMessage)" symbol="CLR_ILSTUB_ILSTUBGENERATED_OPCODE" value="88"> </opcode>
                            <opcode name="ILStubCacheHit" message="$(string.RuntimePublisher.ILStubCacheHitOpcodeMessage)" symbol="CLR_ILSTUB_ILSTUBCACHEHIT_OPCODE" value="89"> </opcode>
                        </opcodes>
                    </task>
                    <task name="ThreadPoolWorkerThread" symbol="CLR_THREADPOOLWORKERTHREAD_TASK" value="16" eventGUID="{8a9a44ab-f681-4271-8810-830dab9f5621}" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="ThreadPoolWorkerThreadRetirement" symbol="CLR_THREADPOOLWORKERTHREADRETIREMENT_TASK" value="17" eventGUID="{402ee399-c137-4dc0-a5ab-3c2dea64ac9c}" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadRetirementTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="ThreadPoolWorkerThreadAdjustment" symbol="CLR_THREADPOOLWORKERTHREADADJUSTMENT_TASK" value="18" eventGUID="{94179831-e99a-4625-8824-23ca5e00ca7d}" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadAdjustmentTaskMessage)">
                        <opcodes>
                            <opcode name="Sample" message="$(string.RuntimePublisher.SampleOpcodeMessage)" symbol="CLR_THREADPOOL_WORKERTHREADADJUSTMENT_SAMPLE_OPCODE" value="100"> </opcode>
                            <opcode name="Adjustment" message="$(string.RuntimePublisher.AdjustmentOpcodeMessage)" symbol="CLR_THREADPOOL_WORKERTHREADADJUSTMENT_ADJUSTMENT_OPCODE" value="101"> </opcode>
                            <opcode name="Stats" message="$(string.RuntimePublisher.StatsOpcodeMessage)" symbol="CLR_THREADPOOL_WORKERTHREADADJUSTMENT_STATS_OPCODE" value="102"> </opcode>
                        </opcodes>
                    </task>
                    <task name="CLRRuntimeInformation" symbol="CLR_EEStartup_TASK" value="19" eventGUID="{CD7D3E32-65FE-40cd-9225-A2577D203FC3}" message="$(string.RuntimePublisher.EEStartupTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="CLRPerfTrack" symbol="CLR_PERFTRACK_TASK" value="20" eventGUID="{EAC685F6-2104-4dec-88FD-91E4254221EC}" message="$(string.RuntimePublisher.PerfTrackTaskMessage)">
                        <opcodes>
                            <opcode name="ModuleRangeLoad" message="$(string.RuntimePublisher.ModuleRangeLoadOpcodeMessage)" symbol="CLR_PERFTRACK_MODULERANGELOAD_OPCODE" value="10"> </opcode>
                        </opcodes>
                    </task>
                </tasks>
                <!--Maps-->
                <maps>
                    <!-- ValueMaps -->
                    <valueMap name="GCSegmentTypeMap">
                        <map value="0x0" message="$(string.RuntimePublisher.GCSegment.SmallObjectHeapMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.GCSegment.LargeObjectHeapMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.GCSegment.ReadOnlyHeapMapMessage)"/>
                    </valueMap>
                    <valueMap name="GCAllocationKindMap">
                        <map value="0x0" message="$(string.RuntimePublisher.GCAllocation.SmallMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.GCAllocation.LargeMapMessage)"/>
                    </valueMap>
                    <valueMap name="GCTypeMap">
                        <map value="0x0" message="$(string.RuntimePublisher.GCType.NonConcurrentGCMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.GCType.BackgroundGCMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.GCType.ForegroundGCMapMessage)"/>
                    </valueMap>
                    <valueMap name="GCReasonMap">
                        <map value="0x0" message="$(string.RuntimePublisher.GCReason.AllocSmallMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.GCReason.InducedMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.GCReason.LowMemoryMapMessage)"/>
                        <map value="0x3" message="$(string.RuntimePublisher.GCReason.EmptyMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.GCReason.AllocLargeMapMessage)"/>
                        <map value="0x5" message="$(string.RuntimePublisher.GCReason.OutOfSpaceSmallObjectHeapMapMessage)"/>
                        <map value="0x6" message="$(string.RuntimePublisher.GCReason.OutOfSpaceLargeObjectHeapMapMessage)"/>
                        <map value="0x7" message="$(string.RuntimePublisher.GCReason.InducedNoForceMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.GCReason.StressMapMessage)"/>
                        <map value="0x9" message="$(string.RuntimePublisher.GCReason.InducedLowMemoryMapMessage)"/>
                    </valueMap>
                    <valueMap name="GCSuspendEEReasonMap">
                        <map value="0x0" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendOtherMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForGCMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForAppDomainShutdownMapMessage)"/>
                        <map value="0x3" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForCodePitchingMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForShutdownMapMessage)"/>
                        <map value="0x5" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForDebuggerMapMessage)"/>
                        <map value="0x6" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForGCPrepMapMessage)"/>
                        <map value="0x7" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForDebuggerSweepMapMessage)"/>
                    </valueMap>
                    <valueMap name="ContentionFlagsMap">
                        <map value="0x0" message="$(string.RuntimePublisher.Contention.ManagedMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.Contention.NativeMapMessage)"/>
                    </valueMap>
                    <valueMap name="TailCallTypeMap">
                        <map value="0x0" message="$(string.RuntimePublisher.TailCallType.OptimizedMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.TailCallType.RecursiveMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.TailCallType.HelperMapMessage)"/>
                    </valueMap>
                    <valueMap name="ThreadAdjustmentReasonMap">
                        <map value="0x0" message="$(string.RuntimePublisher.ThreadAdjustmentReason.WarmupMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.ThreadAdjustmentReason.InitializingMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.ThreadAdjustmentReason.RandomMoveMapMessage)"/>
                        <map value="0x3" message="$(string.RuntimePublisher.ThreadAdjustmentReason.ClimbingMoveMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.ThreadAdjustmentReason.ChangePointMapMessage)"/>
                        <map value="0x5" message="$(string.RuntimePublisher.ThreadAdjustmentReason.StabilizingMapMessage)"/>
                        <map value="0x6" message="$(string.RuntimePublisher.ThreadAdjustmentReason.StarvationMapMessage)"/>
                        <map value="0x7" message="$(string.RuntimePublisher.ThreadAdjustmentReason.ThreadTimedOutMapMessage)"/>
                    </valueMap>
                    <!-- BitMaps -->
                    <bitMap name="ModuleRangeTypeMap">
                        <map value="0x4" message="$(string.RuntimePublisher.ModuleRangeTypeMap.ColdRangeMessage)"/>
                    </bitMap>
                    <bitMap name="AppDomainFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.AppDomain.DefaultMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.AppDomain.ExecutableMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.AppDomain.SharedMapMessage)"/>
                    </bitMap>
                    <bitMap name="AssemblyFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.Assembly.DomainNeutralMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.Assembly.DynamicMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.Assembly.NativeMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.Assembly.CollectibleMapMessage)"/>
                    </bitMap>
                    <bitMap name="ModuleFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.Module.DomainNeutralMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.Module.NativeMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.Module.DynamicMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.Module.ManifestMapMessage)"/>
                    </bitMap>
                    <bitMap name="MethodFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.Method.DynamicMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.Method.GenericMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.Method.HasSharedGenericCodeMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.Method.JittedMapMessage)"/>
                    </bitMap>
                    <bitMap name="StartupModeMap">
                        <map value="0x1" message="$(string.RuntimePublisher.StartupMode.ManagedExeMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.StartupMode.HostedCLRMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.StartupMode.IjwDllMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.StartupMode.ComActivatedMapMessage)"/>
                        <map value="0x10" message="$(string.RuntimePublisher.StartupMode.OtherMapMessage)"/>
                    </bitMap>
                    <bitMap name="RuntimeSkuMap">
                        <map value="0x1" message="$(string.RuntimePublisher.RuntimeSku.DesktopCLRMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.RuntimeSku.CoreCLRMapMessage)"/>
                    </bitMap>
                    <bitMap name="ExceptionThrownFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.ExceptionThrown.HasInnerExceptionMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.ExceptionThrown.NestedMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.ExceptionThrown.ReThrownMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.ExceptionThrown.CorruptedStateMapMessage)"/>
                        <map value="0x10" message="$(string.RuntimePublisher.ExceptionThrown.CLSCompliantMapMessage)"/>
                    </bitMap>
                    <bitMap name="ILStubGeneratedFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.ILStubGenerated.ReverseInteropMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.ILStubGenerated.COMInteropMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.ILStubGenerated.NGenedStubMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.ILStubGenerated.DelegateMapMessage)"/>
                        <map value="0x10" message="$(string.RuntimePublisher.ILStubGenerated.VarArgMapMessage)"/>
                        <map value="0x20" message="$(string.RuntimePublisher.ILStubGenerated.UnmanagedCalleeMapMessage)"/>
                    </bitMap>
                    <bitMap name="StartupFlagsMap">
                        <map value="0x000001" message="$(string.RuntimePublisher.Startup.CONCURRENT_GCMapMessage)"/>
                        <map value="0x000002" message="$(string.RuntimePublisher.Startup.LOADER_OPTIMIZATION_SINGLE_DOMAINMapMessage)"/>
                        <map value="0x000004" message="$(string.RuntimePublisher.Startup.LOADER_OPTIMIZATION_MULTI_DOMAINMapMessage)"/>
                        <map value="0x000010" message="$(string.RuntimePublisher.Startup.LOADER_SAFEMODEMapMessage)"/>
                        <map value="0x000100" message="$(string.RuntimePublisher.Startup.LOADER_SETPREFERENCEMapMessage)"/>
                        <map value="0x001000" message="$(string.RuntimePublisher.Startup.SERVER_GCMapMessage)"/>
                        <map value="0x002000" message="$(string.RuntimePublisher.Startup.HOARD_GC_VMMapMessage)"/>
                        <map value="0x004000" message="$(string.RuntimePublisher.Startup.SINGLE_VERSION_HOSTING_INTERFACEMapMessage)"/>
                        <map value="0x010000" message="$(string.RuntimePublisher.Startup.LEGACY_IMPERSONATIONMapMessage)"/>
                        <map value="0x020000" message="$(string.RuntimePublisher.Startup.DISABLE_COMMITTHREADSTACKMapMessage)"/>
                        <map value="0x040000" message="$(string.RuntimePublisher.Startup.ALWAYSFLOW_IMPERSONATIONMapMessage)"/>
                        <map value="0x080000" message="$(string.RuntimePublisher.Startup.TRIM_GC_COMMITMapMessage)"/>
                        <map value="0x100000" message="$(string.RuntimePublisher.Startup.ETWMapMessage)"/>
                        <map value="0x200000" message="$(string.RuntimePublisher.Startup.SERVER_BUILDMapMessage)"/>
                        <map value="0x400000" message="$(string.RuntimePublisher.Startup.ARMMapMessage)"/>
                    </bitMap>
                </maps>
                <!--Templates-->
                <templates>
                    <template tid="StrongNameVerification">
                        <data name="VerificationFlags" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ErrorCode" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString"/>
                        <UserData>
                            <StrongNameVerification xmlns="myNs">
                                <VerificationFlags> %1 </VerificationFlags>
                                <ErrorCode> %2 </ErrorCode>
                                <FullyQualifiedAssemblyName> %3 </FullyQualifiedAssemblyName>
                            </StrongNameVerification>
                        </UserData>
                    </template>
                    <template tid="StrongNameVerification_V1">
                        <data name="VerificationFlags" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ErrorCode" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <StrongNameVerification_V1 xmlns="myNs">
                                <VerificationFlags> %1 </VerificationFlags>
                                <ErrorCode> %2 </ErrorCode>
                                <FullyQualifiedAssemblyName> %3 </FullyQualifiedAssemblyName>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </StrongNameVerification_V1>
                        </UserData>
                    </template>
                    <template tid="AuthenticodeVerification">
                        <data name="VerificationFlags" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ErrorCode" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ModulePath" inType="win:UnicodeString"/>
                        <UserData>
                            <AuthenticodeVerification xmlns="myNs">
                                <VerificationFlags> %1 </VerificationFlags>
                                <ErrorCode> %2 </ErrorCode>
                                <ModulePath> %3 </ModulePath>
                            </AuthenticodeVerification>
                        </UserData>
                    </template>
                    <template tid="AuthenticodeVerification_V1">
                        <data name="VerificationFlags" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ErrorCode" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ModulePath" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <AuthenticodeVerification_V1 xmlns="myNs">
                                <VerificationFlags> %1 </VerificationFlags>
                                <ErrorCode> %2 </ErrorCode>
                                <ModulePath> %3 </ModulePath>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </AuthenticodeVerification_V1>
                        </UserData>
                    </template>
                    <template tid="RuntimeInformation">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="Sku" inType="win:UInt16" map="RuntimeSkuMap"/>
                        <data name="BclMajorVersion" inType="win:UInt16"/>
                        <data name="BclMinorVersion" inType="win:UInt16"/>
                        <data name="BclBuildNumber" inType="win:UInt16"/>
                        <data name="BclQfeNumber" inType="win:UInt16"/>
                        <data name="VMMajorVersion" inType="win:UInt16"/>
                        <data name="VMMinorVersion" inType="win:UInt16"/>
                        <data name="VMBuildNumber" inType="win:UInt16"/>
                        <data name="VMQfeNumber" inType="win:UInt16"/>
                        <data name="StartupFlags" inType="win:UInt32" map="StartupFlagsMap"/>
                        <data name="StartupMode" inType="win:UInt8" map="StartupModeMap"/>
                        <data name="CommandLine" inType="win:UnicodeString"/>
                        <data name="ComObjectGuid" inType="win:GUID"/>
                        <data name="RuntimeDllPath" inType="win:UnicodeString"/>
                        <UserData>
                            <RuntimeInformation xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <Sku> %2 </Sku>
                                <BclMajorVersion> %3 </BclMajorVersion>
                                <BclMinorVersion> %4 </BclMinorVersion>
                                <BclBuildNumber> %5 </BclBuildNumber>
                                <BclQfeNumber> %6 </BclQfeNumber>
                                <VMMajorVersion> %7 </VMMajorVersion>
                                <VMMinorVersion> %8 </VMMinorVersion>
                                <VMBuildNumber> %9 </VMBuildNumber>
                                <VMQfeNumber> %10 </VMQfeNumber>
                                <StartupFlags> %11 </StartupFlags>
                                <StartupMode> %12 </StartupMode>
                                <CommandLine> %13 </CommandLine>
                                <ComObjectGuid> %14 </ComObjectGuid>
                                <RuntimeDllPath> %15 </RuntimeDllPath>
                            </RuntimeInformation>
                        </UserData>
                    </template>
                    <template tid="GCStart">
                        <data name="Count" inType="win:UInt32" outType="xs:unsignedInt"/>
                        <data name="Reason" inType="win:UInt32" map="GCReasonMap"/>
                        <UserData>
                            <GCStart xmlns="myNs">
                                <Count> %1 </Count>
                                <Reason> %2 </Reason>
                            </GCStart>
                        </UserData>
                    </template>
                    <template tid="GCStart_V1">
                        <data name="Count" inType="win:UInt32" outType="xs:unsignedInt"/>
                        <data name="Depth" inType="win:UInt32" outType="xs:unsignedInt"/>
                        <data name="Reason" inType="win:UInt32" map="GCReasonMap"/>
                        <data name="Type" inType="win:UInt32" map="GCTypeMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCStart_V1 xmlns="myNs">
                                <Count> %1 </Count>
                                <Depth> %2 </Depth>
                                <Reason> %3 </Reason>
                                <Type> %4 </Type>
                                <ClrInstanceID> %5 </ClrInstanceID>
                            </GCStart_V1>
                        </UserData>
                    </template>
                    <template tid="GCEnd">
                        <data name="Count" inType="win:UInt32"/>
                        <data name="Depth" inType="win:UInt16"/>
                        <UserData>
                            <GCEnd xmlns="myNs">
                                <Count> %1 </Count>
                                <Depth> %2 </Depth>
                            </GCEnd>
                        </UserData>
                    </template>
                    <template tid="GCEnd_V1">
                        <data name="Count" inType="win:UInt32"/>
                        <data name="Depth" inType="win:UInt32"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCEnd_V1 xmlns="myNs">
                                <Count> %1 </Count>
                                <Depth> %2 </Depth>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </GCEnd_V1>
                        </UserData>
                    </template>
                    <template tid="GCHeapStats">
                        <data name="GenerationSize0" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="TotalPromotedSize0" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="GenerationSize1" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="TotalPromotedSize1" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="GenerationSize2" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="TotalPromotedSize2" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="GenerationSize3" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="TotalPromotedSize3" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="FinalizationPromotedSize" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="FinalizationPromotedCount" inType="win:UInt64"/>
                        <data name="PinnedObjectCount" inType="win:UInt32"/>
                        <data name="SinkBlockCount" inType="win:UInt32"/>
                        <data name="GCHandleCount" inType="win:UInt32"/>
                        <UserData>
                            <GCHeapStats xmlns="myNs">
                                <GenerationSize0> %1 </GenerationSize0>
                                <TotalPromotedSize0> %2 </TotalPromotedSize0>
                                <GenerationSize1> %3 </GenerationSize1>
                                <TotalPromotedSize1> %4 </TotalPromotedSize1>
                                <GenerationSize2> %5 </GenerationSize2>
                                <TotalPromotedSize2> %6 </TotalPromotedSize2>
                                <GenerationSize3> %7 </GenerationSize3>
                                <TotalPromotedSize3> %8 </TotalPromotedSize3>
                                <FinalizationPromotedSize> %9 </FinalizationPromotedSize>
                                <FinalizationPromotedCount> %10 </FinalizationPromotedCount>
                                <PinnedObjectCount> %11 </PinnedObjectCount>
                                <SinkBlockCount> %12 </SinkBlockCount>
                                <GCHandleCount> %13 </GCHandleCount>
                            </GCHeapStats>
                        </UserData>
                    </template>
                    <template tid="GCHeapStats_V1">
                        <data name="GenerationSize0" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="TotalPromotedSize0" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="GenerationSize1" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="TotalPromotedSize1" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="GenerationSize2" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="TotalPromotedSize2" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="GenerationSize3" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="TotalPromotedSize3" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="FinalizationPromotedSize" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="FinalizationPromotedCount" inType="win:UInt64"/>
                        <data name="PinnedObjectCount" inType="win:UInt32"/>
                        <data name="SinkBlockCount" inType="win:UInt32"/>
                        <data name="GCHandleCount" inType="win:UInt32"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCHeapStats_V1 xmlns="myNs">
                                <GenerationSize0> %1 </GenerationSize0>
                                <TotalPromotedSize0> %2 </TotalPromotedSize0>
                                <GenerationSize1> %3 </GenerationSize1>
                                <TotalPromotedSize1> %4 </TotalPromotedSize1>
                                <GenerationSize2> %5 </GenerationSize2>
                                <TotalPromotedSize2> %6 </TotalPromotedSize2>
                                <GenerationSize3> %7 </GenerationSize3>
                                <TotalPromotedSize3> %8 </TotalPromotedSize3>
                                <FinalizationPromotedSize> %9 </FinalizationPromotedSize>
                                <FinalizationPromotedCount> %10 </FinalizationPromotedCount>
                                <PinnedObjectCount> %11 </PinnedObjectCount>
                                <SinkBlockCount> %12 </SinkBlockCount>
                                <GCHandleCount> %13 </GCHandleCount>
                                <ClrInstanceID> %14 </ClrInstanceID>
                            </GCHeapStats_V1>
                        </UserData>
                    </template>
                    <template tid="GCCreateSegment">
                        <data name="Address" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="Size" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="Type" inType="win:UInt32" map="GCSegmentTypeMap"/>
                        <UserData>
                            <GCCreateSegment xmlns="myNs">
                                <Address> %1 </Address>
                                <Size> %2 </Size>
                                <Type> %3 </Type>
                            </GCCreateSegment>
                        </UserData>
                    </template>
                    <template tid="GCCreateSegment_V1">
                        <data name="Address" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="Size" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="Type" inType="win:UInt32" map="GCSegmentTypeMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCCreateSegment_V1 xmlns="myNs">
                                <Address> %1 </Address>
                                <Size> %2 </Size>
                                <Type> %3 </Type>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </GCCreateSegment_V1>
                        </UserData>
                    </template>
                    <template tid="GCFreeSegment">
                        <data name="Address" inType="win:UInt64" outType="win:HexInt64"/>
                        <UserData>
                            <GCFreeSegment xmlns="myNs">
                                <Address> %1 </Address>
                            </GCFreeSegment>
                        </UserData>
                    </template>
                    <template tid="GCFreeSegment_V1">
                        <data name="Address" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCFreeSegment_V1 xmlns="myNs">
                                <Address> %1 </Address>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </GCFreeSegment_V1>
                        </UserData>
                    </template>
                    <template tid="GCNoUserData">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCNoUserData xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </GCNoUserData>
                        </UserData>
                    </template>
                    <template tid="GCSuspendEE">
                        <data name="Reason" inType="win:UInt16" map="GCSuspendEEReasonMap"/>
                        <UserData>
                            <GCSuspendEE xmlns="myNs">
                                <Reason> %1 </Reason>
                            </GCSuspendEE>
                        </UserData>
                    </template>
                    <template tid="GCSuspendEE_V1">
                        <data name="Reason" inType="win:UInt32" map="GCSuspendEEReasonMap"/>
                        <data name="Count" inType="win:UInt32"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCSuspendEE_V1 xmlns="myNs">
                                <Reason> %1 </Reason>
                                <Count> %2 </Count>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </GCSuspendEE_V1>
                        </UserData>
                    </template>
                    <template tid="GCAllocationTick">
                        <data name="AllocationAmount" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="AllocationKind" inType="win:UInt32" map="GCAllocationKindMap"/>
                        <UserData>
                            <GCAllocationTick xmlns="myNs">
                                <AllocationAmount> %1 </AllocationAmount>
                                <AllocationKind> %2 </AllocationKind>
                            </GCAllocationTick>
                        </UserData>
                    </template>
                    <template tid="GCAllocationTick_V1">
                        <data name="AllocationAmount" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="AllocationKind" inType="win:UInt32" map="GCAllocationKindMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCAllocationTick_V1 xmlns="myNs">
                                <AllocationAmount> %1 </AllocationAmount>
                                <AllocationKind> %2 </AllocationKind>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </GCAllocationTick_V1>
                        </UserData>
                    </template>
                    <template tid="GCAllocationTick_V2">
                        <data name="AllocationAmount" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="AllocationKind" inType="win:UInt32" map="GCAllocationKindMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="AllocationAmount64" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="TypeID" inType="win:Pointer"/>
                        <data name="TypeName" inType="win:UnicodeString"/>
                        <data name="HeapIndex" inType="win:UInt32"/>
                        <UserData>
                            <GCAllocationTick_V2 xmlns="myNs">
                                <AllocationAmount> %1 </AllocationAmount>
                                <AllocationKind> %2 </AllocationKind>
                                <ClrInstanceID> %3 </ClrInstanceID>
                                <AllocationAmount64> %4 </AllocationAmount64>
                                <TypeID> %5 </TypeID>
                                <TypeName> %6 </TypeName>
                                <HeapIndex> %7 </HeapIndex>
                            </GCAllocationTick_V2>
                        </UserData>
                    </template>
                    <template tid="GCCreateConcurrentThread">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCCreateConcurrentThread xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </GCCreateConcurrentThread>
                        </UserData>
                    </template>
                    <template tid="GCTerminateConcurrentThread">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCTerminateConcurrentThread xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </GCTerminateConcurrentThread>
                        </UserData>
                    </template>
                    <template tid="GCFinalizersEnd">
                        <data name="Count" inType="win:UInt32"/>
                        <UserData>
                            <GCFinalizersEnd xmlns="myNs">
                                <Count> %1 </Count>
                            </GCFinalizersEnd>
                        </UserData>
                    </template>
                    <template tid="GCFinalizersEnd_V1">
                        <data name="Count" inType="win:UInt32"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <GCFinalizersEnd_V1 xmlns="myNs">
                                <Count> %1 </Count>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </GCFinalizersEnd_V1>
                        </UserData>
                    </template>
                    <template tid="ClrWorkerThread">
                        <data name="WorkerThreadCount" inType="win:UInt32"/>
                        <data name="RetiredWorkerThreads" inType="win:UInt32"/>
                        <UserData>
                            <WorkerThread xmlns="myNs">
                                <WorkerThreadCount> %1 </WorkerThreadCount>
                                <RetiredWorkerThreads> %2 </RetiredWorkerThreads>
                            </WorkerThread>
                        </UserData>
                    </template>
                    <template tid="IOThread">
                        <data name="IOThreadCount" inType="win:UInt32"/>
                        <data name="RetiredIOThreads" inType="win:UInt32"/>
                        <UserData>
                            <IOThread xmlns="myNs">
                                <IOThreadCount> %1 </IOThreadCount>
                                <RetiredIOThreads> %2 </RetiredIOThreads>
                            </IOThread>
                        </UserData>
                    </template>
                    <template tid="IOThread_V1">
                        <data name="IOThreadCount" inType="win:UInt32"/>
                        <data name="RetiredIOThreads" inType="win:UInt32"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <IOThread_V1 xmlns="myNs">
                                <IOThreadCount> %1 </IOThreadCount>
                                <RetiredIOThreads> %2 </RetiredIOThreads>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </IOThread_V1>
                        </UserData>
                    </template>
                    <template tid="ClrThreadPoolSuspend">
                        <data name="ClrThreadID" inType="win:UInt32"/>
                        <data name="CpuUtilization" inType="win:UInt32"/>
                        <UserData>
                            <CLRThreadPoolSuspend xmlns="myNs">
                                <ClrThreadID> %1 </ClrThreadID>
                                <CpuUtilization> %2 </CpuUtilization>
                            </CLRThreadPoolSuspend>
                        </UserData>
                    </template>
                    <template tid="ThreadPoolWorkerThread">
                        <data name="ActiveWorkerThreadCount" inType="win:UInt32"/>
                        <data name="RetiredWorkerThreadCount" inType="win:UInt32"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <ThreadPoolWorkerThread xmlns="myNs">
                                <ActiveWorkerThreadCount> %1 </ActiveWorkerThreadCount>
                                <RetiredWorkerThreadCount> %2 </RetiredWorkerThreadCount>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </ThreadPoolWorkerThread>
                        </UserData>
                    </template>
                    <template tid="ThreadPoolWorkerThreadAdjustmentSample">
                        <data name="Throughput" inType="win:Double"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <ThreadPoolWorkerThreadAdjustmentSample xmlns="myNs">
                                <Throughput> %1 </Throughput>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </ThreadPoolWorkerThreadAdjustmentSample>
                        </UserData>
                    </template>
                    <template tid="ThreadPoolWorkerThreadAdjustmentAdjustment">
                        <data name="AverageThroughput" inType="win:Double"/>
                        <data name="NewWorkerThreadCount" inType="win:UInt32"/>
                        <data name="Reason" inType="win:UInt32" map="ThreadAdjustmentReasonMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <ThreadPoolWorkerThreadAdjustmentAdjustment xmlns="myNs">
                                <AverageThroughput> %1 </AverageThroughput>
                                <NewWorkerThreadCount> %2 </NewWorkerThreadCount>
                                <Reason> %3 </Reason>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </ThreadPoolWorkerThreadAdjustmentAdjustment>
                        </UserData>
                    </template>
                    <template tid="ThreadPoolWorkerThreadAdjustmentStats">
                        <data name="Duration" inType="win:Double"/>
                        <data name="Throughput" inType="win:Double"/>
                        <data name="ThreadWave" inType="win:Double"/>
                        <data name="ThroughputWave" inType="win:Double"/>
                        <data name="ThroughputErrorEstimate" inType="win:Double"/>
                        <data name="AverageThroughputErrorEstimate" inType="win:Double"/>
                        <data name="ThroughputRatio" inType="win:Double"/>
                        <data name="Confidence" inType="win:Double"/>
                        <data name="NewControlSetting" inType="win:Double"/>
                        <data name="NewThreadWaveMagnitude" inType="win:UInt16"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <ThreadPoolWorkerThreadAdjustmentStats xmlns="myNs">
                                <Duration> %1 </Duration>
                                <Throughput> %2 </Throughput>
                                <ThreadWave> %3 </ThreadWave>
                                <ThroughputWave> %4 </ThroughputWave>
                                <ThroughputErrorEstimate> %5 </ThroughputErrorEstimate>
                                <AverageThroughputErrorEstimate> %6 </AverageThroughputErrorEstimate>
                                <ThroughputRatio> %7 </ThroughputRatio>
                                <Confidence> %8 </Confidence>
                                <NewControlSetting> %9 </NewControlSetting>
                                <NewThreadWaveMagnitude> %10 </NewThreadWaveMagnitude>
                                <ClrInstanceID> %11 </ClrInstanceID>
                            </ThreadPoolWorkerThreadAdjustmentStats>
                        </UserData>
                    </template>
                    <template tid="Exception">
                        <data name="ExceptionType" inType="win:UnicodeString"/>
                        <data name="ExceptionMessage" inType="win:UnicodeString"/>
                        <data name="ExceptionEIP" inType="win:Pointer"/>
                        <data name="ExceptionHRESULT" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ExceptionFlags" inType="win:UInt16" map="ExceptionThrownFlagsMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <Exception xmlns="myNs">
                                <ExceptionType> %1 </ExceptionType>
                                <ExceptionMessage> %2 </ExceptionMessage>
                                <ExceptionEIP> %3 </ExceptionEIP>
                                <ExceptionHRESULT> %4 </ExceptionHRESULT>
                                <ExceptionFlags> %5 </ExceptionFlags>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </Exception>
                        </UserData>
                    </template>
                    <template tid="Contention">
                        <data name="ContentionFlags" inType="win:UInt8" map="ContentionFlagsMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <Contention xmlns="myNs">
                                <ContentionFlags> %1 </ContentionFlags>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </Contention>
                        </UserData>
                    </template>
                    <template tid="DomainModuleLoadUnload">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap"/>
                        <data name="Reserved1" inType="win:UInt32"/>
                        <data name="ModuleILPath" inType="win:UnicodeString"/>
                        <data name="ModuleNativePath" inType="win:UnicodeString"/>
                        <UserData>
                            <DomainModuleLoadUnload xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <AppDomainID> %3 </AppDomainID>
                                <ModuleFlags> %4 </ModuleFlags>
                                <ModuleILPath> %5 </ModuleILPath>
                                <ModuleNativePath> %6 </ModuleNativePath>
                            </DomainModuleLoadUnload>
                        </UserData>
                    </template>
                    <template tid="DomainModuleLoadUnload_V1">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap"/>
                        <data name="Reserved1" inType="win:UInt32"/>
                        <data name="ModuleILPath" inType="win:UnicodeString"/>
                        <data name="ModuleNativePath" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <DomainModuleLoadUnload_V1 xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <AppDomainID> %3 </AppDomainID>
                                <ModuleFlags> %4 </ModuleFlags>
                                <ModuleILPath> %5 </ModuleILPath>
                                <ModuleNativePath> %6 </ModuleNativePath>
                                <ClrInstanceID> %7 </ClrInstanceID>
                            </DomainModuleLoadUnload_V1>
                        </UserData>
                    </template>
                    <template tid="ModuleLoadUnload">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap"/>
                        <data name="Reserved1" inType="win:UInt32"/>
                        <data name="ModuleILPath" inType="win:UnicodeString"/>
                        <data name="ModuleNativePath" inType="win:UnicodeString"/>
                        <UserData>
                            <ModuleLoadUnload xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <ModuleFlags> %3 </ModuleFlags>
                                <ModuleILPath> %4 </ModuleILPath>
                                <ModuleNativePath> %5 </ModuleNativePath>
                            </ModuleLoadUnload>
                        </UserData>
                    </template>
                    <template tid="ModuleLoadUnload_V1">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap"/>
                        <data name="Reserved1" inType="win:UInt32"/>
                        <data name="ModuleILPath" inType="win:UnicodeString"/>
                        <data name="ModuleNativePath" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <ModuleLoadUnload_V1 xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <ModuleFlags> %3 </ModuleFlags>
                                <ModuleILPath> %4 </ModuleILPath>
                                <ModuleNativePath> %5 </ModuleNativePath>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </ModuleLoadUnload_V1>
                        </UserData>
                    </template>
                  <template tid="ModuleLoadUnload_V2">
                      <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                      <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                      <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap"/>
                      <data name="Reserved1" inType="win:UInt32"/>
                      <data name="ModuleILPath" inType="win:UnicodeString"/>
                      <data name="ModuleNativePath" inType="win:UnicodeString"/>
                      <data name="ClrInstanceID" inType="win:UInt16"/>
                      <data name="ManagedPdbSignature" inType="win:GUID"/>
                      <data name="ManagedPdbAge" inType="win:UInt32"/>
                      <data name="ManagedPdbBuildPath" inType="win:UnicodeString"/>
                      <data name="NativePdbSignature" inType="win:GUID"/>
                      <data name="NativePdbAge" inType="win:UInt32"/>
                      <data name="NativePdbBuildPath" inType="win:UnicodeString"/>
                    <UserData>
                          <ModuleLoadUnload_V2 xmlns="myNs">
                              <ModuleID> %1 </ModuleID>
                              <AssemblyID> %2 </AssemblyID>
                              <ModuleFlags> %3 </ModuleFlags>
                              <ModuleILPath> %4 </ModuleILPath>
                              <ModuleNativePath> %5 </ModuleNativePath>
                              <ClrInstanceID> %6 </ClrInstanceID>
                              <ManagedPdbSignature> %7 </ManagedPdbSignature>
                              <ManagedPdbAge> %8 </ManagedPdbAge>
                              <ManagedPdbBuildPath> %9 </ManagedPdbBuildPath>
                              <NativePdbSignature> %10 </NativePdbSignature>
                              <NativePdbAge> %11 </NativePdbAge>
                              <NativePdbBuildPath> %12 </NativePdbBuildPath>
                          </ModuleLoadUnload_V2>
                      </UserData>
                  </template>
                    <template tid="AssemblyLoadUnload">
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyFlags" inType="win:UInt32" map="AssemblyFlagsMap"/>
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString"/>
                        <UserData>
                            <AssemblyLoadUnload xmlns="myNs">
                                <AssemblyID> %1 </AssemblyID>
                                <AppDomainID> %2 </AppDomainID>
                                <AssemblyFlags> %3 </AssemblyFlags>
                                <FullyQualifiedAssemblyName> %4 </FullyQualifiedAssemblyName>
                            </AssemblyLoadUnload>
                        </UserData>
                    </template>
                    <template tid="AssemblyLoadUnload_V1">
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="BindingID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyFlags" inType="win:UInt32" map="AssemblyFlagsMap"/>
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <AssemblyLoadUnload_V1 xmlns="myNs">
                                <AssemblyID> %1 </AssemblyID>
                                <AppDomainID> %2 </AppDomainID>
                                <BindingID> %3 </BindingID>
                                <AssemblyFlags> %4 </AssemblyFlags>
                                <FullyQualifiedAssemblyName> %5 </FullyQualifiedAssemblyName>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </AssemblyLoadUnload_V1>
                        </UserData>
                    </template>
                    <template tid="AppDomainLoadUnload">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainFlags" inType="win:UInt32" map="AppDomainFlagsMap"/>
                        <data name="AppDomainName" inType="win:UnicodeString"/>
                        <UserData>
                            <AppDomainLoadUnload xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <AppDomainFlags> %2 </AppDomainFlags>
                                <AppDomainName> %3 </AppDomainName>
                            </AppDomainLoadUnload>
                        </UserData>
                    </template>
                    <template tid="AppDomainLoadUnload_V1">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainFlags" inType="win:UInt32" map="AppDomainFlagsMap"/>
                        <data name="AppDomainName" inType="win:UnicodeString"/>
                        <data name="AppDomainIndex" inType="win:UInt32"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <AppDomainLoadUnload_V1 xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <AppDomainFlags> %2 </AppDomainFlags>
                                <AppDomainName> %3 </AppDomainName>
                                <AppDomainIndex> %4 </AppDomainIndex>
                                <ClrInstanceID> %5 </ClrInstanceID>
                            </AppDomainLoadUnload_V1>
                        </UserData>
                    </template>
                    <template tid="MethodLoadUnload">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <UserData>
                            <MethodLoadUnload xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                            </MethodLoadUnload>
                        </UserData>
                    </template>
                    <template tid="MethodLoadUnload_V1">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <MethodLoadUnload_V1 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <ClrInstanceID> %7 </ClrInstanceID>
                            </MethodLoadUnload_V1>
                        </UserData>
                    </template>
                    <template tid="MethodLoadUnload_V2">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64"/>
                        <UserData>
                            <MethodLoadUnload_V2 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <ClrInstanceID> %7 </ClrInstanceID>
                                <ReJITID> %8 </ReJITID>
                            </MethodLoadUnload_V2>
                        </UserData>
                    </template>                  
                    <template tid="MethodLoadUnloadVerbose">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <data name="MethodNamespace" inType="win:UnicodeString"/>
                        <data name="MethodName" inType="win:UnicodeString"/>
                        <data name="MethodSignature" inType="win:UnicodeString"/>
                        <UserData>
                            <MethodLoadUnloadVerbose xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                            </MethodLoadUnloadVerbose>
                        </UserData>
                    </template>
                    <template tid="MethodLoadUnloadVerbose_V1">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <data name="MethodNamespace" inType="win:UnicodeString"/>
                        <data name="MethodName" inType="win:UnicodeString"/>
                        <data name="MethodSignature" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <MethodLoadUnloadVerbose_V1 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                                <ClrInstanceID> %10 </ClrInstanceID>
                            </MethodLoadUnloadVerbose_V1>
                        </UserData>
                    </template>
                    <template tid="MethodLoadUnloadVerbose_V2">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <data name="MethodNamespace" inType="win:UnicodeString"/>
                        <data name="MethodName" inType="win:UnicodeString"/>
                        <data name="MethodSignature" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64"/>
                      <UserData>
                          <MethodLoadUnloadVerbose_V2 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                                <ClrInstanceID> %10 </ClrInstanceID>
                                <ReJITID> %11 </ReJITID>
                            </MethodLoadUnloadVerbose_V2>
                        </UserData>
                    </template>
                    <template tid="MethodJittingStarted">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodILSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodNamespace" inType="win:UnicodeString"/>
                        <data name="MethodName" inType="win:UnicodeString"/>
                        <data name="MethodSignature" inType="win:UnicodeString"/>
                        <UserData>
                            <MethodJittingStarted xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodToken> %3 </MethodToken>
                                <MethodILSize> %4 </MethodILSize>
                                <MethodNamespace> %5 </MethodNamespace>
                                <MethodName> %6 </MethodName>
                                <MethodSignature> %7 </MethodSignature>
                            </MethodJittingStarted>
                        </UserData>
                    </template>
                    <template tid="MethodJittingStarted_V1">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodILSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodNamespace" inType="win:UnicodeString"/>
                        <data name="MethodName" inType="win:UnicodeString"/>
                        <data name="MethodSignature" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <MethodJittingStarted_V1 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodToken> %3 </MethodToken>
                                <MethodILSize> %4 </MethodILSize>
                                <MethodNamespace> %5 </MethodNamespace>
                                <MethodName> %6 </MethodName>
                                <MethodSignature> %7 </MethodSignature>
                                <ClrInstanceID> %8 </ClrInstanceID>
                            </MethodJittingStarted_V1>
                        </UserData>
                    </template>
                    <template tid="MethodJitInliningSucceeded">
                        <data name="MethodBeingCompiledNamespace" inType="win:UnicodeString"/>
                        <data name="MethodBeingCompiledName" inType="win:UnicodeString"/>
                        <data name="MethodBeingCompiledNameSignature" inType="win:UnicodeString"/>
                        <data name="InlinerNamespace" inType="win:UnicodeString"/>
                        <data name="InlinerName" inType="win:UnicodeString"/>
                        <data name="InlinerNameSignature" inType="win:UnicodeString"/>
                        <data name="InlineeNamespace" inType="win:UnicodeString"/>
                        <data name="InlineeName" inType="win:UnicodeString"/>
                        <data name="InlineeNameSignature" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <MethodJitInliningSucceeded xmlns="myNs">
                                <MethodBeingCompiledNamespace> %1 </MethodBeingCompiledNamespace>
                                <MethodBeingCompiledName> %2 </MethodBeingCompiledName>
                                <MethodBeingCompiledNameSignature> %3 </MethodBeingCompiledNameSignature>
                                <InlinerNamespace> %4 </InlinerNamespace>
                                <InlinerName> %5 </InlinerName>
                                <InlinerNameSignature> %6 </InlinerNameSignature>
                                <InlineeNamespace> %7 </InlineeNamespace>
                                <InlineeName> %8 </InlineeName>
                                <InlineeNameSignature> %9 </InlineeNameSignature>
                                <ClrInstanceID> %10 </ClrInstanceID>
                            </MethodJitInliningSucceeded>
                        </UserData>
                    </template>
                    <template tid="MethodJitInliningFailed">
                        <data name="MethodBeingCompiledNamespace" inType="win:UnicodeString"/>
                        <data name="MethodBeingCompiledName" inType="win:UnicodeString"/>
                        <data name="MethodBeingCompiledNameSignature" inType="win:UnicodeString"/>
                        <data name="InlinerNamespace" inType="win:UnicodeString"/>
                        <data name="InlinerName" inType="win:UnicodeString"/>
                        <data name="InlinerNameSignature" inType="win:UnicodeString"/>
                        <data name="InlineeNamespace" inType="win:UnicodeString"/>
                        <data name="InlineeName" inType="win:UnicodeString"/>
                        <data name="InlineeNameSignature" inType="win:UnicodeString"/>
                        <data name="FailAlways" inType="win:Boolean"/>
                        <data name="FailReason" inType="win:AnsiString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <MethodJitInliningFailed xmlns="myNs">
                                <MethodBeingCompiledNamespace> %1 </MethodBeingCompiledNamespace>
                                <MethodBeingCompiledName> %2 </MethodBeingCompiledName>
                                <MethodBeingCompiledNameSignature> %3 </MethodBeingCompiledNameSignature>
                                <InlinerNamespace> %4 </InlinerNamespace>
                                <InlinerName> %5 </InlinerName>
                                <InlinerNameSignature> %6 </InlinerNameSignature>
                                <InlineeNamespace> %7 </InlineeNamespace>
                                <InlineeName> %8 </InlineeName>
                                <InlineeNameSignature> %9 </InlineeNameSignature>
                                <FailAlways> %10 </FailAlways>
                                <FailReason> %11 </FailReason>
                                <ClrInstanceID> %12 </ClrInstanceID>
                            </MethodJitInliningFailed>
                        </UserData>
                    </template>
                    <template tid="MethodJitTailCallSucceeded">
                        <data name="MethodBeingCompiledNamespace" inType="win:UnicodeString"/>
                        <data name="MethodBeingCompiledName" inType="win:UnicodeString"/>
                        <data name="MethodBeingCompiledNameSignature" inType="win:UnicodeString"/>
                        <data name="CallerNamespace" inType="win:UnicodeString"/>
                        <data name="CallerName" inType="win:UnicodeString"/>
                        <data name="CallerNameSignature" inType="win:UnicodeString"/>
                        <data name="CalleeNamespace" inType="win:UnicodeString"/>
                        <data name="CalleeName" inType="win:UnicodeString"/>
                        <data name="CalleeNameSignature" inType="win:UnicodeString"/>
                        <data name="TailPrefix" inType="win:Boolean"/>
                        <data name="TailCallType" inType="win:UInt32" map="TailCallTypeMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <MethodJitTailCallSucceeded xmlns="myNs">
                                <MethodBeingCompiledNamespace> %1 </MethodBeingCompiledNamespace>
                                <MethodBeingCompiledName> %2 </MethodBeingCompiledName>
                                <MethodBeingCompiledNameSignature> %3 </MethodBeingCompiledNameSignature>
                                <CallerNamespace> %4 </CallerNamespace>
                                <CallerName> %5 </CallerName>
                                <CallerNameSignature> %6 </CallerNameSignature>
                                <CalleeNamespace> %7 </CalleeNamespace>
                                <CalleeName> %8 </CalleeName>
                                <CalleeNameSignature> %9 </CalleeNameSignature>
                                <TailPrefix> %10 </TailPrefix>
                                <TailCallType> %11 </TailCallType>
                                <ClrInstanceID> %12 </ClrInstanceID>
                            </MethodJitTailCallSucceeded>
                        </UserData>
                    </template>
                    <template tid="MethodJitTailCallFailed">
                        <data name="MethodBeingCompiledNamespace" inType="win:UnicodeString"/>
                        <data name="MethodBeingCompiledName" inType="win:UnicodeString"/>
                        <data name="MethodBeingCompiledNameSignature" inType="win:UnicodeString"/>
                        <data name="CallerNamespace" inType="win:UnicodeString"/>
                        <data name="CallerName" inType="win:UnicodeString"/>
                        <data name="CallerNameSignature" inType="win:UnicodeString"/>
                        <data name="CalleeNamespace" inType="win:UnicodeString"/>
                        <data name="CalleeName" inType="win:UnicodeString"/>
                        <data name="CalleeNameSignature" inType="win:UnicodeString"/>
                        <data name="TailPrefix" inType="win:Boolean"/>
                        <data name="FailReason" inType="win:AnsiString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <MethodJitTailCallFailed xmlns="myNs">
                                <MethodBeingCompiledNamespace> %1 </MethodBeingCompiledNamespace>
                                <MethodBeingCompiledName> %2 </MethodBeingCompiledName>
                                <MethodBeingCompiledNameSignature> %3 </MethodBeingCompiledNameSignature>
                                <CallerNamespace> %4 </CallerNamespace>
                                <CallerName> %5 </CallerName>
                                <CallerNameSignature> %6 </CallerNameSignature>
                                <CalleeNamespace> %7 </CalleeNamespace>
                                <CalleeName> %8 </CalleeName>
                                <CalleeNameSignature> %9 </CalleeNameSignature>
                                <TailPrefix> %10 </TailPrefix>
                                <FailReason> %11 </FailReason>
                                <ClrInstanceID> %12 </ClrInstanceID>
                            </MethodJitTailCallFailed>
                        </UserData>
                    </template>
                    <template tid="MethodILToNativeMap">
                      <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                      <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64"/>
                      <data name="MethodExtent" inType="win:UInt8"/>
                      <data name="CountOfMapEntries" inType="win:UInt16"/>
                      <data name="ILOffsets" count="CountOfMapEntries" inType="win:UInt32"/>
                      <data name="NativeOffsets" count="CountOfMapEntries" inType="win:UInt32"/>
                      <data name="ClrInstanceID" inType="win:UInt16"/>
                      <UserData>
                        <MethodILToNativeMap xmlns="myNs">
                          <MethodID> %1 </MethodID>
                          <ReJITID> %2 </ReJITID>
                          <MethodExtent> %3 </MethodExtent>
                          <CountOfMapEntries> %4 </CountOfMapEntries>
                          <ClrInstanceID> %5 </ClrInstanceID>
                        </MethodILToNativeMap>
                      </UserData>
                    </template>
                    <template tid="ClrStackWalk">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="Reserved1" inType="win:UInt8"/>
                        <data name="Reserved2" inType="win:UInt8"/>
                        <data name="FrameCount" inType="win:UInt32"/>
                        <data name="Stack" count="2" inType="win:Pointer"/>
                    </template>
                    <template tid="AppDomainMemAllocated">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="Allocated" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <AppDomainMemAllocated xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <Allocated> %2 </Allocated>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </AppDomainMemAllocated>
                        </UserData>
                    </template>
                    <template tid="AppDomainMemSurvived">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="Survived" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ProcessSurvived" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <AppDomainMemSurvived xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <Survived> %2 </Survived>
                                <ProcessSurvived> %3 </ProcessSurvived>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </AppDomainMemSurvived>
                        </UserData>
                    </template>
                    <template tid="ThreadCreated">
                        <data name="ManagedThreadID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="Flags" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ManagedThreadIndex" inType="win:UInt32"/>
                        <data name="OSThreadID" inType="win:UInt32"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <ThreadCreated xmlns="myNs">
                                <ManagedThreadID> %1 </ManagedThreadID>
                                <AppDomainID> %2 </AppDomainID>
                                <Flags> %3 </Flags>
                                <ManagedThreadIndex> %4 </ManagedThreadIndex>
                                <OSThreadID> %5 </OSThreadID>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </ThreadCreated>
                        </UserData>
                    </template>
                    <template tid="ThreadTerminatedOrTransition">
                        <data name="ManagedThreadID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <ThreadTerminatedOrTransition xmlns="myNs">
                                <ManagedThreadID> %1 </ManagedThreadID>
                                <AppDomainID> %2 </AppDomainID>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </ThreadTerminatedOrTransition>
                        </UserData>
                    </template>
                    <template tid="ILStubGenerated">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="StubMethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="StubFlags" inType="win:UInt32" map="ILStubGeneratedFlagsMap"/>
                        <data name="ManagedInteropMethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ManagedInteropMethodNamespace" inType="win:UnicodeString"/>
                        <data name="ManagedInteropMethodName" inType="win:UnicodeString"/>
                        <data name="ManagedInteropMethodSignature" inType="win:UnicodeString"/>
                        <data name="NativeMethodSignature" inType="win:UnicodeString"/>
                        <data name="StubMethodSignature" inType="win:UnicodeString"/>
                        <data name="StubMethodILCode" inType="win:UnicodeString"/>
                        <UserData>
                            <ILStubGenerated xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <ModuleID> %2 </ModuleID>
                                <StubMethodID> %3 </StubMethodID>
                                <StubFlags> %4 </StubFlags>
                                <ManagedInteropMethodToken> %5 </ManagedInteropMethodToken>
                                <ManagedInteropMethodNamespace> %6 </ManagedInteropMethodNamespace>
                                <ManagedInteropMethodName> %7 </ManagedInteropMethodName>
                                <ManagedInteropMethodSignature> %8 </ManagedInteropMethodSignature>
                                <NativeMethodSignature> %9 </NativeMethodSignature>
                                <StubMethodSignature> %10 </StubMethodSignature>
                                <StubMethodILCode> %11 </StubMethodILCode>
                            </ILStubGenerated>
                        </UserData>
                    </template>
                    <template tid="ILStubCacheHit">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="StubMethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ManagedInteropMethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ManagedInteropMethodNamespace" inType="win:UnicodeString"/>
                        <data name="ManagedInteropMethodName" inType="win:UnicodeString"/>
                        <data name="ManagedInteropMethodSignature" inType="win:UnicodeString"/>
                        <UserData>
                            <ILStubCacheHit xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <ModuleID> %2 </ModuleID>
                                <StubMethodID> %3 </StubMethodID>
                                <ManagedInteropMethodToken> %4 </ManagedInteropMethodToken>
                                <ManagedInteropMethodNamespace> %5 </ManagedInteropMethodNamespace>
                                <ManagedInteropMethodName> %6 </ManagedInteropMethodName>
                                <ManagedInteropMethodSignature> %7 </ManagedInteropMethodSignature>
                            </ILStubCacheHit>
                        </UserData>
                    </template>
                    <template tid="ModuleRange">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="RangeBegin" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="RangeSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="RangeType" map="ModuleRangeTypeMap" inType="win:UInt8"/>
                        <UserData>
                            <ModuleRange xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <ModuleID> %2 </ModuleID>
                                <RangeBegin> %3 </RangeBegin>
                                <RangeSize> %4 </RangeSize>
                                <RangeType> %5 </RangeType>
                            </ModuleRange>
                        </UserData>
                    </template>
                </templates>
                <events>
                    <!-- CLR GC events, value reserved from 0 to 39-->
                    <!-- Note the opcode's for GC events do include 0 to 9 for backward compatibility, even though
          they don't mean what those predefined opcodes are supposed to mean -->
                    <event value="1" version="0" level="win:Informational" template="GCStart" keywords="GCKeyword" opcode="win:Start" task="GarbageCollection" symbol="GCStart" message="$(string.RuntimePublisher.GCStartEventMessage)"/>
                    <event value="1" version="1" level="win:Informational" template="GCStart_V1" keywords="GCKeyword" opcode="win:Start" task="GarbageCollection" symbol="GCStart_V1" message="$(string.RuntimePublisher.GCStart_V1EventMessage)"/>
                    <event value="2" version="0" level="win:Informational" template="GCEnd" keywords="GCKeyword" opcode="win:Stop" task="GarbageCollection" symbol="GCEnd" message="$(string.RuntimePublisher.GCEndEventMessage)"/>
                    <event value="2" version="1" level="win:Informational" template="GCEnd_V1" keywords="GCKeyword" opcode="win:Stop" task="GarbageCollection" symbol="GCEnd_V1" message="$(string.RuntimePublisher.GCEnd_V1EventMessage)"/>
                    <event value="3" version="0" level="win:Informational" keywords="GCKeyword" opcode="GCRestartEEEnd" task="GarbageCollection" symbol="GCRestartEEEnd" message="$(string.RuntimePublisher.GCRestartEEEndEventMessage)"/>
                    <event value="3" version="1" level="win:Informational" template="GCNoUserData" keywords="GCKeyword" opcode="GCRestartEEEnd" task="GarbageCollection" symbol="GCRestartEEEnd_V1" message="$(string.RuntimePublisher.GCRestartEEEnd_V1EventMessage)"/>
                    <event value="4" version="0" level="win:Informational" template="GCHeapStats" keywords="GCKeyword" opcode="GCHeapStats" task="GarbageCollection" symbol="GCHeapStats" message="$(string.RuntimePublisher.GCHeapStatsEventMessage)"/>
                    <event value="4" version="1" level="win:Informational" template="GCHeapStats_V1" keywords="GCKeyword" opcode="GCHeapStats" task="GarbageCollection" symbol="GCHeapStats_V1" message="$(string.RuntimePublisher.GCHeapStats_V1EventMessage)"/>
                    <event value="5" version="0" level="win:Informational" template="GCCreateSegment" keywords="GCKeyword" opcode="GCCreateSegment" task="GarbageCollection" symbol="GCCreateSegment" message="$(string.RuntimePublisher.GCCreateSegmentEventMessage)"/>
                    <event value="5" version="1" level="win:Informational" template="GCCreateSegment_V1" keywords="GCKeyword" opcode="GCCreateSegment" task="GarbageCollection" symbol="GCCreateSegment_V1" message="$(string.RuntimePublisher.GCCreateSegment_V1EventMessage)"/>
                    <event value="6" version="0" level="win:Informational" template="GCFreeSegment" keywords="GCKeyword" opcode="GCFreeSegment" task="GarbageCollection" symbol="GCFreeSegment" message="$(string.RuntimePublisher.GCFreeSegmentEventMessage)"/>
                    <event value="6" version="1" level="win:Informational" template="GCFreeSegment_V1" keywords="GCKeyword" opcode="GCFreeSegment" task="GarbageCollection" symbol="GCFreeSegment_V1" message="$(string.RuntimePublisher.GCFreeSegment_V1EventMessage)"/>
                    <event value="7" version="0" level="win:Informational" keywords="GCKeyword" opcode="GCRestartEEBegin" task="GarbageCollection" symbol="GCRestartEEBegin" message="$(string.RuntimePublisher.GCRestartEEBeginEventMessage)"/>
                    <event value="7" version="1" level="win:Informational" template="GCNoUserData" keywords="GCKeyword" opcode="GCRestartEEBegin" task="GarbageCollection" symbol="GCRestartEEBegin_V1" message="$(string.RuntimePublisher.GCRestartEEBegin_V1EventMessage)"/>
                    <event value="8" version="0" level="win:Informational" keywords="GCKeyword" opcode="GCSuspendEEEnd" task="GarbageCollection" symbol="GCSuspendEEEnd" message="$(string.RuntimePublisher.GCSuspendEEEndEventMessage)"/>
                    <event value="8" version="1" level="win:Informational" template="GCNoUserData" keywords="GCKeyword" opcode="GCSuspendEEEnd" task="GarbageCollection" symbol="GCSuspendEEEnd_V1" message="$(string.RuntimePublisher.GCSuspendEEEnd_V1EventMessage)"/>
                    <event value="9" version="0" level="win:Informational" template="GCSuspendEE" keywords="GCKeyword" opcode="GCSuspendEEBegin" task="GarbageCollection" symbol="GCSuspendEEBegin" message="$(string.RuntimePublisher.GCSuspendEEEventMessage)"/>
                    <event value="9" version="1" level="win:Informational" template="GCSuspendEE_V1" keywords="GCKeyword" opcode="GCSuspendEEBegin" task="GarbageCollection" symbol="GCSuspendEEBegin_V1" message="$(string.RuntimePublisher.GCSuspendEE_V1EventMessage)"/>
                    <event value="10" version="0" level="win:Verbose" template="GCAllocationTick" keywords="GCKeyword" opcode="GCAllocationTick" task="GarbageCollection" symbol="GCAllocationTick" message="$(string.RuntimePublisher.GCAllocationTickEventMessage)"/>
                    <event value="10" version="1" level="win:Verbose" template="GCAllocationTick_V1" keywords="GCKeyword" opcode="GCAllocationTick" task="GarbageCollection" symbol="GCAllocationTick_V1" message="$(string.RuntimePublisher.GCAllocationTick_V1EventMessage)"/>
                    <event value="10" version="2" level="win:Verbose" template="GCAllocationTick_V2" keywords="GCKeyword" opcode="GCAllocationTick" task="GarbageCollection" symbol="GCAllocationTick_V2" message="$(string.RuntimePublisher.GCAllocationTick_V2EventMessage)"/>
                    <event value="11" version="0" level="win:Informational" keywords="GCKeyword" opcode="GCCreateConcurrentThread" task="GarbageCollection" symbol="GCCreateConcurrentThread" message="$(string.RuntimePublisher.GCCreateConcurrentThreadEventMessage)"/>
                    <event value="11" version="1" level="win:Informational" template="GCCreateConcurrentThread" keywords="GCKeyword ThreadingKeyword" opcode="GCCreateConcurrentThread" task="GarbageCollection" symbol="GCCreateConcurrentThread_V1" message="$(string.RuntimePublisher.GCCreateConcurrentThread_V1EventMessage)"/>
                    <event value="12" version="0" level="win:Informational" keywords="GCKeyword" opcode="GCTerminateConcurrentThread" task="GarbageCollection" symbol="GCTerminateConcurrentThread" message="$(string.RuntimePublisher.GCTerminateConcurrentThreadEventMessage)"/>
                    <event value="12" version="1" level="win:Informational" template="GCTerminateConcurrentThread" keywords="GCKeyword ThreadingKeyword" opcode="GCTerminateConcurrentThread" task="GarbageCollection" symbol="GCTerminateConcurrentThread_V1" message="$(string.RuntimePublisher.GCTerminateConcurrentThread_V1EventMessage)"/>
                    <event value="13" version="0" level="win:Informational" template="GCFinalizersEnd" keywords="GCKeyword" opcode="GCFinalizersEnd" task="GarbageCollection" symbol="GCFinalizersEnd" message="$(string.RuntimePublisher.GCFinalizersEndEventMessage)"/>
                    <event value="13" version="1" level="win:Informational" template="GCFinalizersEnd_V1" keywords="GCKeyword" opcode="GCFinalizersEnd" task="GarbageCollection" symbol="GCFinalizersEnd_V1" message="$(string.RuntimePublisher.GCFinalizersEnd_V1EventMessage)"/>
                    <event value="14" version="0" level="win:Informational" keywords="GCKeyword" opcode="GCFinalizersBegin" task="GarbageCollection" symbol="GCFinalizersBegin" message="$(string.RuntimePublisher.GCFinalizersBeginEventMessage)"/>
                    <event value="14" version="1" level="win:Informational" template="GCNoUserData" keywords="GCKeyword" opcode="GCFinalizersBegin" task="GarbageCollection" symbol="GCFinalizersBegin_V1" message="$(string.RuntimePublisher.GCFinalizersBegin_V1EventMessage)"/>
                    <!-- CLR Threading events, value reserved from 40 to 79 -->
                    <event value="40" version="0" level="win:Informational" template="ClrWorkerThread" keywords="ThreadingKeyword" opcode="win:Start" task="WorkerThreadCreation" symbol="WorkerThreadCreate" message="$(string.RuntimePublisher.WorkerThreadCreateEventMessage)"/>
                    <event value="41" version="0" level="win:Informational" template="ClrWorkerThread" keywords="ThreadingKeyword" opcode="win:Stop" task="WorkerThreadCreation" symbol="WorkerThreadTerminate" message="$(string.RuntimePublisher.WorkerThreadTerminateEventMessage)"/>
                    <event value="42" version="0" level="win:Informational" template="ClrWorkerThread" keywords="ThreadingKeyword" opcode="win:Start" task="WorkerThreadRetirement" symbol="WorkerThreadRetire" message="$(string.RuntimePublisher.WorkerThreadRetirementRetireThreadEventMessage)"/>
                    <event value="43" version="0" level="win:Informational" template="ClrWorkerThread" keywords="ThreadingKeyword" opcode="win:Stop" task="WorkerThreadRetirement" symbol="WorkerThreadUnretire" message="$(string.RuntimePublisher.WorkerThreadRetirementUnretireThreadEventMessage)"/>
                    <event value="44" version="0" level="win:Informational" template="IOThread" keywords="ThreadingKeyword" opcode="win:Start" task="IOThreadCreation" symbol="IOThreadCreate" message="$(string.RuntimePublisher.IOThreadCreateEventMessage)"/>
                    <event value="44" version="1" level="win:Informational" template="IOThread_V1" keywords="ThreadingKeyword" opcode="win:Start" task="IOThreadCreation" symbol="IOThreadCreate_V1" message="$(string.RuntimePublisher.IOThreadCreate_V1EventMessage)"/>
                    <event value="45" version="0" level="win:Informational" template="IOThread" keywords="ThreadingKeyword" opcode="win:Stop" task="IOThreadCreation" symbol="IOThreadTerminate" message="$(string.RuntimePublisher.IOThreadTerminateEventMessage)"/>
                    <event value="45" version="1" level="win:Informational" template="IOThread_V1" keywords="ThreadingKeyword" opcode="win:Stop" task="IOThreadCreation" symbol="IOThreadTerminate_V1" message="$(string.RuntimePublisher.IOThreadTerminate_V1EventMessage)"/>
                    <event value="46" version="0" level="win:Informational" template="IOThread" keywords="ThreadingKeyword" opcode="win:Start" task="IOThreadRetirement" symbol="IOThreadRetire" message="$(string.RuntimePublisher.IOThreadRetirementRetireThreadEventMessage)"/>
                    <event value="46" version="1" level="win:Informational" template="IOThread_V1" keywords="ThreadingKeyword" opcode="win:Start" task="IOThreadRetirement" symbol="IOThreadRetire_V1" message="$(string.RuntimePublisher.IOThreadRetirementRetireThread_V1EventMessage)"/>
                    <event value="47" version="0" level="win:Informational" template="IOThread" keywords="ThreadingKeyword" opcode="win:Stop" task="IOThreadRetirement" symbol="IOThreadUnretire" message="$(string.RuntimePublisher.IOThreadRetirementUnretireThreadEventMessage)"/>
                    <event value="47" version="1" level="win:Informational" template="IOThread_V1" keywords="ThreadingKeyword" opcode="win:Stop" task="IOThreadRetirement" symbol="IOThreadUnretire_V1" message="$(string.RuntimePublisher.IOThreadRetirementUnretireThread_V1EventMessage)"/>
                    <event value="48" version="0" level="win:Informational" template="ClrThreadPoolSuspend" keywords="ThreadingKeyword" opcode="win:Start" task="ThreadpoolSuspension" symbol="ThreadpoolSuspensionSuspendThread" message="$(string.RuntimePublisher.ThreadPoolSuspendSuspendThreadEventMessage)"/>
                    <event value="49" version="0" level="win:Informational" template="ClrThreadPoolSuspend" keywords="ThreadingKeyword" opcode="win:Stop" task="ThreadpoolSuspension" symbol="ThreadpoolSuspensionResumeThread" message="$(string.RuntimePublisher.ThreadPoolSuspendResumeThreadEventMessage)"/>
                    <event value="50" version="0" level="win:Informational" template="ThreadPoolWorkerThread" keywords="ThreadingKeyword" opcode="win:Start" task="ThreadPoolWorkerThread" symbol="ThreadPoolWorkerThreadStart" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadEventMessage)"/>
                    <event value="51" version="0" level="win:Informational" template="ThreadPoolWorkerThread" keywords="ThreadingKeyword" opcode="win:Stop" task="ThreadPoolWorkerThread" symbol="ThreadPoolWorkerThreadStop" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadEventMessage)"/>
                    <event value="52" version="0" level="win:Informational" template="ThreadPoolWorkerThread" keywords="ThreadingKeyword" opcode="win:Start" task="ThreadPoolWorkerThreadRetirement" symbol="ThreadPoolWorkerThreadRetirementStart" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadEventMessage)"/>
                    <event value="53" version="0" level="win:Informational" template="ThreadPoolWorkerThread" keywords="ThreadingKeyword" opcode="win:Stop" task="ThreadPoolWorkerThreadRetirement" symbol="ThreadPoolWorkerThreadRetirementStop" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadEventMessage)"/>
                    <event value="54" version="0" level="win:Informational" template="ThreadPoolWorkerThreadAdjustmentSample" keywords="ThreadingKeyword" opcode="Sample" task="ThreadPoolWorkerThreadAdjustment" symbol="ThreadPoolWorkerThreadAdjustmentSample" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadAdjustmentSampleEventMessage)"/>
                    <event value="55" version="0" level="win:Informational" template="ThreadPoolWorkerThreadAdjustmentAdjustment" keywords="ThreadingKeyword" opcode="Adjustment" task="ThreadPoolWorkerThreadAdjustment" symbol="ThreadPoolWorkerThreadAdjustmentAdjustment" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadAdjustmentAdjustmentEventMessage)"/>
                    <event value="56" version="0" level="win:Verbose" template="ThreadPoolWorkerThreadAdjustmentStats" keywords="ThreadingKeyword" opcode="Stats" task="ThreadPoolWorkerThreadAdjustment" symbol="ThreadPoolWorkerThreadAdjustmentStats" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadAdjustmentStatsEventMessage)"/>
                    <!-- CLR Exception events -->
                    <event value="80" version="0" level="win:Informational" opcode="win:Start" task="Exception" symbol="ExceptionThrown" message="$(string.RuntimePublisher.ExceptionExceptionThrownEventMessage)"/>
                    <event value="80" version="1" level="win:Error" template="Exception" keywords="ExceptionKeyword" opcode="win:Start" task="Exception" symbol="ExceptionThrown_V1" message="$(string.RuntimePublisher.ExceptionExceptionThrown_V1EventMessage)"/>
                    <!-- CLR Contention events -->
                    <event value="81" version="0" level="win:Informational" opcode="win:Start" task="Contention" symbol="Contention" message="$(string.RuntimePublisher.ContentionStartEventMessage)"/>
                    <event value="81" version="1" level="win:Informational" template="Contention" keywords="ContentionKeyword" opcode="win:Start" task="Contention" symbol="ContentionStart_V1" message="$(string.RuntimePublisher.ContentionStart_V1EventMessage)"/>
                    <event value="91" version="0" level="win:Informational" template="Contention" keywords="ContentionKeyword" opcode="win:Stop" task="Contention" symbol="ContentionStop" message="$(string.RuntimePublisher.ContentionStopEventMessage)"/>
                    <!-- CLR Stack events -->
                    <event value="82" version="0" level="win:LogAlways" template="ClrStackWalk" keywords="StackKeyword" opcode="CLRStackWalk" task="CLRStack" symbol="CLRStackWalk" message="$(string.RuntimePublisher.StackEventMessage)"/>
                    <!-- CLR AppDomainResourceManagement events -->
                    <event value="83" version="0" level="win:Informational" template="AppDomainMemAllocated" keywords="AppDomainResourceManagementKeyword" opcode="AppDomainMemAllocated" task="AppDomainResourceManagement" symbol="AppDomainMemAllocated" message="$(string.RuntimePublisher.AppDomainMemAllocatedEventMessage)"/>
                    <event value="84" version="0" level="win:Informational" template="AppDomainMemSurvived" keywords="AppDomainResourceManagementKeyword" opcode="AppDomainMemSurvived" task="AppDomainResourceManagement" symbol="AppDomainMemSurvived" message="$(string.RuntimePublisher.AppDomainMemSurvivedEventMessage)"/>
                    <event value="85" version="0" level="win:Informational" template="ThreadCreated" keywords="AppDomainResourceManagementKeyword ThreadingKeyword" opcode="ThreadCreated" task="AppDomainResourceManagement" symbol="ThreadCreated" message="$(string.RuntimePublisher.ThreadCreatedEventMessage)"/>
                    <event value="86" version="0" level="win:Informational" template="ThreadTerminatedOrTransition" keywords="AppDomainResourceManagementKeyword ThreadingKeyword" opcode="ThreadTerminated" task="AppDomainResourceManagement" symbol="ThreadTerminated" message="$(string.RuntimePublisher.ThreadTerminatedEventMessage)"/>
                    <event value="87" version="0" level="win:Informational" template="ThreadTerminatedOrTransition" keywords="AppDomainResourceManagementKeyword ThreadingKeyword" opcode="ThreadDomainEnter" task="AppDomainResourceManagement" symbol="ThreadDomainEnter" message="$(string.RuntimePublisher.ThreadDomainEnterEventMessage)"/>
                    <!-- CLR Interop events -->
                    <event value="88" version="0" level="win:Informational" template="ILStubGenerated" keywords="InteropKeyword" opcode="ILStubGenerated" task="CLRILStub" symbol="ILStubGenerated" message="$(string.RuntimePublisher.ILStubGeneratedEventMessage)"/>
                    <event value="89" version="0" level="win:Informational" template="ILStubCacheHit" keywords="InteropKeyword" opcode="ILStubCacheHit" task="CLRILStub" symbol="ILStubCacheHit" message="$(string.RuntimePublisher.ILStubCacheHitEventMessage)"/>
                    <!-- CLR Method events -->
                    <!-- The following 6 events are now defunct -->
                    <event value="135" version="0" level="win:Informational" keywords="JitKeyword NGenKeyword" opcode="DCStartComplete" task="CLRMethod" symbol="DCStartCompleteV2" message="$(string.RuntimePublisher.DCStartCompleteEventMessage)"/>
                    <event value="136" version="0" level="win:Informational" keywords="JitKeyword NGenKeyword" opcode="DCEndComplete" task="CLRMethod" symbol="DCEndCompleteV2" message="$(string.RuntimePublisher.DCEndCompleteEventMessage)"/>
                    <event value="137" version="0" level="win:Informational" template="MethodLoadUnload" keywords="JitKeyword NGenKeyword" opcode="MethodDCStart" task="CLRMethod" symbol="MethodDCStartV2" message="$(string.RuntimePublisher.MethodDCStartEventMessage)"/>
                    <event value="138" version="0" level="win:Informational" template="MethodLoadUnload" keywords="JitKeyword NGenKeyword" opcode="MethodDCEnd" task="CLRMethod" symbol="MethodDCEndV2" message="$(string.RuntimePublisher.MethodDCEndEventMessage)"/>
                    <event value="139" version="0" level="win:Informational" template="MethodLoadUnloadVerbose" keywords="JitKeyword NGenKeyword" opcode="MethodDCStartVerbose" task="CLRMethod" symbol="MethodDCStartVerboseV2" message="$(string.RuntimePublisher.MethodDCStartEventMessage)"/>
                    <event value="140" version="0" level="win:Informational" template="MethodLoadUnloadVerbose" keywords="JitKeyword NGenKeyword" opcode="MethodDCEndVerbose" task="CLRMethod" symbol="MethodDCEndVerboseV2" message="$(string.RuntimePublisher.MethodDCEndVerboseEventMessage)"/>
                    <event value="141" version="0" level="win:Informational" template="MethodLoadUnload" keywords="JitKeyword NGenKeyword" opcode="MethodLoad" task="CLRMethod" symbol="MethodLoad" message="$(string.RuntimePublisher.MethodLoadEventMessage)"/>
                    <event value="141" version="1" level="win:Informational" template="MethodLoadUnload_V1" keywords="JitKeyword NGenKeyword" opcode="MethodLoad" task="CLRMethod" symbol="MethodLoad_V1" message="$(string.RuntimePublisher.MethodLoad_V1EventMessage)"/>
                    <event value="141" version="2" level="win:Informational" template="MethodLoadUnload_V2" keywords="JitKeyword NGenKeyword" opcode="MethodLoad" task="CLRMethod" symbol="MethodLoad_V2" message="$(string.RuntimePublisher.MethodLoad_V2EventMessage)"/>
                    <event value="142" version="0" level="win:Informational" template="MethodLoadUnload" keywords="JitKeyword NGenKeyword" opcode="MethodUnload" task="CLRMethod" symbol="MethodUnload" message="$(string.RuntimePublisher.MethodUnloadEventMessage)"/>
                    <event value="142" version="1" level="win:Informational" template="MethodLoadUnload_V1" keywords="JitKeyword NGenKeyword" opcode="MethodUnload" task="CLRMethod" symbol="MethodUnload_V1" message="$(string.RuntimePublisher.MethodUnload_V1EventMessage)"/>
                    <event value="142" version="2" level="win:Informational" template="MethodLoadUnload_V2" keywords="JitKeyword NGenKeyword" opcode="MethodUnload" task="CLRMethod" symbol="MethodUnload_V2" message="$(string.RuntimePublisher.MethodUnload_V2EventMessage)"/>
                    <event value="143" version="0" level="win:Informational" template="MethodLoadUnloadVerbose" keywords="JitKeyword NGenKeyword" opcode="MethodLoadVerbose" task="CLRMethod" symbol="MethodLoadVerbose" message="$(string.RuntimePublisher.MethodLoadVerboseEventMessage)"/>
                    <event value="143" version="1" level="win:Informational" template="MethodLoadUnloadVerbose_V1" keywords="JitKeyword NGenKeyword" opcode="MethodLoadVerbose" task="CLRMethod" symbol="MethodLoadVerbose_V1" message="$(string.RuntimePublisher.MethodLoadVerbose_V1EventMessage)"/>
                    <event value="143" version="2" level="win:Informational" template="MethodLoadUnloadVerbose_V2" keywords="JitKeyword NGenKeyword" opcode="MethodLoadVerbose" task="CLRMethod" symbol="MethodLoadVerbose_V2" message="$(string.RuntimePublisher.MethodLoadVerbose_V2EventMessage)"/>
                    <event value="144" version="0" level="win:Informational" template="MethodLoadUnloadVerbose" keywords="JitKeyword NGenKeyword" opcode="MethodUnloadVerbose" task="CLRMethod" symbol="MethodUnloadVerbose" message="$(string.RuntimePublisher.MethodUnloadVerboseEventMessage)"/>
                    <event value="144" version="1" level="win:Informational" template="MethodLoadUnloadVerbose_V1" keywords="JitKeyword NGenKeyword" opcode="MethodUnloadVerbose" task="CLRMethod" symbol="MethodUnloadVerbose_V1" message="$(string.RuntimePublisher.MethodUnloadVerbose_V1EventMessage)"/>
                    <event value="144" version="2" level="win:Informational" template="MethodLoadUnloadVerbose_V2" keywords="JitKeyword NGenKeyword" opcode="MethodUnloadVerbose" task="CLRMethod" symbol="MethodUnloadVerbose_V2" message="$(string.RuntimePublisher.MethodUnloadVerbose_V2EventMessage)"/>
                    <event value="145" version="0" level="win:Verbose" template="MethodJittingStarted" keywords="JitKeyword" opcode="MethodJittingStarted" task="CLRMethod" symbol="MethodJittingStarted" message="$(string.RuntimePublisher.MethodJittingStartedEventMessage)"/>
                    <event value="145" version="1" level="win:Verbose" template="MethodJittingStarted_V1" keywords="JitKeyword" opcode="MethodJittingStarted" task="CLRMethod" symbol="MethodJittingStarted_V1" message="$(string.RuntimePublisher.MethodJittingStarted_V1EventMessage)"/>
                    <event value="185" version="0" level="win:Verbose" template="MethodJitInliningSucceeded" keywords="JitTracingKeyword" opcode="JitInliningSucceeded" task="CLRMethod" symbol="MethodJitInliningSucceeded" message="$(string.RuntimePublisher.MethodJitInliningSucceededEventMessage)"/>
                    <event value="186" version="0" level="win:Verbose" template="MethodJitInliningFailed" keywords="JitTracingKeyword" opcode="JitInliningFailed" task="CLRMethod" symbol="MethodJitInliningFailed" message="$(string.RuntimePublisher.MethodJitInliningFailedEventMessage)"/>
                    <event value="188" version="0" level="win:Verbose" template="MethodJitTailCallSucceeded" keywords="JitTracingKeyword" opcode="JitTailCallSucceeded" task="CLRMethod" symbol="MethodJitTailCallSucceeded" message="$(string.RuntimePublisher.MethodJitTailCallSucceededEventMessage)"/>
                    <event value="189" version="0" level="win:Verbose" template="MethodJitTailCallFailed" keywords="JitTracingKeyword" opcode="JitTailCallFailed" task="CLRMethod" symbol="MethodJitTailCallFailed" message="$(string.RuntimePublisher.MethodJitTailCallFailedEventMessage)"/>
                    <event value="190" version="0" level="win:Verbose" template="MethodILToNativeMap" keywords="JittedMethodILToNativeMapKeyword" opcode="MethodILToNativeMap" task="CLRMethod" symbol="MethodILToNativeMap" message="$(string.RuntimePublisher.MethodILToNativeMapEventMessage)"/>
                    <!-- CLR Loader events -->
                    <!-- The following 2 events are now defunct -->
                    <event value="149" version="0" level="win:Informational" template="ModuleLoadUnload" keywords="LoaderKeyword" opcode="ModuleDCStart" task="CLRLoader" symbol="ModuleDCStartV2" message="$(string.RuntimePublisher.ModuleDCStartEventMessage)"/>
                    <event value="150" version="0" level="win:Informational" template="ModuleLoadUnload" keywords="LoaderKeyword" opcode="ModuleDCEnd" task="CLRLoader" symbol="ModuleDCEndV2" message="$(string.RuntimePublisher.ModuleDCEndEventMessage)"/>
                    <event value="151" version="0" level="win:Informational" template="DomainModuleLoadUnload" keywords="LoaderKeyword" opcode="DomainModuleLoad" task="CLRLoader" symbol="DomainModuleLoad" message="$(string.RuntimePublisher.DomainModuleLoadEventMessage)"/>
                    <event value="151" version="1" level="win:Informational" template="DomainModuleLoadUnload_V1" keywords="LoaderKeyword" opcode="DomainModuleLoad" task="CLRLoader" symbol="DomainModuleLoad_V1" message="$(string.RuntimePublisher.DomainModuleLoad_V1EventMessage)"/>
                    <event value="152" version="0" level="win:Informational" template="ModuleLoadUnload" keywords="LoaderKeyword" opcode="ModuleLoad" task="CLRLoader" symbol="ModuleLoad" message="$(string.RuntimePublisher.ModuleLoadEventMessage)"/>
                    <event value="152" version="1" level="win:Informational" template="ModuleLoadUnload_V1" keywords="LoaderKeyword PerfTrackKeyword" opcode="ModuleLoad" task="CLRLoader" symbol="ModuleLoad_V1" message="$(string.RuntimePublisher.ModuleLoad_V1EventMessage)"/>
                    <event value="152" version="2" level="win:Informational" template="ModuleLoadUnload_V2" keywords="LoaderKeyword PerfTrackKeyword" opcode="ModuleLoad" task="CLRLoader" symbol="ModuleLoad_V2" message="$(string.RuntimePublisher.ModuleLoad_V2EventMessage)"/>
                    <event value="153" version="0" level="win:Informational" template="ModuleLoadUnload" keywords="LoaderKeyword" opcode="ModuleUnload" task="CLRLoader" symbol="ModuleUnload" message="$(string.RuntimePublisher.ModuleUnloadEventMessage)"/>
                    <event value="153" version="1" level="win:Informational" template="ModuleLoadUnload_V1" keywords="LoaderKeyword PerfTrackKeyword" opcode="ModuleUnload" task="CLRLoader" symbol="ModuleUnload_V1" message="$(string.RuntimePublisher.ModuleUnload_V1EventMessage)"/>
                    <event value="153" version="2" level="win:Informational" template="ModuleLoadUnload_V2" keywords="LoaderKeyword PerfTrackKeyword" opcode="ModuleUnload" task="CLRLoader" symbol="ModuleUnload_V2" message="$(string.RuntimePublisher.ModuleUnload_V2EventMessage)"/>
                    <event value="154" version="0" level="win:Informational" template="AssemblyLoadUnload" keywords="LoaderKeyword" opcode="AssemblyLoad" task="CLRLoader" symbol="AssemblyLoad" message="$(string.RuntimePublisher.AssemblyLoadEventMessage)"/>
                    <event value="154" version="1" level="win:Informational" template="AssemblyLoadUnload_V1" keywords="LoaderKeyword" opcode="AssemblyLoad" task="CLRLoader" symbol="AssemblyLoad_V1" message="$(string.RuntimePublisher.AssemblyLoad_V1EventMessage)"/>
                    <event value="155" version="0" level="win:Informational" template="AssemblyLoadUnload" keywords="LoaderKeyword" opcode="AssemblyUnload" task="CLRLoader" symbol="AssemblyUnload" message="$(string.RuntimePublisher.AssemblyUnloadEventMessage)"/>
                    <event value="155" version="1" level="win:Informational" template="AssemblyLoadUnload_V1" keywords="LoaderKeyword" opcode="AssemblyUnload" task="CLRLoader" symbol="AssemblyUnload_V1" message="$(string.RuntimePublisher.AssemblyUnload_V1EventMessage)"/>
                    <event value="156" version="0" level="win:Informational" template="AppDomainLoadUnload" keywords="LoaderKeyword" opcode="AppDomainLoad" task="CLRLoader" symbol="AppDomainLoad" message="$(string.RuntimePublisher.AppDomainLoadEventMessage)"/>
                    <event value="156" version="1" level="win:Informational" template="AppDomainLoadUnload_V1" keywords="LoaderKeyword" opcode="AppDomainLoad" task="CLRLoader" symbol="AppDomainLoad_V1" message="$(string.RuntimePublisher.AppDomainLoad_V1EventMessage)"/>
                    <event value="157" version="0" level="win:Informational" template="AppDomainLoadUnload" keywords="LoaderKeyword" opcode="AppDomainUnload" task="CLRLoader" symbol="AppDomainUnload" message="$(string.RuntimePublisher.AppDomainUnloadEventMessage)"/>
                    <event value="157" version="1" level="win:Informational" template="AppDomainLoadUnload_V1" keywords="LoaderKeyword" opcode="AppDomainUnload" task="CLRLoader" symbol="AppDomainUnload_V1" message="$(string.RuntimePublisher.AppDomainUnload_V1EventMessage)"/>
                    <event value="158" version="0" level="win:Informational" template="ModuleRange" keywords="PerfTrackKeyword" opcode="ModuleRangeLoad" task="CLRPerfTrack" symbol="ModuleRangeLoad" message="$(string.RuntimePublisher.ModuleRangeLoadEventMessage)"/>
                    <!-- CLR Security events -->
                    <event value="181" version="0" level="win:Verbose" template="StrongNameVerification" keywords="SecurityKeyword" opcode="win:Start" task="CLRStrongNameVerification" symbol="StrongNameVerificationStart" message="$(string.RuntimePublisher.StrongNameVerificationStartEventMessage)"/>
                    <event value="181" version="1" level="win:Verbose" template="StrongNameVerification_V1" keywords="SecurityKeyword" opcode="win:Start" task="CLRStrongNameVerification" symbol="StrongNameVerificationStart_V1" message="$(string.RuntimePublisher.StrongNameVerificationStart_V1EventMessage)"/>
                    <event value="182" version="0" level="win:Informational" template="StrongNameVerification" keywords="SecurityKeyword" opcode="win:Stop" task="CLRStrongNameVerification" symbol="StrongNameVerificationStop" message="$(string.RuntimePublisher.StrongNameVerificationEndEventMessage)"/>
                    <event value="182" version="1" level="win:Informational" template="StrongNameVerification_V1" keywords="SecurityKeyword" opcode="win:Stop" task="CLRStrongNameVerification" symbol="StrongNameVerificationStop_V1" message="$(string.RuntimePublisher.StrongNameVerificationEnd_V1EventMessage)"/>
                    <event value="183" version="0" level="win:Verbose" template="AuthenticodeVerification" keywords="SecurityKeyword" opcode="win:Start" task="CLRAuthenticodeVerification" symbol="AuthenticodeVerificationStart" message="$(string.RuntimePublisher.AuthenticodeVerificationStartEventMessage)"/>
                    <event value="183" version="1" level="win:Verbose" template="AuthenticodeVerification_V1" keywords="SecurityKeyword" opcode="win:Start" task="CLRAuthenticodeVerification" symbol="AuthenticodeVerificationStart_V1" message="$(string.RuntimePublisher.AuthenticodeVerificationStart_V1EventMessage)"/>
                    <event value="184" version="0" level="win:Informational" template="AuthenticodeVerification" keywords="SecurityKeyword" opcode="win:Stop" task="CLRAuthenticodeVerification" symbol="AuthenticodeVerificationStop" message="$(string.RuntimePublisher.AuthenticodeVerificationEndEventMessage)"/>
                    <event value="184" version="1" level="win:Informational" template="AuthenticodeVerification_V1" keywords="SecurityKeyword" opcode="win:Stop" task="CLRAuthenticodeVerification" symbol="AuthenticodeVerificationStop_V1" message="$(string.RuntimePublisher.AuthenticodeVerificationEnd_V1EventMessage)"/>
                    <!-- CLR RuntimeInformation events -->
                    <event value="187" version="0" level="win:Informational" template="RuntimeInformation" opcode="win:Start" task="CLRRuntimeInformation" symbol="RuntimeInformationStart" message="$(string.RuntimePublisher.RuntimeInformationEventMessage)"/>
                </events>
            </provider>
            <!--CLR Rundown Publisher-->
            <provider name="Microsoft-Windows-DotNETRuntimeRundown" guid="{A669021C-C450-4609-A035-5AF59AF4DF18}" symbol="MICROSOFT_WINDOWS_DOTNETRUNTIME_RUNDOWN_PROVIDER" resourceFileName="%WINDIR%\Microsoft.NET\Framework64\v4.0.30319\clretwrc.dll" messageFileName="%WINDIR%\Microsoft.NET\Framework64\v4.0.30319\clretwrc.dll">
                <!--Keywords-->
                <keywords>
                    <keyword name="LoaderRundownKeyword" mask="0x8" message="$(string.RundownPublisher.LoaderKeywordMessage)" symbol="CLR_RUNDOWNLOADER_KEYWORD"/>
                    <keyword name="JitRundownKeyword" mask="0x10" message="$(string.RundownPublisher.JitKeywordMessage)" symbol="CLR_RUNDOWNJIT_KEYWORD"/>
                    <keyword name="NGenRundownKeyword" mask="0x20" message="$(string.RundownPublisher.NGenKeywordMessage)" symbol="CLR_RUNDOWNNGEN_KEYWORD"/>
                    <keyword name="StartRundownKeyword" mask="0x40" message="$(string.RundownPublisher.StartRundownKeywordMessage)" symbol="CLR_RUNDOWNSTART_KEYWORD"/>
                    <keyword name="EndRundownKeyword" mask="0x100" message="$(string.RundownPublisher.EndRundownKeywordMessage)" symbol="CLR_RUNDOWNEND_KEYWORD"/>
                    <!-- Keyword mask 0x200 is now defunct -->
                    <keyword name="AppDomainResourceManagementRundownKeyword" mask="0x800" message="$(string.RuntimePublisher.AppDomainResourceManagementRundownKeywordMessage)" symbol="CLR_RUNDOWNAPPDOMAINRESOURCEMANAGEMENT_KEYWORD"/>
                    <keyword name="ThreadingKeyword" mask="0x10000" message="$(string.RundownPublisher.ThreadingKeywordMessage)" symbol="CLR_RUNDOWNTHREADING_KEYWORD"/>
                    <keyword name="JittedMethodILToNativeMapRundownKeyword" mask="0x20000" message="$(string.RundownPublisher.JittedMethodILToNativeMapRundownKeywordMessage)" symbol="CLR_RUNDOWNJITTEDMETHODILTONATIVEMAP_KEYWORD"/>
                    <keyword name="OverrideAndSuppressNGenEventsRundownKeyword" mask="0x40000" message="$(string.RundownPublisher.OverrideAndSuppressNGenEventsRundownKeywordMessage)" symbol="CLR_RUNDOWNOVERRIDEANDSUPPRESSNGENEVENTS_KEYWORD"/>
                    <keyword name="PerfTrackRundownKeyword" mask="0x20000000" message="$(string.RundownPublisher.PerfTrackRundownKeywordMessage)" symbol="CLR_RUNDOWNPERFTRACK_KEYWORD"/>
                    <keyword name="StackKeyword" mask="0x40000000" message="$(string.RundownPublisher.StackKeywordMessage)" symbol="CLR_RUNDOWNSTACK_KEYWORD"/>
                </keywords>
                <!--Tasks-->
                <tasks>
                    <task name="CLRMethodRundown" symbol="CLR_METHODRUNDOWN_TASK" value="1" eventGUID="{0BCD91DB-F943-454a-A662-6EDBCFBB76D2}" message="$(string.RundownPublisher.MethodTaskMessage)">
                        <opcodes>
                            <opcode name="MethodDCStart" message="$(string.RundownPublisher.MethodDCStartOpcodeMessage)" symbol="CLR_METHODDC_METHODDCSTART_OPCODE" value="35"> </opcode>
                            <opcode name="MethodDCEnd" message="$(string.RundownPublisher.MethodDCEndOpcodeMessage)" symbol="CLR_METHODDC_METHODDCEND_OPCODE" value="36"> </opcode>
                            <opcode name="MethodDCStartVerbose" message="$(string.RundownPublisher.MethodDCStartVerboseOpcodeMessage)" symbol="CLR_METHODDC_METHODDCSTARTVERBOSE_OPCODE" value="39"> </opcode>
                            <opcode name="MethodDCEndVerbose" message="$(string.RundownPublisher.MethodDCEndVerboseOpcodeMessage)" symbol="CLR_METHODDC_METHODDCENDVERBOSE_OPCODE" value="40"> </opcode>
                            <opcode name="MethodDCStartILToNativeMap" message="$(string.RundownPublisher.MethodDCStartILToNativeMapOpcodeMessage)" symbol="CLR_METHODDC_METHODDCSTARTILTONATIVEMAP_OPCODE" value="41"> </opcode>
                            <opcode name="MethodDCEndILToNativeMap" message="$(string.RundownPublisher.MethodDCEndILToNativeMapOpcodeMessage)" symbol="CLR_METHODDC_METHODDCENDILTONATIVEMAP_OPCODE" value="42"> </opcode>
                            <opcode name="DCStartComplete" message="$(string.RundownPublisher.DCStartCompleteOpcodeMessage)" symbol="CLR_METHODDC_DCSTARTCOMPLETE_OPCODE" value="14"> </opcode>
                            <opcode name="DCEndComplete" message="$(string.RundownPublisher.DCEndCompleteOpcodeMessage)" symbol="CLR_METHODDC_DCENDCOMPLETE_OPCODE" value="15"> </opcode>
                            <opcode name="DCStartInit" message="$(string.RundownPublisher.DCStartInitOpcodeMessage)" symbol="CLR_METHODDC_DCSTARTINIT_OPCODE" value="16"> </opcode>
                            <opcode name="DCEndInit" message="$(string.RundownPublisher.DCEndInitOpcodeMessage)" symbol="CLR_METHODDC_DCENDINIT_OPCODE" value="17"> </opcode>
                        </opcodes>
                    </task>
                    <task name="CLRLoaderRundown" symbol="CLR_LOADERRUNDOWN_TASK" value="2" eventGUID="{5A54F4DF-D302-4fee-A211-6C2C0C1DCB1A}" message="$(string.RundownPublisher.LoaderTaskMessage)">
                        <opcodes>
                            <opcode name="ModuleDCStart" message="$(string.RundownPublisher.ModuleDCStartOpcodeMessage)" symbol="CLR_LOADERDC_MODULEDCSTART_OPCODE" value="35"> </opcode>
                            <opcode name="ModuleDCEnd" message="$(string.RundownPublisher.ModuleDCEndOpcodeMessage)" symbol="CLR_LOADERDC_MODULEDCEND_OPCODE" value="36"> </opcode>
                            <opcode name="AssemblyDCStart" message="$(string.RundownPublisher.AssemblyDCStartOpcodeMessage)" symbol="CLR_LOADERDC_ASSEMBLYDCSTART_OPCODE" value="39"> </opcode>
                            <opcode name="AssemblyDCEnd" message="$(string.RundownPublisher.AssemblyDCEndOpcodeMessage)" symbol="CLR_LOADERDC_ASSEMBLYDCEND_OPCODE" value="40"> </opcode>
                            <opcode name="AppDomainDCStart" message="$(string.RundownPublisher.AppDomainDCStartOpcodeMessage)" symbol="CLR_LOADERDC_APPDOMAINDCSTART_OPCODE" value="43"> </opcode>
                            <opcode name="AppDomainDCEnd" message="$(string.RundownPublisher.AppDomainDCEndOpcodeMessage)" symbol="CLR_LOADERDC_APPDOMAINDCEND_OPCODE" value="44"> </opcode>
                            <opcode name="DomainModuleDCStart" message="$(string.RundownPublisher.DomainModuleDCStartOpcodeMessage)" symbol="CLR_LOADERDC_DOMAINMODULEDCSTART_OPCODE" value="46"> </opcode>
                            <opcode name="DomainModuleDCEnd" message="$(string.RundownPublisher.DomainModuleDCEndOpcodeMessage)" symbol="CLR_LOADERDC_DOMAINMODULEDCEND_OPCODE" value="47"> </opcode>
                            <opcode name="ThreadDC" message="$(string.RundownPublisher.ThreadDCOpcodeMessage)" symbol="CLR_LOADERDC_THREADDC_OPCODE" value="48"> </opcode>
                        </opcodes>
                    </task>
                    <task name="CLRStackRundown" symbol="CLR_STACKRUNDOWN_TASK" value="11" eventGUID="{d3363dc0-243a-4620-a4d0-8a07d772f533}" message="$(string.RundownPublisher.StackTaskMessage)">
                        <opcodes>
                            <opcode name="CLRStackWalk" message="$(string.RundownPublisher.CLRStackWalkOpcodeMessage)" symbol="CLR_RUNDOWNSTACK_STACKWALK_OPCODE" value="82"> </opcode>
                        </opcodes>
                    </task>
                    <task name="CLRRuntimeInformationRundown" symbol="CLR_RuntimeInformation_TASK" value="19" eventGUID="{CD7D3E32-65FE-40cd-9225-A2577D203FC3}" message="$(string.RundownPublisher.EEStartupTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="CLRPerfTrackRundown" symbol="CLR_PERFTRACKRUNDOWN_TASK" value="20" eventGUID="{EAC685F6-2104-4dec-88FD-91E4254221EC}" message="$(string.RundownPublisher.PerfTrackTaskMessage)">
                        <opcodes>
                            <opcode name="ModuleRangeDCStart" message="$(string.RundownPublisher.ModuleRangeDCStartOpcodeMessage)" symbol="CLR_PERFTRACKRUNDOWN_MODULERANGEDCSTART_OPCODE" value="10"> </opcode>
                            <opcode name="ModuleRangeDCEnd" message="$(string.RundownPublisher.ModuleRangeDCEndOpcodeMessage)" symbol="CLR_PERFTRACKRUNDOWN_MODULERANGEDCEND_OPCODE" value="11"> </opcode>
                        </opcodes>
                    </task>
                </tasks>
                <maps>
                    <bitMap name="ModuleRangeTypeMap">
                        <map value="0x4" message="$(string.RundownPublisher.ModuleRangeTypeMap.ColdRangeMessage)"/>
                    </bitMap>
                    <!-- BitMaps -->
                    <bitMap name="AppDomainFlagsMap">
                        <map value="0x1" message="$(string.RundownPublisher.AppDomain.DefaultMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.AppDomain.ExecutableMapMessage)"/>
                        <map value="0x4" message="$(string.RundownPublisher.AppDomain.SharedMapMessage)"/>
                    </bitMap>
                    <bitMap name="AssemblyFlagsMap">
                        <map value="0x1" message="$(string.RundownPublisher.Assembly.DomainNeutralMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.Assembly.DynamicMapMessage)"/>
                        <map value="0x4" message="$(string.RundownPublisher.Assembly.NativeMapMessage)"/>
                        <map value="0x8" message="$(string.RundownPublisher.Assembly.CollectibleMapMessage)"/>
                    </bitMap>
                    <bitMap name="ModuleFlagsMap">
                        <map value="0x1" message="$(string.RundownPublisher.Module.DomainNeutralMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.Module.NativeMapMessage)"/>
                        <map value="0x4" message="$(string.RundownPublisher.Module.DynamicMapMessage)"/>
                        <map value="0x8" message="$(string.RundownPublisher.Module.ManifestMapMessage)"/>
                    </bitMap>
                    <bitMap name="MethodFlagsMap">
                        <map value="0x1" message="$(string.RundownPublisher.Method.DynamicMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.Method.GenericMapMessage)"/>
                        <map value="0x4" message="$(string.RundownPublisher.Method.HasSharedGenericCodeMapMessage)"/>
                        <map value="0x8" message="$(string.RundownPublisher.Method.JittedMapMessage)"/>
                    </bitMap>
                    <bitMap name="StartupModeMap">
                        <map value="0x1" message="$(string.RundownPublisher.StartupMode.ManagedExeMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.StartupMode.HostedCLRMapMessage)"/>
                        <map value="0x4" message="$(string.RundownPublisher.StartupMode.IjwDllMapMessage)"/>
                        <map value="0x8" message="$(string.RundownPublisher.StartupMode.ComActivatedMapMessage)"/>
                        <map value="0x10" message="$(string.RundownPublisher.StartupMode.OtherMapMessage)"/>
                    </bitMap>
                    <bitMap name="RuntimeSkuMap">
                        <map value="0x1" message="$(string.RundownPublisher.RuntimeSku.DesktopCLRMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.RuntimeSku.CoreCLRMapMessage)"/>
                    </bitMap>
                    <bitMap name="StartupFlagsMap">
                        <map value="0x000001" message="$(string.RundownPublisher.Startup.CONCURRENT_GCMapMessage)"/>
                        <map value="0x000002" message="$(string.RundownPublisher.Startup.LOADER_OPTIMIZATION_SINGLE_DOMAINMapMessage)"/>
                        <map value="0x000004" message="$(string.RundownPublisher.Startup.LOADER_OPTIMIZATION_MULTI_DOMAINMapMessage)"/>
                        <map value="0x000010" message="$(string.RundownPublisher.Startup.LOADER_SAFEMODEMapMessage)"/>
                        <map value="0x000100" message="$(string.RundownPublisher.Startup.LOADER_SETPREFERENCEMapMessage)"/>
                        <map value="0x001000" message="$(string.RundownPublisher.Startup.SERVER_GCMapMessage)"/>
                        <map value="0x002000" message="$(string.RundownPublisher.Startup.HOARD_GC_VMMapMessage)"/>
                        <map value="0x004000" message="$(string.RundownPublisher.Startup.SINGLE_VERSION_HOSTING_INTERFACEMapMessage)"/>
                        <map value="0x010000" message="$(string.RundownPublisher.Startup.LEGACY_IMPERSONATIONMapMessage)"/>
                        <map value="0x020000" message="$(string.RundownPublisher.Startup.DISABLE_COMMITTHREADSTACKMapMessage)"/>
                        <map value="0x040000" message="$(string.RundownPublisher.Startup.ALWAYSFLOW_IMPERSONATIONMapMessage)"/>
                        <map value="0x080000" message="$(string.RundownPublisher.Startup.TRIM_GC_COMMITMapMessage)"/>
                        <map value="0x100000" message="$(string.RundownPublisher.Startup.ETWMapMessage)"/>
                        <map value="0x200000" message="$(string.RundownPublisher.Startup.SERVER_BUILDMapMessage)"/>
                        <map value="0x400000" message="$(string.RundownPublisher.Startup.ARMMapMessage)"/>
                    </bitMap>
                </maps>
                <!--Templates-->
                <templates>
                    <template tid="RuntimeInformationRundown">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="Sku" inType="win:UInt16" map="RuntimeSkuMap"/>
                        <data name="BclMajorVersion" inType="win:UInt16"/>
                        <data name="BclMinorVersion" inType="win:UInt16"/>
                        <data name="BclBuildNumber" inType="win:UInt16"/>
                        <data name="BclQfeNumber" inType="win:UInt16"/>
                        <data name="VMMajorVersion" inType="win:UInt16"/>
                        <data name="VMMinorVersion" inType="win:UInt16"/>
                        <data name="VMBuildNumber" inType="win:UInt16"/>
                        <data name="VMQfeNumber" inType="win:UInt16"/>
                        <data name="StartupFlags" inType="win:UInt32" map="StartupFlagsMap"/>
                        <data name="StartupMode" inType="win:UInt8" map="StartupModeMap"/>
                        <data name="CommandLine" inType="win:UnicodeString"/>
                        <data name="ComObjectGuid" inType="win:GUID"/>
                        <data name="RuntimeDllPath" inType="win:UnicodeString"/>
                        <UserData>
                            <RuntimeInformationRundown xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <Sku> %2 </Sku>
                                <BclMajorVersion> %3 </BclMajorVersion>
                                <BclMinorVersion> %4 </BclMinorVersion>
                                <BclBuildNumber> %5 </BclBuildNumber>
                                <BclQfeNumber> %6 </BclQfeNumber>
                                <VMMajorVersion> %7 </VMMajorVersion>
                                <VMMinorVersion> %8 </VMMinorVersion>
                                <VMBuildNumber> %9 </VMBuildNumber>
                                <VMQfeNumber> %10 </VMQfeNumber>
                                <StartupFlags> %11 </StartupFlags>
                                <StartupMode> %12 </StartupMode>
                                <CommandLine> %13 </CommandLine>
                                <ComObjectGuid> %14 </ComObjectGuid>
                                <RuntimeDllPath> %15 </RuntimeDllPath>
                            </RuntimeInformationRundown>
                        </UserData>
                    </template>
                    <template tid="DomainModuleLoadUnloadRundown">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap"/>
                        <data name="Reserved1" inType="win:UInt32"/>
                        <data name="ModuleILPath" inType="win:UnicodeString"/>
                        <data name="ModuleNativePath" inType="win:UnicodeString"/>
                        <UserData>
                            <DomainModuleLoadUnloadRundown xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <AppDomainID> %3 </AppDomainID>
                                <ModuleFlags> %4 </ModuleFlags>
                                <ModuleILPath> %5 </ModuleILPath>
                                <ModuleNativePath> %6 </ModuleNativePath>
                            </DomainModuleLoadUnloadRundown>
                        </UserData>
                    </template>
                    <template tid="DomainModuleLoadUnloadRundown_V1">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap"/>
                        <data name="Reserved1" inType="win:UInt32"/>
                        <data name="ModuleILPath" inType="win:UnicodeString"/>
                        <data name="ModuleNativePath" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <DomainModuleLoadUnloadRundown_V1 xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <AppDomainID> %3 </AppDomainID>
                                <ModuleFlags> %4 </ModuleFlags>
                                <ModuleILPath> %5 </ModuleILPath>
                                <ModuleNativePath> %6 </ModuleNativePath>
                                <ClrInstanceID> %7 </ClrInstanceID>
                            </DomainModuleLoadUnloadRundown_V1>
                        </UserData>
                    </template>
                    <template tid="ModuleLoadUnloadRundown">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap"/>
                        <data name="Reserved1" inType="win:UInt32"/>
                        <data name="ModuleILPath" inType="win:UnicodeString"/>
                        <data name="ModuleNativePath" inType="win:UnicodeString"/>
                        <UserData>
                            <ModuleLoadUnloadRundown xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <ModuleFlags> %3 </ModuleFlags>
                                <ModuleILPath> %4 </ModuleILPath>
                                <ModuleNativePath> %5 </ModuleNativePath>
                            </ModuleLoadUnloadRundown>
                        </UserData>
                    </template>
                    <template tid="ModuleLoadUnloadRundown_V1">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap"/>
                        <data name="Reserved1" inType="win:UInt32"/>
                        <data name="ModuleILPath" inType="win:UnicodeString"/>
                        <data name="ModuleNativePath" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <ModuleLoadUnloadRundown_V1 xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <ModuleFlags> %3 </ModuleFlags>
                                <ModuleILPath> %4 </ModuleILPath>
                                <ModuleNativePath> %5 </ModuleNativePath>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </ModuleLoadUnloadRundown_V1>
                        </UserData>
                    </template>
                    <template tid="ModuleLoadUnloadRundown_V2">
                      <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                      <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                      <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap"/>
                      <data name="Reserved1" inType="win:UInt32"/>
                      <data name="ModuleILPath" inType="win:UnicodeString"/>
                      <data name="ModuleNativePath" inType="win:UnicodeString"/>
                      <data name="ClrInstanceID" inType="win:UInt16"/>
                      <data name="ManagedPdbSignature" inType="win:GUID"/>
                      <data name="ManagedPdbAge" inType="win:UInt32"/>
                      <data name="ManagedPdbBuildPath" inType="win:UnicodeString"/>
                      <data name="NativePdbSignature" inType="win:GUID"/>
                      <data name="NativePdbAge" inType="win:UInt32"/>
                      <data name="NativePdbBuildPath" inType="win:UnicodeString"/>
                      <UserData>
                          <ModuleLoadUnloadRundown_V2 xmlns="myNs">
                              <ModuleID> %1 </ModuleID>
                              <AssemblyID> %2 </AssemblyID>
                              <ModuleFlags> %3 </ModuleFlags>
                              <ModuleILPath> %4 </ModuleILPath>
                              <ModuleNativePath> %5 </ModuleNativePath>
                              <ClrInstanceID> %6 </ClrInstanceID>
                              <ManagedPdbSignature> %7 </ManagedPdbSignature>
                              <ManagedPdbAge> %8 </ManagedPdbAge>
                              <ManagedPdbBuildPath> %9 </ManagedPdbBuildPath>
                              <NativePdbSignature> %10 </NativePdbSignature>
                              <NativePdbAge> %11 </NativePdbAge>
                              <NativePdbBuildPath> %12 </NativePdbBuildPath>
                          </ModuleLoadUnloadRundown_V2>
                        </UserData>
                    </template>
                    <template tid="AssemblyLoadUnloadRundown">
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyFlags" inType="win:UInt32" map="AssemblyFlagsMap"/>
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString"/>
                        <UserData>
                            <AssemblyLoadUnloadRundown xmlns="myNs">
                                <AssemblyID> %1 </AssemblyID>
                                <AppDomainID> %2 </AppDomainID>
                                <AssemblyFlags> %3 </AssemblyFlags>
                                <FullyQualifiedAssemblyName> %4 </FullyQualifiedAssemblyName>
                            </AssemblyLoadUnloadRundown>
                        </UserData>
                    </template>
                    <template tid="AssemblyLoadUnloadRundown_V1">
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="BindingID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AssemblyFlags" inType="win:UInt32" map="AssemblyFlagsMap"/>
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <AssemblyLoadUnloadRundown_V1 xmlns="myNs">
                                <AssemblyID> %1 </AssemblyID>
                                <AppDomainID> %2 </AppDomainID>
                                <BindingID> %3 </BindingID>
                                <AssemblyFlags> %4 </AssemblyFlags>
                                <FullyQualifiedAssemblyName> %5 </FullyQualifiedAssemblyName>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </AssemblyLoadUnloadRundown_V1>
                        </UserData>
                    </template>
                    <template tid="AppDomainLoadUnloadRundown">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainFlags" inType="win:UInt32" map="AppDomainFlagsMap"/>
                        <data name="AppDomainName" inType="win:UnicodeString"/>
                        <UserData>
                            <AppDomainLoadUnloadRundown xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <AppDomainFlags> %2 </AppDomainFlags>
                                <AppDomainName> %3 </AppDomainName>
                            </AppDomainLoadUnloadRundown>
                        </UserData>
                    </template>
                    <template tid="AppDomainLoadUnloadRundown_V1">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainFlags" inType="win:UInt32" map="AppDomainFlagsMap"/>
                        <data name="AppDomainName" inType="win:UnicodeString"/>
                        <data name="AppDomainIndex" inType="win:UInt32"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <AppDomainLoadUnloadRundown_V1 xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <AppDomainFlags> %2 </AppDomainFlags>
                                <AppDomainName> %3 </AppDomainName>
                                <AppDomainIndex> %4 </AppDomainIndex>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </AppDomainLoadUnloadRundown_V1>
                        </UserData>
                    </template>
                    <template tid="MethodLoadUnloadRundown">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32"/>
                        <data name="MethodToken" inType="win:UInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <UserData>
                            <MethodLoadUnloadRundown xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                            </MethodLoadUnloadRundown>
                        </UserData>
                    </template>
                    <template tid="MethodLoadUnloadRundown_V1">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <MethodLoadUnloadRundown_V1 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <ClrInstanceID> %7 </ClrInstanceID>
                            </MethodLoadUnloadRundown_V1>
                        </UserData>
                    </template>
                    <template tid="MethodLoadUnloadRundown_V2">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64"/>
                        <UserData>
                            <MethodLoadUnloadRundown_V2 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <ClrInstanceID> %7 </ClrInstanceID>
                                <ReJITID> %8 </ReJITID>
                            </MethodLoadUnloadRundown_V2>
                        </UserData>
                    </template>                  
                    <template tid="MethodLoadUnloadRundownVerbose">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <data name="MethodNamespace" inType="win:UnicodeString"/>
                        <data name="MethodName" inType="win:UnicodeString"/>
                        <data name="MethodSignature" inType="win:UnicodeString"/>
                        <UserData>
                            <MethodLoadUnloadRundownVerbose xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                            </MethodLoadUnloadRundownVerbose>
                        </UserData>
                    </template>
                    <template tid="MethodLoadUnloadRundownVerbose_V1">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <data name="MethodNamespace" inType="win:UnicodeString"/>
                        <data name="MethodName" inType="win:UnicodeString"/>
                        <data name="MethodSignature" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <MethodLoadUnloadRundownVerbose_V1 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                                <ClrInstanceID> %10 </ClrInstanceID>
                            </MethodLoadUnloadRundownVerbose_V1>
                        </UserData>
                    </template>
                    <template tid="MethodLoadUnloadRundownVerbose_V2">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap"/>
                        <data name="MethodNamespace" inType="win:UnicodeString"/>
                        <data name="MethodName" inType="win:UnicodeString"/>
                        <data name="MethodSignature" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64"/>
                        <UserData>
                            <MethodLoadUnloadRundownVerbose_V2 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                                <ClrInstanceID> %10 </ClrInstanceID>
                                <ReJITID> %11 </ReJITID>
                            </MethodLoadUnloadRundownVerbose_V2>
                        </UserData>
                    </template>
                    <template tid="MethodILToNativeMapRundown">
                      <data name="MethodID" inType="win:UInt64" outType="win:HexInt64"/>
                      <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64"/>
                      <data name="MethodExtent" inType="win:UInt8"/>
                      <data name="CountOfMapEntries" inType="win:UInt16"/>
                      <data name="ILOffsets" count="CountOfMapEntries" inType="win:UInt32"/>
                      <data name="NativeOffsets" count="CountOfMapEntries" inType="win:UInt32"/>
                      <data name="ClrInstanceID" inType="win:UInt16"/>
                      <UserData>
                        <MethodILToNativeMap xmlns="myNs">
                          <MethodID> %1 </MethodID>
                          <ReJITID> %2 </ReJITID>
                          <MethodExtent> %3 </MethodExtent>
                          <CountOfMapEntries> %4 </CountOfMapEntries>
                          <ClrInstanceID> %5 </ClrInstanceID>
                        </MethodILToNativeMap>
                      </UserData>
                    </template>
                    <template tid="DCStartEnd">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <DCStartEnd xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </DCStartEnd>
                        </UserData>
                    </template>
                    <template tid="ClrStackWalk">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="Reserved1" inType="win:UInt8"/>
                        <data name="Reserved2" inType="win:UInt8"/>
                        <data name="FrameCount" inType="win:UInt32"/>
                        <data name="Stack" count="2" inType="win:Pointer"/>
                    </template>
                    <template tid="ThreadCreatedRundown">
                        <data name="ManagedThreadID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="Flags" inType="win:UInt32"/>
                        <data name="ManagedThreadIndex" inType="win:UInt32"/>
                        <data name="OSThreadID" inType="win:UInt32"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <UserData>
                            <ThreadCreatedRundown xmlns="myNs">
                                <ManagedThreadID> %1 </ManagedThreadID>
                                <AppDomainID> %2 </AppDomainID>
                                <Flags> %3 </Flags>
                                <ManagedThreadIndex> %4 </ManagedThreadIndex>
                                <OSThreadID> %5 </OSThreadID>
                                <ClrInstanceID> %5 </ClrInstanceID>
                            </ThreadCreatedRundown>
                        </UserData>
                    </template>
                    <template tid="ModuleRangeRundown">
                        <data name="ClrInstanceID" inType="win:UInt16"/>
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64"/>
                        <data name="RangeBegin" count="1" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="RangeSize" count="1" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="RangeType" map="ModuleRangeTypeMap" inType="win:UInt8"/>
                        <UserData>
                            <ModuleRangeRundown xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <ModuleID> %2 </ModuleID>
                                <RangeBegin> %3 </RangeBegin>
                                <RangeSize> %4 </RangeSize>
                                <RangeType> %5 </RangeType>
                            </ModuleRangeRundown>
                        </UserData>
                    </template>
                </templates>
                <events>
                    <!-- CLR StackWalk Rundown Events -->
                    <event value="0" version="0" level="win:LogAlways" template="ClrStackWalk" keywords="StackKeyword" opcode="CLRStackWalk" task="CLRStackRundown" symbol="CLRStackWalkDCStart" message="$(string.RundownPublisher.StackEventMessage)"/>
                    <!-- CLR Method Rundown Events -->
                    <event value="141" version="0" level="win:Informational" template="MethodLoadUnloadRundown" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStart" task="CLRMethodRundown" symbol="MethodDCStart" message="$(string.RundownPublisher.MethodDCStartEventMessage)"/>
                    <event value="141" version="1" level="win:Informational" template="MethodLoadUnloadRundown_V1" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStart" task="CLRMethodRundown" symbol="MethodDCStart_V1" message="$(string.RundownPublisher.MethodDCStart_V1EventMessage)"/>
                    <event value="141" version="2" level="win:Informational" template="MethodLoadUnloadRundown_V2" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStart" task="CLRMethodRundown" symbol="MethodDCStart_V2" message="$(string.RundownPublisher.MethodDCStart_V2EventMessage)"/>
                    <event value="142" version="0" level="win:Informational" template="MethodLoadUnloadRundown" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEnd" task="CLRMethodRundown" symbol="MethodDCEnd" message="$(string.RundownPublisher.MethodDCEndEventMessage)"/>
                    <event value="142" version="1" level="win:Informational" template="MethodLoadUnloadRundown_V1" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEnd" task="CLRMethodRundown" symbol="MethodDCEnd_V1" message="$(string.RundownPublisher.MethodDCEnd_V1EventMessage)"/>
                    <event value="142" version="2" level="win:Informational" template="MethodLoadUnloadRundown_V2" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEnd" task="CLRMethodRundown" symbol="MethodDCEnd_V2" message="$(string.RundownPublisher.MethodDCEnd_V2EventMessage)"/>
                    <event value="143" version="0" level="win:Informational" template="MethodLoadUnloadRundownVerbose" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStartVerbose" task="CLRMethodRundown" symbol="MethodDCStartVerbose" message="$(string.RundownPublisher.MethodDCStartVerboseEventMessage)"/>
                    <event value="143" version="1" level="win:Informational" template="MethodLoadUnloadRundownVerbose_V1" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStartVerbose" task="CLRMethodRundown" symbol="MethodDCStartVerbose_V1" message="$(string.RundownPublisher.MethodDCStartVerbose_V1EventMessage)"/>
                    <event value="143" version="2" level="win:Informational" template="MethodLoadUnloadRundownVerbose_V2" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStartVerbose" task="CLRMethodRundown" symbol="MethodDCStartVerbose_V2" message="$(string.RundownPublisher.MethodDCStartVerbose_V2EventMessage)"/>
                    <event value="144" version="0" level="win:Informational" template="MethodLoadUnloadRundownVerbose" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEndVerbose" task="CLRMethodRundown" symbol="MethodDCEndVerbose" message="$(string.RundownPublisher.MethodDCEndVerboseEventMessage)"/>
                    <event value="144" version="1" level="win:Informational" template="MethodLoadUnloadRundownVerbose_V1" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEndVerbose" task="CLRMethodRundown" symbol="MethodDCEndVerbose_V1" message="$(string.RundownPublisher.MethodDCEndVerbose_V1EventMessage)"/>
                    <event value="144" version="2" level="win:Informational" template="MethodLoadUnloadRundownVerbose_V2" keywords="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEndVerbose" task="CLRMethodRundown" symbol="MethodDCEndVerbose_V2" message="$(string.RundownPublisher.MethodDCEndVerbose_V2EventMessage)"/>
                    <event value="145" version="0" level="win:Informational" keywords="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCStartComplete" task="CLRMethodRundown" symbol="DCStartComplete"/>
                    <event value="145" version="1" level="win:Informational" template="DCStartEnd" keywords="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCStartComplete" task="CLRMethodRundown" symbol="DCStartComplete_V1" message="$(string.RundownPublisher.DCStartCompleteEventMessage)"/>
                    <event value="146" version="0" level="win:Informational" keywords="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCEndComplete" task="CLRMethodRundown" symbol="DCEndComplete"/>
                    <event value="146" version="1" level="win:Informational" template="DCStartEnd" keywords="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCEndComplete" task="CLRMethodRundown" symbol="DCEndComplete_V1" message="$(string.RundownPublisher.DCEndCompleteEventMessage)"/>
                    <event value="147" version="0" level="win:Informational" keywords="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCStartInit" task="CLRMethodRundown" symbol="DCStartInit"/>
                    <event value="147" version="1" level="win:Informational" template="DCStartEnd" keywords="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCStartInit" task="CLRMethodRundown" symbol="DCStartInit_V1" message="$(string.RundownPublisher.DCStartInitEventMessage)"/>
                    <event value="148" version="0" level="win:Informational" keywords="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCEndInit" task="CLRMethodRundown" symbol="DCEndInit"/>
                    <event value="148" version="1" level="win:Informational" template="DCStartEnd" keywords="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCEndInit" task="CLRMethodRundown" symbol="DCEndInit_V1" message="$(string.RundownPublisher.DCEndInitEventMessage)"/>
                    <event value="149" version="0" level="win:Verbose" template="MethodILToNativeMapRundown" keywords="JittedMethodILToNativeMapRundownKeyword" opcode="MethodDCStartILToNativeMap" task="CLRMethodRundown" symbol="MethodDCStartILToNativeMap" message="$(string.RundownPublisher.MethodDCStartILToNativeMapEventMessage)"/>
                    <event value="150" version="0" level="win:Verbose" template="MethodILToNativeMapRundown" keywords="JittedMethodILToNativeMapRundownKeyword" opcode="MethodDCEndILToNativeMap" task="CLRMethodRundown" symbol="MethodDCEndILToNativeMap" message="$(string.RundownPublisher.MethodDCEndILToNativeMapEventMessage)"/>
                    <!-- CLR Loader Rundown Events -->
                    <event value="151" version="0" level="win:Informational" template="DomainModuleLoadUnloadRundown" keywords="LoaderRundownKeyword" opcode="DomainModuleDCStart" task="CLRLoaderRundown" symbol="DomainModuleDCStart" message="$(string.RundownPublisher.DomainModuleDCStartEventMessage)"/>
                    <event value="151" version="1" level="win:Informational" template="DomainModuleLoadUnloadRundown_V1" keywords="LoaderRundownKeyword" opcode="DomainModuleDCStart" task="CLRLoaderRundown" symbol="DomainModuleDCStart_V1" message="$(string.RundownPublisher.DomainModuleDCStart_V1EventMessage)"/>
                    <event value="152" version="0" level="win:Informational" template="DomainModuleLoadUnloadRundown" keywords="LoaderRundownKeyword" opcode="DomainModuleDCEnd" task="CLRLoaderRundown" symbol="DomainModuleDCEnd" message="$(string.RundownPublisher.DomainModuleDCEndEventMessage)"/>
                    <event value="152" version="1" level="win:Informational" template="DomainModuleLoadUnloadRundown_V1" keywords="LoaderRundownKeyword" opcode="DomainModuleDCEnd" task="CLRLoaderRundown" symbol="DomainModuleDCEnd_V1" message="$(string.RundownPublisher.DomainModuleDCEnd_V1EventMessage)"/>
                    <event value="153" version="0" level="win:Informational" template="ModuleLoadUnloadRundown" keywords="LoaderRundownKeyword" opcode="ModuleDCStart" task="CLRLoaderRundown" symbol="ModuleDCStart" message="$(string.RundownPublisher.ModuleDCStartEventMessage)"/>
                    <event value="153" version="1" level="win:Informational" template="ModuleLoadUnloadRundown_V1" keywords="LoaderRundownKeyword PerfTrackRundownKeyword" opcode="ModuleDCStart" task="CLRLoaderRundown" symbol="ModuleDCStart_V1" message="$(string.RundownPublisher.ModuleDCStart_V1EventMessage)"/>
                    <event value="153" version="2" level="win:Informational" template="ModuleLoadUnloadRundown_V2" keywords="LoaderRundownKeyword PerfTrackRundownKeyword" opcode="ModuleDCStart" task="CLRLoaderRundown" symbol="ModuleDCStart_V2" message="$(string.RundownPublisher.ModuleDCStart_V2EventMessage)"/>
                    <event value="154" version="0" level="win:Informational" template="ModuleLoadUnloadRundown" keywords="LoaderRundownKeyword" opcode="ModuleDCEnd" task="CLRLoaderRundown" symbol="ModuleDCEnd" message="$(string.RundownPublisher.ModuleDCEndEventMessage)"/>
                    <event value="154" version="1" level="win:Informational" template="ModuleLoadUnloadRundown_V1" keywords="LoaderRundownKeyword PerfTrackRundownKeyword" opcode="ModuleDCEnd" task="CLRLoaderRundown" symbol="ModuleDCEnd_V1" message="$(string.RundownPublisher.ModuleDCEnd_V1EventMessage)"/>
                    <event value="154" version="2" level="win:Informational" template="ModuleLoadUnloadRundown_V2" keywords="LoaderRundownKeyword PerfTrackRundownKeyword" opcode="ModuleDCEnd" task="CLRLoaderRundown" symbol="ModuleDCEnd_V2" message="$(string.RundownPublisher.ModuleDCEnd_V2EventMessage)"/>
                    <event value="155" version="0" level="win:Informational" template="AssemblyLoadUnloadRundown" keywords="LoaderRundownKeyword" opcode="AssemblyDCStart" task="CLRLoaderRundown" symbol="AssemblyDCStart" message="$(string.RundownPublisher.AssemblyDCStartEventMessage)"/>
                    <event value="155" version="1" level="win:Informational" template="AssemblyLoadUnloadRundown_V1" keywords="LoaderRundownKeyword" opcode="AssemblyDCStart" task="CLRLoaderRundown" symbol="AssemblyDCStart_V1" message="$(string.RundownPublisher.AssemblyDCStart_V1EventMessage)"/>
                    <event value="156" version="0" level="win:Informational" template="AssemblyLoadUnloadRundown" keywords="LoaderRundownKeyword" opcode="AssemblyDCEnd" task="CLRLoaderRundown" symbol="AssemblyDCEnd" message="$(string.RundownPublisher.AssemblyDCEndEventMessage)"/>
                    <event value="156" version="1" level="win:Informational" template="AssemblyLoadUnloadRundown_V1" keywords="LoaderRundownKeyword" opcode="AssemblyDCEnd" task="CLRLoaderRundown" symbol="AssemblyDCEnd_V1" message="$(string.RundownPublisher.AssemblyDCEnd_V1EventMessage)"/>
                    <event value="157" version="0" level="win:Informational" template="AppDomainLoadUnloadRundown" keywords="LoaderRundownKeyword" opcode="AppDomainDCStart" task="CLRLoaderRundown" symbol="AppDomainDCStart" message="$(string.RundownPublisher.AppDomainDCStartEventMessage)"/>
                    <event value="157" version="1" level="win:Informational" template="AppDomainLoadUnloadRundown_V1" keywords="LoaderRundownKeyword" opcode="AppDomainDCStart" task="CLRLoaderRundown" symbol="AppDomainDCStart_V1" message="$(string.RundownPublisher.AppDomainDCStart_V1EventMessage)"/>
                    <event value="158" version="0" level="win:Informational" template="AppDomainLoadUnloadRundown" keywords="LoaderRundownKeyword" opcode="AppDomainDCEnd" task="CLRLoaderRundown" symbol="AppDomainDCEnd" message="$(string.RundownPublisher.AppDomainDCEndEventMessage)"/>
                    <event value="158" version="1" level="win:Informational" template="AppDomainLoadUnloadRundown_V1" keywords="LoaderRundownKeyword" opcode="AppDomainDCEnd" task="CLRLoaderRundown" symbol="AppDomainDCEnd_V1" message="$(string.RundownPublisher.AppDomainDCEnd_V1EventMessage)"/>
                    <event value="159" version="0" level="win:Informational" template="ThreadCreatedRundown" keywords="AppDomainResourceManagementRundownKeyword ThreadingKeyword" opcode="ThreadDC" task="CLRLoaderRundown" symbol="ThreadDC" message="$(string.RundownPublisher.ThreadCreatedEventMessage)"/>
                    <event value="160" version="0" level="win:Informational" template="ModuleRangeRundown" keywords="PerfTrackRundownKeyword" opcode="ModuleRangeDCStart" task="CLRPerfTrackRundown" symbol="ModuleRangeDCStart" message="$(string.RundownPublisher.ModuleRangeDCStartEventMessage)"/>
                    <event value="161" version="0" level="win:Informational" template="ModuleRangeRundown" keywords="PerfTrackRundownKeyword" opcode="ModuleRangeDCEnd" task="CLRPerfTrackRundown" symbol="ModuleRangeDCEnd" message="$(string.RundownPublisher.ModuleRangeDCEndEventMessage)"/>
                    <!-- CLR Runtime Information events for rundown -->
                    <event value="187" version="0" level="win:Informational" template="RuntimeInformationRundown" opcode="win:Start" task="CLRRuntimeInformationRundown" symbol="RuntimeInformationDCStart" message="$(string.RundownPublisher.RuntimeInformationEventMessage)"/>
                </events>
            </provider>
            <!-- CLR Private Publisher-->
        </events>
    </instrumentation>
    <localization>
        <resources culture="en-US">
            <stringTable>
                <!--Message Strings-->
                <!-- Event Messages -->
                <string id="RuntimePublisher.GCStartEventMessage" value="Count=%1;%nReason=%2"/>
                <string id="RuntimePublisher.GCStart_V1EventMessage" value="Count=%1;%nDepth=%2;%nReason=%3;%nType=%4;%nClrInstanceID=%5"/>
                <string id="RuntimePublisher.GCEndEventMessage" value="Count=%1;%nDepth=%2"/>
                <string id="RuntimePublisher.GCEnd_V1EventMessage" value="Count=%1;%nDepth=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.GCHeapStatsEventMessage" value="GenerationSize0=%1;%nTotalPromotedSize0=%2;%nGenerationSize1=%3;%nTotalPromotedSize1=%4;%nGenerationSize2=%5;%nTotalPromotedSize2=%6;%nGenerationSize3=%7;%nTotalPromotedSize3=%8;%nFinalizationPromotedSize=%9;%nFinalizationPromotedCount=%10;%nPinnedObjectCount=%11;%nSinkBlockCount=%12;%nGCHandleCount=%13"/>
                <string id="RuntimePublisher.GCHeapStats_V1EventMessage" value="GenerationSize0=%1;%nTotalPromotedSize0=%2;%nGenerationSize1=%3;%nTotalPromotedSize1=%4;%nGenerationSize2=%5;%nTotalPromotedSize2=%6;%nGenerationSize3=%7;%nTotalPromotedSize3=%8;%nFinalizationPromotedSize=%9;%nFinalizationPromotedCount=%10;%nPinnedObjectCount=%11;%nSinkBlockCount=%12;%nGCHandleCount=%13;%nClrInstanceID=%14"/>
                <string id="RuntimePublisher.GCCreateSegmentEventMessage" value="Address=%1;%nSize=%2;%nType=%3"/>
                <string id="RuntimePublisher.GCCreateSegment_V1EventMessage" value="Address=%1;%nSize=%2;%nType=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.GCFreeSegmentEventMessage" value="Address=%1"/>
                <string id="RuntimePublisher.GCFreeSegment_V1EventMessage" value="Address=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.GCRestartEEBeginEventMessage" value="NONE"/>
                <string id="RuntimePublisher.GCRestartEEBegin_V1EventMessage" value="ClrInstanceID=%1"/>
                <string id="RuntimePublisher.GCRestartEEEndEventMessage" value="NONE"/>
                <string id="RuntimePublisher.GCRestartEEEnd_V1EventMessage" value="ClrInstanceID=%1"/>
                <string id="RuntimePublisher.GCSuspendEEEventMessage" value="Reason=%1"/>
                <string id="RuntimePublisher.GCSuspendEE_V1EventMessage" value="Reason=%1;%nCount=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.GCSuspendEEEndEventMessage" value="NONE"/>
                <string id="RuntimePublisher.GCSuspendEEEnd_V1EventMessage" value="ClrInstanceID=%1"/>
                <string id="RuntimePublisher.GCAllocationTickEventMessage" value="Amount=%1;%nKind=%2"/>
                <string id="RuntimePublisher.GCAllocationTick_V1EventMessage" value="Amount=%1;%nKind=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.GCAllocationTick_V2EventMessage" value="Amount=%1;%nKind=%2;%nClrInstanceID=%3;Amount64=%4;%nTypeID=%5;%nTypeName=%6;%nHeapIndex=%7"/>
                <string id="RuntimePublisher.GCCreateConcurrentThreadEventMessage" value="NONE"/>
                <string id="RuntimePublisher.GCCreateConcurrentThread_V1EventMessage" value="ClrInstanceID=%1"/>
                <string id="RuntimePublisher.GCTerminateConcurrentThreadEventMessage" value="NONE"/>
                <string id="RuntimePublisher.GCTerminateConcurrentThread_V1EventMessage" value="ClrInstanceID=%1"/>
                <string id="RuntimePublisher.GCFinalizersEndEventMessage" value="Count=%1"/>
                <string id="RuntimePublisher.GCFinalizersEnd_V1EventMessage" value="Count=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.GCFinalizersBeginEventMessage" value="NONE"/>
                <string id="RuntimePublisher.GCFinalizersBegin_V1EventMessage" value="ClrInstanceID=%1"/>
                <string id="RuntimePublisher.WorkerThreadCreateEventMessage" value="WorkerThreadCount=%1;%nRetiredWorkerThreads=%2"/>
                <string id="RuntimePublisher.WorkerThreadTerminateEventMessage" value="WorkerThreadCount=%1;%nRetiredWorkerThreads=%2"/>
                <string id="RuntimePublisher.WorkerThreadRetirementRetireThreadEventMessage" value="WorkerThreadCount=%1;%nRetiredWorkerThreads=%2"/>
                <string id="RuntimePublisher.WorkerThreadRetirementUnretireThreadEventMessage" value="WorkerThreadCount=%1;%nRetiredWorkerThreads=%2"/>
                <string id="RuntimePublisher.ThreadPoolWorkerThreadEventMessage" value="WorkerThreadCount=%1;%nRetiredWorkerThreadCount=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.ThreadPoolWorkerThreadAdjustmentSampleEventMessage" value="Throughput=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.ThreadPoolWorkerThreadAdjustmentAdjustmentEventMessage" value="AverageThroughput=%1;%nNewWorkerThreadCount=%2;%nReason=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.ThreadPoolWorkerThreadAdjustmentStatsEventMessage" value="Duration=%1;%nThroughput=%2;%nThreadWave=%3;%nThroughputWave=%4;%nThroughputErrorEstimate=%5;%nAverageThroughputErrorEstimate=%6;%nThroughputRatio=%7;%nConfidence=%8;%nNewControlSetting=%9;%nNewThreadWaveMagnitude=%10;%nClrInstanceID=%11"/>
                <string id="RuntimePublisher.IOThreadCreateEventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2"/>
                <string id="RuntimePublisher.IOThreadCreate_V1EventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.IOThreadTerminateEventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2"/>
                <string id="RuntimePublisher.IOThreadTerminate_V1EventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.IOThreadRetirementRetireThreadEventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2"/>
                <string id="RuntimePublisher.IOThreadRetirementRetireThread_V1EventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.IOThreadRetirementUnretireThreadEventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2"/>
                <string id="RuntimePublisher.IOThreadRetirementUnretireThread_V1EventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.ThreadPoolSuspendSuspendThreadEventMessage" value="ClrThreadID=%1;%nCPUUtilization=%2"/>
                <string id="RuntimePublisher.ThreadPoolSuspendResumeThreadEventMessage" value="ClrThreadID=%1;%nCPUUtilization=%2"/>
                <string id="RuntimePublisher.ExceptionExceptionThrownEventMessage" value="NONE"/>
                <string id="RuntimePublisher.ExceptionExceptionThrown_V1EventMessage" value="ExceptionType=%1;%nExceptionMessage=%2;%nExceptionEIP=%3;%nExceptionHRESULT=%4;%nExceptionFlags=%5;%nClrInstanceID=%6"/>
                <string id="RuntimePublisher.ContentionStartEventMessage" value="NONE"/>
                <string id="RuntimePublisher.ContentionStart_V1EventMessage" value="ContentionFlags=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.ContentionStopEventMessage" value="ContentionFlags=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.DCStartCompleteEventMessage" value="NONE"/>
                <string id="RuntimePublisher.DCEndCompleteEventMessage" value="NONE"/>
                <string id="RuntimePublisher.MethodDCStartEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6"/>
                <string id="RuntimePublisher.MethodDCEndEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6"/>
                <string id="RuntimePublisher.MethodDCStartVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9"/>
                <string id="RuntimePublisher.MethodDCEndVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9"/>
                <string id="RuntimePublisher.MethodLoadEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6"/>
                <string id="RuntimePublisher.MethodLoad_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7"/>
                <string id="RuntimePublisher.MethodLoad_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7;%nReJITID=%8"/>
                <string id="RuntimePublisher.MethodLoadVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9"/>
                <string id="RuntimePublisher.MethodLoadVerbose_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10"/>
                <string id="RuntimePublisher.MethodLoadVerbose_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10;%nReJITID=%11"/>
                <string id="RuntimePublisher.MethodUnloadEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6"/>
                <string id="RuntimePublisher.MethodUnload_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7"/>
                <string id="RuntimePublisher.MethodUnload_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7;%nReJITID=%8"/>
                <string id="RuntimePublisher.MethodUnloadVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9"/>
                <string id="RuntimePublisher.MethodUnloadVerbose_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10"/>
                <string id="RuntimePublisher.MethodUnloadVerbose_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10;%nReJITID=%11"/>
                <string id="RuntimePublisher.MethodJittingStartedEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodToken=%3;%nMethodILSize=%4;%nMethodNamespace=%5;%nMethodName=%6;%nMethodSignature=%7"/>
                <string id="RuntimePublisher.MethodJittingStarted_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodToken=%3;%nMethodILSize=%4;%nMethodNamespace=%5;%nMethodName=%6;%nMethodSignature=%7;%nClrInstanceID=%8"/>
                <string id="RuntimePublisher.MethodILToNativeMapEventMessage" value="MethodID=%1;%nReJITID=%2;%nMethodExtent=%3;%nCountOfMapEntries=%4;%nClrInstanceID=%5"/>
                <string id="RuntimePublisher.DomainModuleLoadEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;%nModuleILPath=%5;ModuleNativePath=%6"/>
                <string id="RuntimePublisher.DomainModuleLoad_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;%nModuleILPath=%5;ModuleNativePath=%6;%nClrInstanceID=%7"/>
                <string id="RuntimePublisher.DomainModuleUnloadEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;%nModuleILPath=%5;ModuleNativePath=%6"/>
                <string id="RuntimePublisher.DomainModuleUnload_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;%nModuleILPath=%5;ModuleNativePath=%6;%nClrInstanceID=%7"/>
                <string id="RuntimePublisher.ModuleDCStartEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;%nModuleNativePath=%5"/>
                <string id="RuntimePublisher.ModuleDCEndEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;%nModuleNativePath=%5"/>
                <string id="RuntimePublisher.ModuleLoadEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;%nModuleNativePath=%5"/>
                <string id="RuntimePublisher.ModuleLoad_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6"/>
                <string id="RuntimePublisher.ModuleLoad_V2EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6;%nManagedPdbSignature=%7;%nManagedPdbAge=%8;%nManagedPdbBuildPath=%9;%nNativePdbSignature=%10;%nNativePdbAge=%11;%nNativePdbBuildPath=%12"/>
                <string id="RuntimePublisher.ModuleUnloadEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;%nModuleNativePath=%5"/>
                <string id="RuntimePublisher.ModuleUnload_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6"/>
                <string id="RuntimePublisher.ModuleUnload_V2EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6;%nManagedPdbSignature=%7;%nManagedPdbAge=%8;%nManagedPdbBuildPath=%9;%nNativePdbSignature=%10;%nNativePdbAge=%11;%nNativePdbBuildPath=%12"/>
                <string id="RuntimePublisher.AssemblyLoadEventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;%nFullyQualifiedAssemblyName=%4"/>
                <string id="RuntimePublisher.AssemblyLoad_V1EventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;%nFullyQualifiedAssemblyName=%4;%nClrInstanceID=%5"/>
                <string id="RuntimePublisher.AssemblyUnloadEventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;%nFullyQualifiedAssemblyName=%4"/>
                <string id="RuntimePublisher.AssemblyUnload_V1EventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;%nFullyQualifiedAssemblyName=%4;%nClrInstanceID=%5"/>
                <string id="RuntimePublisher.AppDomainLoadEventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3"/>
                <string id="RuntimePublisher.AppDomainLoad_V1EventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3;%nAppDomainIndex=%4;%nClrInstanceID=%5"/>
                <string id="RuntimePublisher.AppDomainUnloadEventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3"/>
                <string id="RuntimePublisher.AppDomainUnload_V1EventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3;%nAppDomainIndex=%4;%nClrInstanceID=%5"/>
                <string id="RuntimePublisher.StackEventMessage" value="ClrInstanceID=%1;%nReserved1=%2;%nReserved2=%3;%nFrameCount=%4;%nStack=%5"/>
                <string id="RuntimePublisher.AppDomainMemAllocatedEventMessage" value="AppDomainID=%1;%nAllocated=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.AppDomainMemSurvivedEventMessage" value="AppDomainID=%1;%nSurvived=%2;%nProcessSurvived=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.ThreadCreatedEventMessage" value="ManagedThreadID=%1;%nAppDomainID=%2;%nFlags=%3;%nManagedThreadIndex=%4;%nOSThreadID=%5;%nClrInstanceID=%6"/>
                <string id="RuntimePublisher.ThreadTerminatedEventMessage" value="ManagedThreadID=%1;%nAppDomainID=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.ThreadDomainEnterEventMessage" value="ManagedThreadID=%1;%nAppDomainID=%2;%nClrInstanceID=%3"/>
                <string id="RuntimePublisher.ILStubGeneratedEventMessage" value="ClrInstanceID=%1;%nModuleID=%2;%nStubMethodID=%3;%nStubFlags=%4;%nManagedInteropMethodToken=%5;%nManagedInteropMethodNamespace=%6;%nManagedInteropMethodName=%7;%nManagedInteropMethodSignature=%8;%nNativeMethodSignature=%9;%nStubMethodSignature=%10;%nStubMethodILCode=%11"/>
                <string id="RuntimePublisher.ILStubCacheHitEventMessage" value="ClrInstanceID=%1;%nModuleID=%2;%nStubMethodID=%3;%nManagedInteropMethodToken=%4;%nManagedInteropMethodNamespace=%5;%nManagedInteropMethodName=%6;%nManagedInteropMethodSignature=%7"/>
                <string id="RuntimePublisher.StrongNameVerificationStartEventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nFullyQualifiedAssemblyName=%3"/>
                <string id="RuntimePublisher.StrongNameVerificationStart_V1EventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nFullyQualifiedAssemblyName=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.StrongNameVerificationEndEventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nFullyQualifiedAssemblyName=%3"/>
                <string id="RuntimePublisher.StrongNameVerificationEnd_V1EventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nFullyQualifiedAssemblyName=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.AuthenticodeVerificationStartEventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nModulePath=%3"/>
                <string id="RuntimePublisher.AuthenticodeVerificationStart_V1EventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nModulePath=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.AuthenticodeVerificationEndEventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nModulePath=%3"/>
                <string id="RuntimePublisher.AuthenticodeVerificationEnd_V1EventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nModulePath=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.EEStartupStartEventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nModulePath=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.RuntimeInformationEventMessage" value="ClrInstanceID=%1;%nSKU=%2;%nBclMajorVersion=%3;%nBclMinorVersion=%4;%nBclBuildNumber=%5;%nBclQfeNumber=%6;%nVMMajorVersion=%7;%nVMMinorVersion=%8;%nVMBuildNumber=%9;%nVMQfeNumber=%10;%nStartupFlags=%11;%nStartupMode=%12;%nCommandLine=%13;%nComObjectGUID=%14;%nRuntimeDllPath=%15"/>
                <string id="RuntimePublisher.MethodJitInliningFailedEventMessage" value="MethodBeingCompiledNamespace=%1;%nMethodBeingCompiledName=%2;%nMethodBeingCompiledNameSignature=%3;%nInlinerNamespace=%4;%nInlinerName=%5;%nInlinerNameSignature=%6;%nInlineeNamespace=%7;%nInlineeName=%8;%nInlineeNameSignature=%9;%nFailAlways=%10;%nFailReason=%11;%nClrInstanceID=%12"/>
                <string id="RuntimePublisher.MethodJitInliningSucceededEventMessage" value="MethodBeingCompiledNamespace=%1;%nMethodBeingCompiledName=%2;%nMethodBeingCompiledNameSignature=%3;%nInlinerNamespace=%4;%nInlinerName=%5;%nInlinerNameSignature=%6;%nInlineeNamespace=%7;%nInlineeName=%8;%nInlineeNameSignature=%9;%nClrInstanceID=%10"/>
                <string id="RuntimePublisher.MethodJitTailCallFailedEventMessage" value="MethodBeingCompiledNamespace=%1;%nMethodBeingCompiledName=%2;%nMethodBeingCompiledNameSignature=%3;%nCallerNamespace=%4;%nCallerName=%5;%nCallerNameSignature=%6;%nCalleeNamespace=%7;%nCalleeName=%8;%nCalleeNameSignature=%9;%nTailPrefix=%10;%nFailReason=%11;%nClrInstanceID=%12"/>
                <string id="RuntimePublisher.MethodJitTailCallSucceededEventMessage" value="MethodBeingCompiledNamespace=%1;%nMethodBeingCompiledName=%2;%nMethodBeingCompiledNameSignature=%3;%nCallerNamespace=%4;%nCallerName=%5;%nCallerNameSignature=%6;%nCalleeNamespace=%7;%nCalleeName=%8;%nCalleeNameSignature=%9;%nTailPrefix=%10;%nTailCallType=%11;%nClrInstanceID=%12"/>
                <string id="RundownPublisher.MethodDCStartEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6"/>
                <string id="RundownPublisher.MethodDCStart_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7"/>
                <string id="RundownPublisher.MethodDCStart_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7;%nReJITID=%8"/>
                <string id="RuntimePublisher.ModuleRangeLoadEventMessage" value="ClrInstanceID=%1;%ModuleID=%2;%nRangeBegin=%3;%nRangeSize=%4;%nRangeType=%5"/>
                <string id="RundownPublisher.MethodDCEndEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6"/>
                <string id="RundownPublisher.MethodDCEnd_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7"/>
                <string id="RundownPublisher.MethodDCEnd_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7;%nReJITID=%8"/>
                <string id="RundownPublisher.MethodDCStartVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9"/>
                <string id="RundownPublisher.MethodDCStartVerbose_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10"/>
                <string id="RundownPublisher.MethodDCStartVerbose_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10;%nReJITID=%11"/>
                <string id="RundownPublisher.MethodDCEndVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9"/>
                <string id="RundownPublisher.MethodDCEndVerbose_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10"/>
                <string id="RundownPublisher.MethodDCEndVerbose_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10;%nReJITID=%11"/>
                <string id="RundownPublisher.MethodDCStartILToNativeMapEventMessage" value="MethodID=%1;%nReJITID=%2;%nMethodExtent=%3;%nCountOfMapEntries=%4;%nClrInstanceID=%5"/>
                <string id="RundownPublisher.MethodDCEndILToNativeMapEventMessage" value="MethodID=%1;%nReJITID=%2;%nMethodExtent=%3;%nCountOfMapEntries=%4;%nClrInstanceID=%5"/>
                <string id="RundownPublisher.DomainModuleDCStartEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;ModuleILPath=%5;ModuleNativePath=%6"/>
                <string id="RundownPublisher.DomainModuleDCStart_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;ModuleILPath=%5;ModuleNativePath=%6;%nClrInstanceID=%7"/>
                <string id="RundownPublisher.DomainModuleDCEndEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;ModuleILPath=%5;ModuleNativePath=%6"/>
                <string id="RundownPublisher.DomainModuleDCEnd_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;ModuleILPath=%5;ModuleNativePath=%6;%nClrInstanceID=%7"/>
                <string id="RundownPublisher.ModuleDCStartEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;ModuleNativePath=%5"/>
                <string id="RundownPublisher.ModuleDCStart_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;ModuleNativePath=%5;%nClrInstanceID=%6"/>
                <string id="RundownPublisher.ModuleDCStart_V2EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6;%nManagedPdbSignature=%7;%nManagedPdbAge=%8;%nManagedPdbBuildPath=%9;%nNativePdbSignature=%10;%nNativePdbAge=%11;%nNativePdbBuildPath=%12"/>
                <string id="RundownPublisher.ModuleDCEndEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;ModuleNativePath=%5"/>
                <string id="RundownPublisher.ModuleDCEnd_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;ModuleNativePath=%5;%nClrInstanceID=%6"/>
                <string id="RundownPublisher.ModuleDCEnd_V2EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6;%nManagedPdbSignature=%7;%nManagedPdbAge=%8;%nManagedPdbBuildPath=%9;%nNativePdbSignature=%10;%nNativePdbAge=%11;%nNativePdbBuildPath=%12"/>
                <string id="RundownPublisher.AssemblyDCStartEventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;FullyQualifiedAssemblyName=%4"/>
                <string id="RundownPublisher.AssemblyDCStart_V1EventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;FullyQualifiedAssemblyName=%4;%nClrInstanceID=%5"/>
                <string id="RundownPublisher.AssemblyDCEndEventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;FullyQualifiedAssemblyName=%4"/>
                <string id="RundownPublisher.AssemblyDCEnd_V1EventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;FullyQualifiedAssemblyName=%4;%nClrInstanceID=%5"/>
                <string id="RundownPublisher.AppDomainDCStartEventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3"/>
                <string id="RundownPublisher.AppDomainDCStart_V1EventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3;%nAppDomainIndex=%4;%nClrInstanceID=%5"/>
                <string id="RundownPublisher.AppDomainDCEndEventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3"/>
                <string id="RundownPublisher.AppDomainDCEnd_V1EventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3;%nAppDomainIndex=%4;%nClrInstanceID=%5"/>
                <string id="RundownPublisher.DCStartCompleteEventMessage" value="ClrInstanceID=%1"/>
                <string id="RundownPublisher.DCEndCompleteEventMessage" value="ClrInstanceID=%1"/>
                <string id="RundownPublisher.DCStartInitEventMessage" value="ClrInstanceID=%1"/>
                <string id="RundownPublisher.DCEndInitEventMessage" value="ClrInstanceID=%1"/>
                <string id="RundownPublisher.ThreadCreatedEventMessage" value="ManagedThreadID=%1;%nAppDomainID=%2;%nFlags=%3;%nManagedThreadIndex=%4;%nOSThreadID=%5;%nClrInstanceID=%6"/>
                <string id="RundownPublisher.RuntimeInformationEventMessage" value="ClrInstanceID=%1;%nSKU=%2;%nBclMajorVersion=%3;%nBclMinorVersion=%4;%nBclBuildNumber=%5;%nBclQfeNumber=%6;%nVMMajorVersion=%7;%nVMMinorVersion=%8;%nVMBuildNumber=%9;%nVMQfeNumber=%10;%nStartupFlags=%11;%nStartupMode=%12;%nCommandLine=%13;%nComObjectGUID=%14;%nRuntimeDllPath=%15"/>
                <string id="RundownPublisher.StackEventMessage" value="ClrInstanceID=%1;%nReserved1=%2;%nReserved2=%3;%nFrameCount=%4;%nStack=%5"/>
                <string id="RundownPublisher.ModuleRangeDCStartEventMessage" value="ClrInstanceID=%1;%ModuleID=%2;%nRangeBegin=%3;%nRangeSize=%4;%nRangeType=%5"/>
                <string id="RundownPublisher.ModuleRangeDCEndEventMessage" value="ClrInstanceID=%1;%ModuleID=%2;%nRangeBegin=%3;%nRangeSize=%4;%nRangeType=%5"/>
                <!-- Task Messages -->
                <string id="RuntimePublisher.GarbageCollectionTaskMessage" value="GC"/>
                <string id="RuntimePublisher.WorkerThreadCreationTaskMessage" value="WorkerThreadCreationV2"/>
                <string id="RuntimePublisher.WorkerThreadRetirementTaskMessage" value="WorkerThreadRetirementV2"/>
                <string id="RuntimePublisher.IOThreadCreationTaskMessage" value="IOThreadCreation"/>
                <string id="RuntimePublisher.IOThreadRetirementTaskMessage" value="IOThreadRetirement"/>
                <string id="RuntimePublisher.ThreadpoolSuspensionTaskMessage" value="ThreadpoolSuspensionV2"/>
                <string id="RuntimePublisher.ThreadPoolWorkerThreadTaskMessage" value="ThreadPoolWorkerThread"/>
                <string id="RuntimePublisher.ThreadPoolWorkerThreadRetirementTaskMessage" value="ThreadPoolWorkerThreadRetirement"/>
                <string id="RuntimePublisher.ThreadPoolWorkerThreadAdjustmentTaskMessage" value="ThreadPoolWorkerThreadAdjustment"/>
                <string id="RuntimePublisher.ExceptionTaskMessage" value="Exception"/>
                <string id="RuntimePublisher.ContentionTaskMessage" value="Contention"/>
                <string id="RuntimePublisher.MethodTaskMessage" value="Method"/>
                <string id="RuntimePublisher.LoaderTaskMessage" value="Loader"/>
                <string id="RuntimePublisher.StackTaskMessage" value="ClrStack"/>
                <string id="RuntimePublisher.StrongNameVerificationTaskMessage" value="StrongNameVerification"/>
                <string id="RuntimePublisher.AuthenticodeVerificationTaskMessage" value="AuthenticodeVerification"/>
                <string id="RuntimePublisher.AppDomainResourceManagementTaskMessage" value="AppDomainResourceManagement"/>
                <string id="RuntimePublisher.ILStubTaskMessage" value="ILStub"/>
                <string id="RuntimePublisher.EEStartupTaskMessage" value="Runtime"/>
                <string id="RuntimePublisher.PerfTrackTaskMessage" value="ClrPerfTrack"/>
                <string id="RundownPublisher.EEStartupTaskMessage" value="Runtime"/>
                <string id="RundownPublisher.MethodTaskMessage" value="Method"/>
                <string id="RundownPublisher.LoaderTaskMessage" value="Loader"/>
                <string id="RundownPublisher.StackTaskMessage" value="ClrStack"/>
                <string id="RundownPublisher.PerfTrackTaskMessage" value="ClrPerfTrack"/>
                <!-- Map Messages -->
                <string id="RuntimePublisher.AppDomain.DefaultMapMessage" value="Default"/>
                <string id="RuntimePublisher.AppDomain.ExecutableMapMessage" value="Executable"/>
                <string id="RuntimePublisher.AppDomain.SharedMapMessage" value="Shared"/>
                <string id="RuntimePublisher.Assembly.DomainNeutralMapMessage" value="DomainNeutral"/>
                <string id="RuntimePublisher.Assembly.DynamicMapMessage" value="Dynamic"/>
                <string id="RuntimePublisher.Assembly.NativeMapMessage" value="Native"/>
                <string id="RuntimePublisher.Assembly.CollectibleMapMessage" value="Collectible"/>
                <string id="RuntimePublisher.Module.DomainNeutralMapMessage" value="DomainNeutral"/>
                <string id="RuntimePublisher.Module.NativeMapMessage" value="Native"/>
                <string id="RuntimePublisher.Module.DynamicMapMessage" value="Dynamic"/>
                <string id="RuntimePublisher.Module.ManifestMapMessage" value="Manifest"/>
                <string id="RuntimePublisher.Method.DynamicMapMessage" value="Dynamic"/>
                <string id="RuntimePublisher.Method.GenericMapMessage" value="Generic"/>
                <string id="RuntimePublisher.Method.HasSharedGenericCodeMapMessage" value="HasSharedGenericCode"/>
                <string id="RuntimePublisher.Method.JittedMapMessage" value="Jitted"/>
                <string id="RuntimePublisher.GCSegment.SmallObjectHeapMapMessage" value="SmallObjectHeap"/>
                <string id="RuntimePublisher.GCSegment.LargeObjectHeapMapMessage" value="LargeObjectHeap"/>
                <string id="RuntimePublisher.GCSegment.ReadOnlyHeapMapMessage" value="ReadOnlyHeap"/>
                <string id="RuntimePublisher.GCAllocation.SmallMapMessage" value="Small"/>
                <string id="RuntimePublisher.GCAllocation.LargeMapMessage" value="Large"/>
                <string id="RuntimePublisher.GCType.NonConcurrentGCMapMessage" value="NonConcurrentGC"/>
                <string id="RuntimePublisher.GCType.BackgroundGCMapMessage" value="BackgroundGC"/>
                <string id="RuntimePublisher.GCType.ForegroundGCMapMessage" value="ForegroundGC"/>
                <string id="RuntimePublisher.GCReason.AllocSmallMapMessage" value="AllocSmall"/>
                <string id="RuntimePublisher.GCReason.InducedMapMessage" value="Induced"/>
                <string id="RuntimePublisher.GCReason.LowMemoryMapMessage" value="LowMemory"/>
                <string id="RuntimePublisher.GCReason.EmptyMapMessage" value="Empty"/>
                <string id="RuntimePublisher.GCReason.AllocLargeMapMessage" value="AllocLarge"/>
                <string id="RuntimePublisher.GCReason.OutOfSpaceSmallObjectHeapMapMessage" value="OutOfSpaceSmallObjectHeap"/>
                <string id="RuntimePublisher.GCReason.OutOfSpaceLargeObjectHeapMapMessage" value="OutOfSpaceLargeObjectHeap"/>
                <string id="RuntimePublisher.GCReason.InducedNoForceMapMessage" value="InducedNoForce"/>
                <string id="RuntimePublisher.GCReason.StressMapMessage" value="Stress"/>
                <string id="RuntimePublisher.GCReason.InducedLowMemoryMapMessage" value="InducedLowMemory"/>
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendOtherMapMessage" value="SuspendOther"/>
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForGCMapMessage" value="SuspendForGC"/>
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForAppDomainShutdownMapMessage" value="SuspendForAppDomainShutdown"/>
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForCodePitchingMapMessage" value="SuspendForCodePitching"/>
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForShutdownMapMessage" value="SuspendForShutdown"/>
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForDebuggerMapMessage" value="SuspendForDebugger"/>
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForGCPrepMapMessage" value="SuspendForGCPrep"/>
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForDebuggerSweepMapMessage" value="SuspendForDebuggerSweep"/>
                <string id="RuntimePublisher.StartupMode.ManagedExeMapMessage" value="ManagedExe"/>
                <string id="RuntimePublisher.StartupMode.HostedCLRMapMessage" value="HostedClr"/>
                <string id="RuntimePublisher.StartupMode.IjwDllMapMessage" value="IjwDll"/>
                <string id="RuntimePublisher.StartupMode.ComActivatedMapMessage" value="ComActivated"/>
                <string id="RuntimePublisher.StartupMode.OtherMapMessage" value="Other"/>
                <string id="RuntimePublisher.RuntimeSku.DesktopCLRMapMessage" value="DesktopClr"/>
                <string id="RuntimePublisher.RuntimeSku.CoreCLRMapMessage" value="CoreClr"/>
                <string id="RuntimePublisher.ExceptionThrown.HasInnerExceptionMapMessage" value="HasInnerException"/>
                <string id="RuntimePublisher.ExceptionThrown.NestedMapMessage" value="Nested"/>
                <string id="RuntimePublisher.ExceptionThrown.ReThrownMapMessage" value="ReThrown"/>
                <string id="RuntimePublisher.ExceptionThrown.CorruptedStateMapMessage" value="CorruptedState"/>
                <string id="RuntimePublisher.ExceptionThrown.CLSCompliantMapMessage" value="CLSCompliant"/>
                <string id="RuntimePublisher.ILStubGenerated.ReverseInteropMapMessage" value="ReverseInterop"/>
                <string id="RuntimePublisher.ILStubGenerated.COMInteropMapMessage" value="ComInterop"/>
                <string id="RuntimePublisher.ILStubGenerated.NGenedStubMapMessage" value="NGenedStub"/>
                <string id="RuntimePublisher.ILStubGenerated.DelegateMapMessage" value="Delegate"/>
                <string id="RuntimePublisher.ILStubGenerated.VarArgMapMessage" value="VarArg"/>
                <string id="RuntimePublisher.ILStubGenerated.UnmanagedCalleeMapMessage" value="UnmanagedCallee"/>
                <string id="RuntimePublisher.Contention.ManagedMapMessage" value="Managed"/>
                <string id="RuntimePublisher.Contention.NativeMapMessage" value="Native"/>
                <string id="RuntimePublisher.TailCallType.OptimizedMapMessage" value="OptimizedTailCall"/>
                <string id="RuntimePublisher.TailCallType.RecursiveMapMessage" value="RecursiveLoop"/>
                <string id="RuntimePublisher.TailCallType.HelperMapMessage" value="HelperAssistedTailCall"/>
                <string id="RuntimePublisher.ThreadAdjustmentReason.WarmupMapMessage" value="Warmup"/>
                <string id="RuntimePublisher.ThreadAdjustmentReason.InitializingMapMessage" value="Initializing"/>
                <string id="RuntimePublisher.ThreadAdjustmentReason.RandomMoveMapMessage" value="RandomMove"/>
                <string id="RuntimePublisher.ThreadAdjustmentReason.ClimbingMoveMapMessage" value="ClimbingMove"/>
                <string id="RuntimePublisher.ThreadAdjustmentReason.ChangePointMapMessage" value="ChangePoint"/>
                <string id="RuntimePublisher.ThreadAdjustmentReason.StabilizingMapMessage" value="Stabilizing"/>
                <string id="RuntimePublisher.ThreadAdjustmentReason.StarvationMapMessage" value="Starvation"/>
                <string id="RuntimePublisher.ThreadAdjustmentReason.ThreadTimedOutMapMessage" value="ThreadTimedOut"/>
                <string id="RuntimePublisher.Startup.CONCURRENT_GCMapMessage" value="CONCURRENT_GC"/>
                <string id="RuntimePublisher.Startup.LOADER_OPTIMIZATION_SINGLE_DOMAINMapMessage" value="LOADER_OPTIMIZATION_SINGLE_DOMAIN"/>
                <string id="RuntimePublisher.Startup.LOADER_OPTIMIZATION_MULTI_DOMAINMapMessage" value="LOADER_OPTIMIZATION_MULTI_DOMAIN"/>
                <string id="RuntimePublisher.Startup.LOADER_SAFEMODEMapMessage" value="LOADER_SAFEMODE"/>
                <string id="RuntimePublisher.Startup.LOADER_SETPREFERENCEMapMessage" value="LOADER_SETPREFERENCE"/>
                <string id="RuntimePublisher.Startup.SERVER_GCMapMessage" value="SERVER_GC"/>
                <string id="RuntimePublisher.Startup.HOARD_GC_VMMapMessage" value="HOARD_GC_VM"/>
                <string id="RuntimePublisher.Startup.SINGLE_VERSION_HOSTING_INTERFACEMapMessage" value="SINGLE_VERSION_HOSTING_INTERFACE"/>
                <string id="RuntimePublisher.Startup.LEGACY_IMPERSONATIONMapMessage" value="LEGACY_IMPERSONATION"/>
                <string id="RuntimePublisher.Startup.DISABLE_COMMITTHREADSTACKMapMessage" value="DISABLE_COMMITTHREADSTACK"/>
                <string id="RuntimePublisher.Startup.ALWAYSFLOW_IMPERSONATIONMapMessage" value="ALWAYSFLOW_IMPERSONATION"/>
                <string id="RuntimePublisher.Startup.TRIM_GC_COMMITMapMessage" value="TRIM_GC_COMMIT"/>
                <string id="RuntimePublisher.Startup.ETWMapMessage" value="ETW"/>
                <string id="RuntimePublisher.Startup.SERVER_BUILDMapMessage" value="SERVER_BUILD"/>
                <string id="RuntimePublisher.Startup.ARMMapMessage" value="ARM"/>
                <string id="RuntimePublisher.ModuleRangeTypeMap.ColdRangeMessage" value="ColdRange"/>
                <string id="RundownPublisher.AppDomain.DefaultMapMessage" value="Default"/>
                <string id="RundownPublisher.AppDomain.ExecutableMapMessage" value="Executable"/>
                <string id="RundownPublisher.AppDomain.SharedMapMessage" value="Shared"/>
                <string id="RundownPublisher.Assembly.DomainNeutralMapMessage" value="DomainNeutral"/>
                <string id="RundownPublisher.Assembly.DynamicMapMessage" value="Dynamic"/>
                <string id="RundownPublisher.Assembly.NativeMapMessage" value="Native"/>
                <string id="RundownPublisher.Assembly.CollectibleMapMessage" value="Collectible"/>
                <string id="RundownPublisher.Module.DomainNeutralMapMessage" value="DomainNeutral"/>
                <string id="RundownPublisher.Module.NativeMapMessage" value="Native"/>
                <string id="RundownPublisher.Module.DynamicMapMessage" value="Dynamic"/>
                <string id="RundownPublisher.Module.ManifestMapMessage" value="Manifest"/>
                <string id="RundownPublisher.Method.DynamicMapMessage" value="Dynamic"/>
                <string id="RundownPublisher.Method.GenericMapMessage" value="Generic"/>
                <string id="RundownPublisher.Method.HasSharedGenericCodeMapMessage" value="HasSharedGenericCode"/>
                <string id="RundownPublisher.Method.JittedMapMessage" value="Jitted"/>
                <string id="RundownPublisher.StartupMode.ManagedExeMapMessage" value="ManagedExe"/>
                <string id="RundownPublisher.StartupMode.HostedCLRMapMessage" value="HostedClr"/>
                <string id="RundownPublisher.StartupMode.IjwDllMapMessage" value="IjwDll"/>
                <string id="RundownPublisher.StartupMode.ComActivatedMapMessage" value="ComActivated"/>
                <string id="RundownPublisher.StartupMode.OtherMapMessage" value="Other"/>
                <string id="RundownPublisher.RuntimeSku.DesktopCLRMapMessage" value="DesktopClr"/>
                <string id="RundownPublisher.RuntimeSku.CoreCLRMapMessage" value="CoreClr"/>
                <string id="RundownPublisher.Startup.CONCURRENT_GCMapMessage" value="CONCURRENT_GC"/>
                <string id="RundownPublisher.Startup.LOADER_OPTIMIZATION_SINGLE_DOMAINMapMessage" value="LOADER_OPTIMIZATION_SINGLE_DOMAIN"/>
                <string id="RundownPublisher.Startup.LOADER_OPTIMIZATION_MULTI_DOMAINMapMessage" value="LOADER_OPTIMIZATION_MULTI_DOMAIN"/>
                <string id="RundownPublisher.Startup.LOADER_SAFEMODEMapMessage" value="LOADER_SAFEMODE"/>
                <string id="RundownPublisher.Startup.LOADER_SETPREFERENCEMapMessage" value="LOADER_SETPREFERENCE"/>
                <string id="RundownPublisher.Startup.SERVER_GCMapMessage" value="SERVER_GC"/>
                <string id="RundownPublisher.Startup.HOARD_GC_VMMapMessage" value="HOARD_GC_VM"/>
                <string id="RundownPublisher.Startup.SINGLE_VERSION_HOSTING_INTERFACEMapMessage" value="SINGLE_VERSION_HOSTING_INTERFACE"/>
                <string id="RundownPublisher.Startup.LEGACY_IMPERSONATIONMapMessage" value="LEGACY_IMPERSONATION"/>
                <string id="RundownPublisher.Startup.DISABLE_COMMITTHREADSTACKMapMessage" value="DISABLE_COMMITTHREADSTACK"/>
                <string id="RundownPublisher.Startup.ALWAYSFLOW_IMPERSONATIONMapMessage" value="ALWAYSFLOW_IMPERSONATION"/>
                <string id="RundownPublisher.Startup.TRIM_GC_COMMITMapMessage" value="TRIM_GC_COMMIT"/>
                <string id="RundownPublisher.Startup.ETWMapMessage" value="ETW"/>
                <string id="RundownPublisher.Startup.SERVER_BUILDMapMessage" value="SERVER_BUILD"/>
                <string id="RundownPublisher.Startup.ARMMapMessage" value="ARM"/>
                <string id="RundownPublisher.ModuleRangeTypeMap.ColdRangeMessage" value="ColdRange"/>
                <!-- Keyword Messages -->
                <string id="RuntimePublisher.GCKeywordMessage" value="GC"/>
                <string id="RuntimePublisher.ThreadingKeywordMessage" value="Threading"/>
                <string id="RuntimePublisher.FusionKeywordMessage" value="Binder"/>
                <string id="RuntimePublisher.LoaderKeywordMessage" value="Loader"/>
                <string id="RuntimePublisher.JitKeywordMessage" value="Jit"/>
                <string id="RuntimePublisher.JittedMethodILToNativeMapKeywordMessage" value="JittedMethodILToNativeMap"/>
                <string id="RuntimePublisher.NGenKeywordMessage" value="NGen"/>
                <string id="RuntimePublisher.StartEnumerationKeywordMessage" value="StartEnumeration"/>
                <string id="RuntimePublisher.EndEnumerationKeywordMessage" value="StopEnumeration"/>
                <string id="RuntimePublisher.SecurityKeywordMessage" value="Security"/>
                <string id="RuntimePublisher.AppDomainResourceManagementKeywordMessage" value="AppDomainResourceManagement"/>
                <string id="RuntimePublisher.InteropKeywordMessage" value="Interop"/>
                <string id="RuntimePublisher.ContentionKeywordMessage" value="Contention"/>
                <string id="RuntimePublisher.ExceptionKeywordMessage" value="Exception"/>
                <string id="RuntimePublisher.PerfTrackKeywordMessage" value="PerfTrack"/>
                <string id="RuntimePublisher.StackKeywordMessage" value="Stack"/>
                <string id="RuntimePublisher.JitTracingKeywordMessage" value="JitTracing"/>
                <string id="RuntimePublisher.OverrideAndSuppressNGenEventsKeywordMessage" value="OverrideAndSuppressNGenEvents"/>
                <string id="RundownPublisher.LoaderKeywordMessage" value="Loader"/>
                <string id="RundownPublisher.JitKeywordMessage" value="Jit"/>
                <string id="RundownPublisher.JittedMethodILToNativeMapRundownKeywordMessage" value="JittedMethodILToNativeMapRundown"/>
                <string id="RundownPublisher.NGenKeywordMessage" value="NGen"/>
                <string id="RundownPublisher.StartRundownKeywordMessage" value="Start"/>
                <string id="RundownPublisher.EndRundownKeywordMessage" value="End"/>
                <string id="RuntimePublisher.AppDomainResourceManagementRundownKeywordMessage" value="AppDomainResourceManagement"/>
                <string id="RundownPublisher.ThreadingKeywordMessage" value="Threading"/>
                <string id="RundownPublisher.OverrideAndSuppressNGenEventsRundownKeywordMessage" value="OverrideAndSuppressNGenEvents"/>
                <string id="RundownPublisher.PerfTrackRundownKeywordMessage" value="PerfTrack"/>
                <string id="RundownPublisher.StackKeywordMessage" value="Stack"/>
                <!-- Opcode messages -->
                <string id="RuntimePublisher.GCRestartEEEndOpcodeMessage" value="RestartEEStop"/>
                <string id="RuntimePublisher.GCHeapStatsOpcodeMessage" value="HeapStats"/>
                <string id="RuntimePublisher.GCCreateSegmentOpcodeMessage" value="CreateSegment"/>
                <string id="RuntimePublisher.GCFreeSegmentOpcodeMessage" value="FreeSegment"/>
                <string id="RuntimePublisher.GCRestartEEBeginOpcodeMessage" value="RestartEEStart"/>
                <string id="RuntimePublisher.GCSuspendEEEndOpcodeMessage" value="SuspendEEStop"/>
                <string id="RuntimePublisher.GCSuspendEEBeginOpcodeMessage" value="SuspendEEStart"/>
                <string id="RuntimePublisher.GCAllocationTickOpcodeMessage" value="AllocationTick"/>
                <string id="RuntimePublisher.GCCreateConcurrentThreadOpcodeMessage" value="CreateConcurrentThread"/>
                <string id="RuntimePublisher.GCTerminateConcurrentThreadOpcodeMessage" value="TerminateConcurrentThread"/>
                <string id="RuntimePublisher.GCFinalizersEndOpcodeMessage" value="FinalizersStop"/>
                <string id="RuntimePublisher.GCFinalizersBeginOpcodeMessage" value="FinalizersStart"/>
                <string id="RuntimePublisher.MethodLoadOpcodeMessage" value="Load"/>
                <string id="RuntimePublisher.MethodUnloadOpcodeMessage" value="Unload"/>
                <string id="RuntimePublisher.MethodLoadVerboseOpcodeMessage" value="LoadVerbose"/>
                <string id="RuntimePublisher.MethodUnloadVerboseOpcodeMessage" value="UnloadVerbose"/>
                <string id="RuntimePublisher.DCStartCompleteOpcodeMessage" value="DCStartCompleteV2"/>
                <string id="RuntimePublisher.DCEndCompleteOpcodeMessage" value="DCEndCompleteV2"/>
                <string id="RuntimePublisher.MethodDCStartOpcodeMessage" value="DCStartV2"/>
                <string id="RuntimePublisher.MethodDCEndOpcodeMessage" value="DCStopV2"/>
                <string id="RuntimePublisher.MethodDCStartVerboseOpcodeMessage" value="DCStartVerboseV2"/>
                <string id="RuntimePublisher.MethodDCEndVerboseOpcodeMessage" value="DCStopVerboseV2"/>
                <string id="RuntimePublisher.MethodJittingStartedOpcodeMessage" value="JittingStarted"/>
                <string id="RuntimePublisher.JitInliningSucceededOpcodeMessage" value="InliningSucceeded"/>
                <string id="RuntimePublisher.JitInliningFailedOpcodeMessage" value="InliningFailed"/>
                <string id="RuntimePublisher.JitTailCallSucceededOpcodeMessage" value="TailCallSucceeded"/>
                <string id="RuntimePublisher.JitTailCallFailedOpcodeMessage" value="TailCallFailed"/>
                <string id="RuntimePublisher.MethodILToNativeMapOpcodeMessage" value="MethodILToNativeMap"/>
                <string id="RuntimePublisher.DomainModuleLoadOpcodeMessage" value="DomainModuleLoad"/>
                <string id="RuntimePublisher.ModuleLoadOpcodeMessage" value="ModuleLoad"/>
                <string id="RuntimePublisher.ModuleUnloadOpcodeMessage" value="ModuleUnload"/>
                <string id="RuntimePublisher.ModuleDCStartOpcodeMessage" value="ModuleDCStartV2"/>
                <string id="RuntimePublisher.ModuleDCEndOpcodeMessage" value="ModuleDCStopV2"/>
                <string id="RuntimePublisher.AssemblyLoadOpcodeMessage" value="AssemblyLoad"/>
                <string id="RuntimePublisher.AssemblyUnloadOpcodeMessage" value="AssemblyUnload"/>
                <string id="RuntimePublisher.AppDomainLoadOpcodeMessage" value="AppDomainLoad"/>
                <string id="RuntimePublisher.AppDomainUnloadOpcodeMessage" value="AppDomainUnload"/>
                <string id="RuntimePublisher.CLRStackWalkOpcodeMessage" value="Walk"/>
                <string id="RuntimePublisher.AppDomainMemAllocatedOpcodeMessage" value="MemAllocated"/>
                <string id="RuntimePublisher.AppDomainMemSurvivedOpcodeMessage" value="MemSurvived"/>
                <string id="RuntimePublisher.ThreadCreatedOpcodeMessage" value="ThreadCreated"/>
                <string id="RuntimePublisher.ThreadTerminatedOpcodeMessage" value="ThreadTerminated"/>
                <string id="RuntimePublisher.ThreadDomainEnterOpcodeMessage" value="DomainEnter"/>
                <string id="RuntimePublisher.ILStubGeneratedOpcodeMessage" value="StubGenerated"/>
                <string id="RuntimePublisher.ILStubCacheHitOpcodeMessage" value="StubCacheHit"/>
                <string id="RuntimePublisher.SampleOpcodeMessage" value="Sample"/>
                <string id="RuntimePublisher.AdjustmentOpcodeMessage" value="Adjustment"/>
                <string id="RuntimePublisher.StatsOpcodeMessage" value="Stats"/>
                <string id="RuntimePublisher.ModuleRangeLoadOpcodeMessage" value="ModuleRangeLoad"/>
                <string id="RundownPublisher.MethodDCStartOpcodeMessage" value="DCStart"/>
                <string id="RundownPublisher.MethodDCEndOpcodeMessage" value="DCStop"/>
                <string id="RundownPublisher.MethodDCStartVerboseOpcodeMessage" value="DCStartVerbose"/>
                <string id="RundownPublisher.MethodDCEndVerboseOpcodeMessage" value="DCStopVerbose"/>
                <string id="RundownPublisher.MethodDCStartILToNativeMapOpcodeMessage" value="MethodDCStartILToNativeMap"/>
                <string id="RundownPublisher.MethodDCEndILToNativeMapOpcodeMessage" value="MethodDCEndILToNativeMap"/>
                <string id="RundownPublisher.DCStartCompleteOpcodeMessage" value="DCStartComplete"/>
                <string id="RundownPublisher.DCEndCompleteOpcodeMessage" value="DCStopComplete"/>
                <string id="RundownPublisher.DCStartInitOpcodeMessage" value="DCStartInit"/>
                <string id="RundownPublisher.DCEndInitOpcodeMessage" value="DCStopInit"/>
                <string id="RundownPublisher.ModuleDCStartOpcodeMessage" value="ModuleDCStart"/>
                <string id="RundownPublisher.ModuleDCEndOpcodeMessage" value="ModuleDCStop"/>
                <string id="RundownPublisher.AssemblyDCStartOpcodeMessage" value="AssemblyDCStart"/>
                <string id="RundownPublisher.AssemblyDCEndOpcodeMessage" value="AssemblyDCStop"/>
                <string id="RundownPublisher.AppDomainDCStartOpcodeMessage" value="AppDomainDCStart"/>
                <string id="RundownPublisher.AppDomainDCEndOpcodeMessage" value="AppDomainDCStop"/>
                <string id="RundownPublisher.DomainModuleDCStartOpcodeMessage" value="DomainModuleDCStart"/>
                <string id="RundownPublisher.DomainModuleDCEndOpcodeMessage" value="DomainModuleDCStop"/>
                <string id="RundownPublisher.ThreadDCOpcodeMessage" value="ThreadDCStop"/>
                <string id="RundownPublisher.CLRStackWalkOpcodeMessage" value="Walk"/>
                <string id="RundownPublisher.ModuleRangeDCStartOpcodeMessage" value="ModuleRangeDCStart"/>
                <string id="RundownPublisher.ModuleRangeDCEndOpcodeMessage" value="ModuleRangeDCEnd"/>
            </stringTable>
        </resources>
    </localization>
</instrumentationManifest>
