<instrumentationManifest xsi:schemaLocation="http://schemas.microsoft.com/win/2004/08/events eventman.xsd" xmlns="http://schemas.microsoft.com/win/2004/08/events" xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:trace="http://schemas.microsoft.com/win/2004/08/events/trace">
  <instrumentation>
    <events>

      <provider name="Microsoft-Windows-WPF" guid="{E13B77A8-14B6-11DE-8069-001B212B5009}" symbol="MICROSOFT_WINDOWS_WPF_PROVIDER"
            resourceFileName="%WINDIR%\Microsoft.NET\Framework\v4.0.30319\wpf\wpfgfx_v0400.dll" messageFileName="%WINDIR%\Microsoft.NET\Framework\v4.0.30319\wpf\wpfgfx_v0400.dll">

        <channels>
          <channel chid="DefaultChannel" name="Microsoft-Windows-WPF/Default" type="Analytic" symbol="MICROSOFT_WINDOWS_WPF_PROVIDER_DEFAULT_CHANNEL" />
        </channels>

        <levels>
          <!-- Also available:
            4 win:Informational 
            5 win:Verbose -->
          <level name="Performance_NoImpact" symbol="PERF" value="16"  />
          <level name="Performance_LowImpact" symbol="PERF_LOW" value="17" />
          <level name="Performance_MedImpact" symbol="PERF_MED" value="18" />
          <level name="Performance_HighImpact" symbol="PERF_HIGH" value="19" />
        </levels>

        <keywords>
          <keyword name="KeywordGeneral" mask="0x1" symbol="KeywordGeneral" />
          <keyword name="KeywordPerf" mask="0x2" symbol="KeywordPerf" />
          <keyword name="KeywordText" mask="0x4" symbol="KeywordText" />
          <keyword name="KeywordInput" mask="0x8" symbol="KeywordInput" />
          <keyword name="KeywordAnnotation" mask="0x10" symbol="KeywordAnnotation" />
          <keyword name="KeywordXamlBaml" mask="0x20" symbol="KeywordXamlBaml" />
          <keyword name="KeywordXPS" mask="0x40" symbol="KeywordXPS" />
          <keyword name="KeywordAnimation" mask="0x80" symbol="KeywordAnimation" />
          <keyword name="KeywordLayout" mask="0x100" symbol="KeywordLayout" />
          <!--<keyword name="KeywordPackaging" mask="0x200" symbol="KeywordPackaging" />  Can be reused -->
          <keyword name="KeywordHosting" mask="0x400" symbol="KeywordHosting" />
          <keyword name="KeywordHeapMeter" mask="0x800" symbol="KeywordHeapMeter" />
          <keyword name="KeywordGraphics" mask="0x1000" symbol="KeywordGraphics" />
          <keyword name="KeywordDispatcher" mask="0x2000" symbol="KeywordDispatcher" />
        </keywords>

        <maps>
          <valueMap name="DispatcherPriority">
            <map value="0" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.0.message)"/>
            <map value="1" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.1.message)"/>
            <map value="2" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.2.message)"/>
            <map value="3" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.3.message)"/>
            <map value="4" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.4.message)"/>
            <map value="5" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.5.message)"/>
            <map value="6" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.6.message)"/>
            <map value="7" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.7.message)"/>
            <map value="8" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.8.message)"/>
            <map value="9" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.9.message)"/>
            <map value="10" message="$(string.Microsoft-Windows-WPF.map.DispatcherPriority.10.message)"/>
          </valueMap>
          <valueMap name="UnexptectedSWFallbackReason">
            <map value="0" message="$(string.UnexptectedSWFallback_NoHardwareAvailable)" />
            <map value="1" message="$(string.UnexpectedSWFallback_ResizeFailed)" />
            <map value="2" message="$(string.UnexpectedSWFallback_OutOfVideoMemory)" />
            <map value="3" message="$(string.UnexpectedSWFallback_UnexpectedPrimitiveFallback)" />
          </valueMap>
          <valueMap name="LayoutSourceMap">
            <map value="0" message="$(string.Layout_LayoutManager)" />
            <map value="1" message="$(string.Layout_HwndSource_SetLayoutSize)" />
            <map value="2" message="$(string.Layout_HwndSource_WM_SIZE)" />
          </valueMap>
          <valueMap name="IntermediateRenderTargetReason">
            <map value="0" message="$(string.IRT_Clip)" />
            <map value="1" message="$(string.IRT_ClipAndOpacity)" />
            <map value="2" message="$(string.IRT_Effect)" />
            <map value="3" message="$(string.IRT_Opacity)" />
            <map value="4" message="$(string.IRT_OpacityMask)" />
            <map value="5" message="$(string.IRT_OpacityMask_Brush_Realization)" />
            <map value="6" message="$(string.IRT_ShaderEffect_Input)" />
            <map value="7" message="$(string.IRT_Software_Only_Effects)" />
            <map value="8" message="$(string.IRT_TileBrush)" />
          </valueMap>
        </maps>

        <templates>
          <template tid="Template_0" />
          <template tid="Template_1">
            <data name="Bitmap" inType="win:Pointer" outType="win:HexInt64" />
            <data name="width" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="height" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="Template_2">
            <data name="width" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="height" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="IntBounds">
            <data name="left" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="top" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="right" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="bottom" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="FloatBounds">
            <data name="left" inType="win:Float" outType="xs:float" />
            <data name="top" inType="win:Float" outType="xs:float" />
            <data name="right" inType="win:Float" outType="xs:float" />
            <data name="bottom" inType="win:Float" outType="xs:float" />
          </template>
          <template tid="Template_6">
            <data name="Z" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="HwndTemplate">
            <data name="Hwnd" inType="win:UInt64" outType="xs:unsignedLong" />
          </template>
          <template tid="Template_10">
            <data name="Id" inType="win:UInt64" outType="xs:unsignedLong" />
          </template>
          <template tid="Template_11">
            <data name="BatchSize" inType="win:UInt64" outType="xs:unsignedLong" />
          </template>
          <template tid="Template_12">
            <data name="Id" inType="win:UInt64" outType="xs:unsignedLong" />
            <data name="QPCCurrentTime" inType="win:UInt64" outType="xs:unsignedLong" />
          </template>
          <template tid="Template_13">
            <data name="Id" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="Template_15">
            <data name="hwnd" inType="win:Pointer" outType="win:HexInt64" />
            <data name="hr" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="DispatcherMessage">
            <data name="Priority" inType="win:UInt32" outType="xs:unsignedInt" map="DispatcherPriority" />
            <data name="Operation" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Counter">
                <data name="Count" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="PerfElementID">
            <data name="Id" inType="win:Int64" outType="xs:long" />
          </template>
          <template tid="PerfElementInfo">
              <data name="Id" inType="win:Int64" outType="xs:long" />
              <data name="Type" inType="win:UnicodeString" outType="xs:string" />
              <data name="Data" inType="win:UnicodeString" outType="xs:string" />
              <data name="AssemblyID" inType="win:Int64" outType="xs:long" />
          </template>
          <template tid="PerfElementName">
              <data name="Id" inType="win:Int64" outType="xs:long" />
              <data name="Type" inType="win:UnicodeString" outType="xs:string" />
              <data name="Name" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="MeasureData">
              <data name="Id" inType="win:Int64" outType="xs:long" />
              <data name="Width" inType="win:Double" outType="xs:double" />
              <data name="Height" inType="win:Double" outType="xs:double" />
          </template>
          <template tid="ArrangeData">
              <data name="Id" inType="win:Int64" outType="xs:long" />
              <data name="Top" inType="win:Double" outType="xs:double" />
              <data name="Left" inType="win:Double" outType="xs:double" />
              <data name="Width" inType="win:Double" outType="xs:double" />
              <data name="Height" inType="win:Double" outType="xs:double" />
          </template>
          <template tid="LayoutSourceTemplate">
              <data name="Id" inType="win:Int64" outType="xs:long" />
              <data name="source" inType="win:UInt8" map="LayoutSourceMap" />
          </template>
          <template tid="LayoutAborted">
              <data name="LoopDurationMS" inType="win:Int32" outType="xs:int" />
              <data name="loopCounter" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="Template_18">
            <data name="Id" inType="win:Int32" outType="xs:int" />
            <data name="HWND" inType="win:Int64" outType="xs:long" />
          </template>
          <template tid="Template_19">
            <data name="Id" inType="win:Int32" outType="xs:int" />
            <data name="HWND" inType="win:Int64" outType="xs:long" />
            <data name="Msg" inType="win:Int32" outType="xs:int" />
            <data name="WParam" inType="win:Int32" outType="xs:int" />
            <data name="LParam" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="Template_20">
            <data name="Id" inType="win:Int32" outType="xs:int" />
            <data name="QPCExpectedPresentTime" inType="win:Int64" outType="xs:long" />
          </template>
          <template tid="Template_21">
            <data name="QPCFrequency" inType="win:Int64" outType="xs:long" />
            <data name="QPCCurrentTime" inType="win:Int64" outType="xs:long" />
          </template>
          <template tid="Template_22">
            <data name="ContextID" inType="win:Int32" outType="xs:int" />
            <data name="ResponseID" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="Template_23">
            <data name="QPCLastPresentationTime" inType="win:Int64" outType="xs:long" />
            <data name="PresentationResults" inType="win:Int64" outType="xs:long" />
          </template>
          <template tid="Template_24">
            <data name="RenderDelay" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="MessageStringTemplate">
            <data name="Message" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="TypeStringTemplate">
            <data name="Type" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="TimeTick">
            <data name="TickTime" inType="win:Int64" outType="xs:long" />
          </template>
          <template tid="InfoStringTemplate">
            <data name="Info" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Template_30">
            <data name="Result" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="Template_31">
            <data name="FirstVisiblePage" inType="win:Int32" outType="xs:int" />
            <data name="LastVisiblePage" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="Template_32">
            <data name="PageNumber" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="Template_33">
            <data name="VerticalOffset" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="Template_34">
            <data name="PageNumber" inType="win:Int32" outType="xs:int" />
            <data name="FirstVisiblePage" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="Template_35">
            <data name="Zoom" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="Template_37">
            <data name="Id" inType="win:Int32" outType="xs:int" />
            <data name="TypeAndName" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="KeyStringTemplate">
            <data name="Key" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="AssemblyNameTemplate">
            <data name="AssemblyName" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Template_HR">
            <data name="ReturnCode" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="Template_43">
            <data name="URL" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Template_44">
            <data name="Code" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="Text" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Template_45">
            <data name="Location" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Template_46">
            <data name="State" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="Template_47">
            <data name="GUID_Data1" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="CmdId" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="Template_48">
            <data name="CmdFlags" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="HResult" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="Template_49">
            <data name="Path" inType="win:UnicodeString" outType="xs:string" />
            <data name="AppId" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Template_50">
            <data name="ExitCode" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="Template_51">
            <data name="Direct" inType="win:Int8" outType="xs:byte" />
          </template>
          <template tid="URITemplate">
            <data name="URI" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Template_53">
            <data name="AttemptDownload" inType="win:Int8" outType="xs:byte" />
          </template>
          <template tid="Template_54">
            <data name="Page" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Template_55">
            <data name="Bytes" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="Total" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="Template_56">
            <data name="NavigationMode" inType="win:UnicodeString" outType="xs:string" />
            <data name="UriOrObject" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Template_57">
            <data name="PF" inType="win:UnicodeString" outType="xs:string" />
          </template>
          <template tid="Template_58">
            <data name="ProcessHeapPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="MeterTag" inType="win:UnicodeString" outType="xs:string" />
            <data name="ulAllocPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="AllocationSize" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="Template_59">
            <data name="ProcessHeapPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="MeterTag" inType="win:UnicodeString" outType="xs:string" />
            <data name="ulOldAllocPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="ulNewAllocPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="AllocationSize" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="Template_60">
            <data name="ProcessHeapPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="ulAllocPtr" inType="win:Pointer" outType="win:HexInt64" />
          </template>
          <template tid="GfxSoftwareFallback">
            <data name="Reason" inType="win:UInt32" outType="xs:unsignedInt" map="UnexptectedSWFallbackReason" />
          </template>
          <template tid="VisualCacheTemplate">
            <data name="uX" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="uY" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="uWidth" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="uHeight" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="ID32Template">
            <data name="Id" inType="win:Int32" outType="xs:int" />
          </template>      
          <template tid="CreateChannel">
            <data name="ChannelPtr" inType="win:Pointer" outType="xs:HexInt64" />
            <data name="ChannelHandle" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="CreateOrAddOnChnl">
            <data name="PerfEltId" inType="win:Int64" outType="xs:long" />
            <data name="ChannelPtr" inType="win:Pointer" outType="xs:HexInt64" />
            <data name="ResourceHandle" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="ResourceType" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="ReleaseOnChannel">
            <data name="ChannelPtr" inType="win:Pointer" outType="xs:HexInt64" />
            <data name="ResourceHandle" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="CreateWpfGfxResource">
            <data name="ResourcePtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="ChannelHandle" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="ResourceHandle" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="ResourceType" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="WClientParseXamlBamlInfoTemplate">
            <data name="PerfElementID" inType="win:Int64" outType="xs:long" />
            <data name="LineNumber" inType="win:Int32" outType="xs:int" />
            <data name="LinePosition" inType="win:Int32" outType="xs:int" />
          </template>
          <template tid="CreateIRT">
            <data name="ResourcePtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="ParentResourcePtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="Reason" inType="win:UInt32" map="IntermediateRenderTargetReason" />
          </template>
          <template tid="PtrTemplate">
            <data name="Pointer" inType="win:Pointer" outType="win:HexInt64" />
          </template>
          <!-- KeywordHeapMeter - Disabled for now
          <template tid="AllocateMeterTagTemplate">
            <data name="ProcessHeapPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="MeterTag" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="ulAllocPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="AllocationSize" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="ReallocateMeterTagTemplate">
            <data name="ProcessHeapPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="MeterTag" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="ulOldAllocPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="ulNewAllocPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="AllocationSize" inType="win:UInt32" outType="xs:unsignedInt" />
          </template>
          <template tid="FreeMeterTagTemplate">
            <data name="ProcessHeapPtr" inType="win:Pointer" outType="win:HexInt64" />
            <data name="ulAllocPtr" inType="win:Pointer" outType="win:HexInt64" />
          </template>
          <template tid="RegisterMeterTagTemplate">
            <data name="MeterTag" inType="win:AnsiString" outType="xs:string" />          
            <data name="Owner" inType="win:AnsiString" outType="xs:string" />          
            <data name="Description" inType="win:AnsiString" outType="xs:string" />          
            <data name="Flags" inType="win:UInt32" outType="xs:unsignedInt" />          
            <data name="TagId" inType="win:UInt32" outType="xs:unsignedInt" />          
          </template>
          <template tid="AddOrSetMeterTagTemplate">
            <data name="MeterTag" inType="win:UInt32" outType="xs:unsignedInt" />
            <data name="Count" inType="win:Int32" outType="xs:int" />
            <data name="Size" inType="win:Int32" outType="xs:int" />
          </template>
          -->
        </templates>

        <tasks>
          <task name="DrawBitmap" symbol="TDrawBitmap" value="1" eventGUID="{a7f1ef9d-9bb9-4c7d-93ad-11919b122fa2}" />
          <task name="BitmapCopy" symbol="TBitmapCopy" value="2" eventGUID="{5c02c62f-aec1-4f0c-b4a7-511d280184fd}" />
          <task name="SetClip" symbol="TSetClip" value="3" eventGUID="{6acaf5f0-d340-4373-a851-fea1267aa210}" />
          <task name="DWMDraw_Clear" symbol="TDWMDraw_Clear" value="5" eventGUID="{c8960930-bf29-4c06-8574-d4be803f13f9}" />
          <task name="DWMDraw_" symbol="TDWMDraw_" value="8" eventGUID="{c4e8f367-3ba1-4c75-b985-facbb4274dd7}">
              <opcodes>
                  <opcode name="BitmapStart"    symbol="OP_BITMAPSTART"     value="56" />
                  <opcode name="BitmapEnd"      symbol="OP_BITMAPEND"       value="57" />
                  <opcode name="RectangleStart" symbol="OP_RECTANGLESTART"  value="58" />
                  <opcode name="RectangleEnd"   symbol="OP_RECTANGLEEND"    value="59" />
                  <opcode name="GeometryStart"  symbol="OP_GEOMETRYSTART"   value="60"/>
                  <opcode name="GeometryEnd"    symbol="OP_GEOMETRYEND"     value="61"/>
                  <opcode name="ImageStart"     symbol="OP_IMAGESTART"      value="62"/>
                  <opcode name="ImageEnd"       symbol="OP_IMAGEEND"        value="63"/>
                  <opcode name="GlyphRunStart"  symbol="OP_GLYPHRUNSTART"   value="64"/>
                  <opcode name="GlyphRunEnd"    symbol="OP_GLYPHRUNEND"     value="65"/>
                  <opcode name="BeginLayerStart" symbol="OP_BEGINLAYERSTART" value="68"/>
                  <opcode name="BeginLayerEnd"  symbol="OP_BEGINLAYEREND"   value="69"/>
                  <opcode name="EndLayerStart"  symbol="OP_ENDLAYERSTART"   value="70"/>
                  <opcode name="EndLayerEnd"    symbol="OP_ENDLAYEREND"     value="71"/>
                  <opcode name="ClippedBitmapStart" symbol="OP_CLIPPEDBITMAPSTART" value="78"/>
                  <opcode name="ClippedBitmapEnd" symbol="OP_CLIPPEDBITMAPEND" value="79"/>
              </opcodes>
          </task>
          <task name="LayerEvent" symbol="TLayerEvent" value="9" eventGUID="{ead9a51b-d3d3-4b0b-8d25-e4914ed4c1ed}" />
          <task name="WClientDesktopRTCreate" symbol="TWClientDesktopRTCreate" value="12" eventGUID="{2e62c3bf-7c51-43fb-8cdc-915d4abc09dd}" />
          <task name="WClientUceProcessQueue" symbol="TWClientUceProcessQueue" value="13" eventGUID="{b7c7f692-f2b4-447a-b5df-fa6c314889ae}" />
          <task name="WClientUcePrecompute" symbol="TWClientUcePrecompute" value="14" eventGUID="{de51ae60-46ad-4cc0-9a29-426a87e88e9f}" />
          <task name="WClientUceRender" symbol="TWClientUceRender" value="15" eventGUID="{92ca500c-67b1-447f-9497-cfd6d52a5b0e}" />
          <task name="WClientUcePresent" symbol="TWClientUcePresent" value="16" eventGUID="{4c48d6ef-ac14-4d84-ba37-49a94ba8d2af}" />
          <task name="WClientUceResponse" symbol="TWClientUceResponse" value="17" eventGUID="{4c253b24-7230-4fa1-9748-ac4c59cf288c}" />
          <task name="WClientUceCheckDeviceState" symbol="TWClientUceCheckDeviceState" value="19" eventGUID="{76601d6d-c6d4-4e8d-ac6e-3f9b4f1745e0}" />
          <task name="WClientUIContextDispatch" symbol="TWClientUIContextDispatch" value="20" eventGUID="{2481a374-999f-4ad2-9f22-6b7c8e2a5db0}" />
          <task name="WClientUIContextPost" symbol="TWClientUIContextPost" value="21" eventGUID="{76287aef-f674-4061-a60a-76f95550efeb}" />
          <task name="WClientUIContextAbort" symbol="TWClientUIContextAbort" value="22" eventGUID="{39404da9-413f-4581-a0a1-4715168b5ad8}" />
          <task name="WClientUIContextPromote" symbol="TWClientUIContextPromote" value="23" eventGUID="{632d4e9e-b988-4b32-ab2a-b37aa34927ee}" />
          <task name="WClientUIContextIdle" symbol="TWClientUIContextIdle" value="24" eventGUID="{c626ebef-0780-487f-81d7-38d3f0a6f05e}" />
          <task name="WClientLayout" symbol="TWClientLayout" value="25" eventGUID="{a3edb710-21fc-4f91-97f4-ac2b0df1c20f}">
              <opcodes>
                  <opcode name="Abort"                     symbol="OP_LAYOUT_ABORT"               value="10" />
                  <opcode name="FireSizeChangedBegin"      symbol="OP_SIZE_CHANGED"               value="11" />
                  <opcode name="FireSizeChangedEnd"        symbol="OP_SIZE_CHANGED_END"           value="12" />
                  <opcode name="FireLayoutUpdatedBegin"    symbol="OP_FIRE_LAYOUT_UPDATED_START"  value="13" />
                  <opcode name="FireLayoutUpdatedEnd"      symbol="OP_FIRE_LAYOUT_UPDATED_STOP"   value="14" />
                  <opcode name="FireAutomationEventsBegin" symbol="OP_FIRE_AUTOMATION_EVENTS"     value="15" />
                  <opcode name="FireAutomationEventsEnd"   symbol="OP_FIRE_AUTOMATION_EVENTS_END" value="16" />
                  <opcode name="Exception"                 symbol="OP_LAYOUT_EXCEPTION"           value="17" />
                  <opcode name="Invalidated"               symbol="OP_LAYOUT_INVALIDATED"         value="18" />
              </opcodes>
          </task>
          <task name="WClientMeasure" symbol="TWClientMeasure" value="26" eventGUID="{3005e67b-129c-4ced-bcaa-91d7d73b1544}">
              <opcodes>
                  <opcode name="MeasureAbort" symbol="OP_MEASURE_ABORT" value="10" />
                  <opcode name="MeasureElementBegin" symbol="OP_MEASURE_ELEMENT_BEGIN" value="11" />
                  <opcode name="MeasureElementEnd" symbol="OP_MEASURE_ELEMENT_END" value="12" />
              </opcodes>
          </task>
          <task name="WClientArrange" symbol="TWClientArrange" value="27" eventGUID="{4b0ef3d1-0cbb-4847-b98f-16408e7e83f3}">
              <opcodes>
                  <opcode name="ArrangeAbort" symbol="OP_ARRANGE_ABORT" value="10" />
                  <opcode name="ArrangeElementBegin" symbol="OP_ARRANGE_ELEMENT_BEGIN" value="11" />
                  <opcode name="ArrangeElementEnd" symbol="OP_ARRANGE_ELEMENT_END" value="12" />
              </opcodes>
          </task>
          <task name="WClientCreateVisual" symbol="TWClientCreateVisual" value="28" eventGUID="{2dbecf62-51ea-493a-8dd0-4bee1ccbe8aa}" />
          <task name="WClientInputMessage" symbol="TWClientInputMessage" value="29" eventGUID="{4ac79bac-7dfb-4402-a910-fdafe16f29b2}" />
          <task name="WClientRenderHandler" symbol="TWClientRenderHandler" value="30" eventGUID="{7723d8b7-488b-4f80-b089-46a4c6aca1c4}" />
          <task name="WClientAnimRenderHandler" symbol="TWClientAnimRenderHandler" value="31" eventGUID="{521c1c8d-faaa-435b-ad8c-1d64442bfd70}" />
          <task name="WClientMediaRender" symbol="TWClientMediaRender" value="32" eventGUID="{6827e447-0e0e-4b5e-ae81-b79a00ec8349}" />
          <task name="WClientPostRender" symbol="TWClientPostRender" value="33" eventGUID="{fb69cd45-c00d-4c23-9765-69c00344b2c5}" />
          <task name="WClientQPCFrequency" symbol="TWClientQPCFrequency" value="34" eventGUID="{30ee0097-084c-408b-9038-73bed0479873}" />
          <task name="WClientPrecomputeScene" symbol="TWClientPrecomputeScene" value="35" eventGUID="{3331420f-7a3b-42b6-8dfe-aabf472801da}" />
          <task name="WClientCompileScene" symbol="TWClientCompileScene" value="36" eventGUID="{af36fcb5-58e5-48d0-88d0-d8f4dcb56a12}" />
          <task name="WClientUIResponse" symbol="TWClientUIResponse" value="37" eventGUID="{ab29585b-4794-4465-91e6-9df5861c88c5}" />
          <task name="WClientUICommitChannel" symbol="TWClientUICommitChannel" value="38" eventGUID="{f9c0372e-60bd-46c9-bc64-94fe5fd31fe4}" />
          <task name="WClientUceNotifyPresent" symbol="TWClientUceNotifyPresent" value="39" eventGUID="{24cd1476-e145-4e5a-8bfc-50c36bbdf9cc}" />
          <task name="WClientScheduleRender" symbol="TWClientScheduleRender" value="40" eventGUID="{6d5aeaf3-a433-4daa-8b31-d8ae49cf6bd1}" />
          <task name="WClientParseBaml" symbol="TWClientParseBaml" value="41" eventGUID="{8a1e3af5-3a6d-4582-86d1-5901471ebbde}" />
          <task name="WClientParseXaml" symbol="TWClientParseXaml" value="42" eventGUID="{3164257a-c9be-4c36-9d8f-09b18ac880a6}" />
          <task name="WClientParseXml" symbol="TWClientParseXml" value="43" eventGUID="{bf86e5bf-3fb4-442f-a34a-b207a3b19c3b}" />
          <task name="WClientParseFefCrInst" symbol="TWClientParseFefCrInst" value="44" eventGUID="{f7555161-6c1a-4a12-828d-8492a7699a49}" />
          <task name="WClientParseInstVisTree" symbol="TWClientParseInstVisTree" value="45" eventGUID="{a8c3b9c0-562b-4509-becb-a08e481a7273}" />
          <task name="WClientParseRdrCrInst" symbol="TWClientParseRdrCrInst" value="46" eventGUID="{8ba8f51c-0775-4adf-9eed-b1654ca088f5}" />
          <task name="WClientParseRdrCrInFTyp" symbol="TWClientParseRdrCrInFTyp" value="47" eventGUID="{0da15d58-c3a7-40de-9113-72db0c4a9351}" />
          <task name="WClientAppCtor" symbol="TWClientAppCtor" value="48" eventGUID="{f9f048c6-2011-4d0a-812a-23a4a4d801f5}" />
          <task name="WClientAppRun" symbol="TWClientAppRun" value="49" eventGUID="{08a719d6-ea79-4abc-9799-38eded602133}" />
          <task name="WClientTimeManagerTick" symbol="TWClientTimeManagerTick" value="50" eventGUID="{ea3b4b66-b25f-4e5d-8bd4-ec62bb44583e}" />
          <task name="WClientString" symbol="TWClientString" value="51" eventGUID="{6b3c0258-9ddb-4579-8660-41c3ada25c34}" />
          <task name="WClientFontCache" symbol="TWClientFontCache" value="52" eventGUID="{f3362106-b861-4980-9aac-b1ef0bab75aa}" />
          <task name="WClientDRXOpenPackage" symbol="TWClientDRXOpenPackage" value="53" eventGUID="{2b8f75f3-f8f9-4075-b914-5ae853c76276}" />
          <task name="WClientDRXReadStream" symbol="TWClientDRXReadStream" value="54" eventGUID="{c2b15025-7812-4e44-8b68-7d734303438a}" />
          <task name="WClientDRXGetStream" symbol="TWClientDRXGetStream" value="55" eventGUID="{3f4510eb-9ee8-4b80-9ec7-775efeb1ba72}" />
          <task name="WClientDRXPageVisible" symbol="TWClientDRXPageVisible" value="56" eventGUID="{2ae7c601-0aec-4c99-ba80-2eca712d1b97}" />
          <task name="WClientDRXPageLoaded" symbol="TWClientDRXPageLoaded" value="57" eventGUID="{66028645-e022-4d90-a7bd-a8ccdacdb2e1}" />
          <task name="WClientDRXInvalidateView" symbol="TWClientDRXInvalidateView" value="58" eventGUID="{3be3740f-0a31-4d22-a2a3-4d4b6d3ab899}" />
          <task name="WClientDRXLineDown" symbol="TWClientDRXLineDown" value="59" eventGUID="{b67ab12c-29bf-4020-b678-f043925b8235}" />
          <task name="WClientDRXPageDown" symbol="TWClientDRXPageDown" value="60" eventGUID="{d7cdeb52-5ba3-4e02-b114-385a61e7ba9d}" />
          <task name="WClientDRXPageJump" symbol="TWClientDRXPageJump" value="61" eventGUID="{f068b137-7b09-44a1-84d0-4ff1592e0ac1}" />
          <task name="WClientDRXLayout" symbol="TWClientDRXLayout" value="62" eventGUID="{34fbea40-0238-498f-b12a-631f5a8ef9a5}" />
          <task name="WClientDRXInstantiated" symbol="TWClientDRXInstantiated" value="63" eventGUID="{9de677e1-914a-426c-bcd9-2ccdea3648df}" />
          <task name="WClientDRXStyleCreated" symbol="TWClientDRXStyleCreated" value="64" eventGUID="{69737c35-1636-43be-a352-428ca36d1b2c}" />
          <task name="WClientDRXFind" symbol="TWClientDRXFind" value="65" eventGUID="{ff8efb74-efaa-424d-9022-ee8d21ad804e}" />
          <task name="WClientDRXZoom" symbol="TWClientDRXZoom" value="66" eventGUID="{2e5045a1-8dac-4c90-9995-3260de166c8f}" />
          <task name="WClientDRXEnsureOM" symbol="TWClientDRXEnsureOM" value="67" eventGUID="{28e3a8bb-aebb-48e8-86b6-32759b47fcbe}" />
          <task name="WClientDRXGetPage" symbol="TWClientDRXGetPage" value="68" eventGUID="{a0c17259-c6b1-4850-a9ab-13659fe6dc58}" />
          <task name="WClientDRXTreeFlatten" symbol="TWClientDRXTreeFlatten" value="69" eventGUID="{b4557454-212b-4f57-b9ca-2ba9d58273b3}" />
          <task name="WClientDRXAlphaFlatten" symbol="TWClientDRXAlphaFlatten" value="70" eventGUID="{302f02e9-f025-4083-abd5-2ce3aaa9a3cf}" />
          <task name="WClientDRXGetDevMode" symbol="TWClientDRXGetDevMode" value="71" eventGUID="{573ea8dc-db6c-42c0-91f8-964e39cb6a70}" />
          <task name="WClientDRXStartDoc" symbol="TWClientDRXStartDoc" value="72" eventGUID="{f3fba666-fa0f-4487-b846-9f204811bf3d}" />
          <task name="WClientDRXEndDoc" symbol="TWClientDRXEndDoc" value="73" eventGUID="{743dd3cf-bbce-4e69-a4db-85226ec6a445}" />
          <task name="WClientDRXStartPage" symbol="TWClientDRXStartPage" value="74" eventGUID="{5303d552-28ab-4dac-8bcd-0f7d5675a157}" />
          <task name="WClientDRXEndPage" symbol="TWClientDRXEndPage" value="75" eventGUID="{e20fddf4-17a6-4e5f-8693-3dd7cb049422}" />
          <task name="WClientDRXCommitPage" symbol="TWClientDRXCommitPage" value="76" eventGUID="{7d7ee18d-aea5-493f-9ef2-bbdb36fcaa78}" />
          <task name="WClientDRXConvertFont" symbol="TWClientDRXConvertFont" value="77" eventGUID="{88fc2d42-b1de-4588-8c3b-dc5bec03a9ac}" />
          <task name="WClientDRXConvertImage" symbol="TWClientDRXConvertImage" value="78" eventGUID="{17fddfdc-a1be-43b3-b2ee-f5e89b7b1b26}" />
          <task name="WClientDRXSaveXps" symbol="TWClientDRXSaveXps" value="79" eventGUID="{ba0320d5-2294-4067-8b19-ef9cddad4b1a}" />
          <task name="WClientDRXLoadPrimitive" symbol="TWClientDRXLoadPrimitive" value="80" eventGUID="{d0b70c99-450e-4872-a2d4-fbfb1dc797fa}" />
          <task name="WClientDRXSavePage" symbol="TWClientDRXSavePage" value="81" eventGUID="{b0e3e78b-9ac7-473c-8903-b5d212399e3b}" />
          <task name="WClientDRXSerialization" symbol="TWClientDRXSerialization" value="82" eventGUID="{0527276c-d3f4-4293-b88c-ecdf7cac4430}" />
          <task name="WClientPropParentCheck" symbol="TWClientPropParentCheck" value="85" eventGUID="{831bea07-5a2c-434c-8ef8-7eba41c881fb}" />
          <task name="WClientResourceFind" symbol="TWClientResourceFind" value="86" eventGUID="{228d90d5-7e19-4480-9e56-3af2e90f8da6}" />
          <task name="WClientResourceCacheValue" symbol="TWClientResourceCacheValue" value="87" eventGUID="{3b253e2d-72a5-489e-8c65-56c1e6c859b5}" />
          <task name="WClientResourceCacheNull" symbol="TWClientResourceCacheNull" value="88" eventGUID="{7866a65b-2f38-43b6-abd2-df433bbca073}" />
          <task name="WClientResourceCacheMiss" symbol="TWClientResourceCacheMiss" value="89" eventGUID="{0420755f-d416-4f15-939f-3e2cd3fcea23}" />
          <task name="WClientResourceStock" symbol="TWClientResourceStock" value="90" eventGUID="{06f0fee4-72dd-4802-bd3d-0985139fa91a}" />
          <task name="WClientResourceBamlAssembly" symbol="TWClientResourceBamlAssembly" value="91" eventGUID="{19df4373-6680-4a04-8c77-d2f6809ca703}" />
          <task name="CreateStickyNote" symbol="TCreateStickyNote" value="92" eventGUID="{e3dbffac-1e92-4f48-a65a-c290bd5f5f15}" />
          <task name="DeleteTextNote" symbol="TDeleteTextNote" value="93" eventGUID="{7626a2f9-9a61-43a3-b7cc-bb84c2493aa7}" />
          <task name="DeleteInkNote" symbol="TDeleteInkNote" value="94" eventGUID="{bf7e2a93-9d6a-453e-badb-3f8f60075cf2}" />
          <task name="CreateHighlight" symbol="TCreateHighlight" value="95" eventGUID="{c2a5edb8-ac73-41ef-a943-a8a49fa284b1}" />
          <task name="ClearHighlight" symbol="TClearHighlight" value="96" eventGUID="{e1a59147-d28d-4c5f-b980-691be2fd4208}" />
          <task name="LoadAnnotations" symbol="TLoadAnnotations" value="97" eventGUID="{cf3a283e-c004-4e7d-b3b9-cc9b582a4a5f}" />
          <task name="AddAnnotation" symbol="TAddAnnotation" value="99" eventGUID="{8f4b2faa-24d6-4ee2-9935-bbf845f758a2}" />
          <task name="DeleteAnnotation" symbol="TDeleteAnnotation" value="100" eventGUID="{4d832230-952a-4464-80af-aab2ac861703}" />
          <task name="GetAnnotationById" symbol="TGetAnnotationById" value="101" eventGUID="{3d27753f-eb8a-4e75-9d5b-82fba55cded1}" />
          <task name="GetAnnotationByLoc" symbol="TGetAnnotationByLoc" value="102" eventGUID="{741a41bc-8ecd-43d1-a7f1-d2faca7362ef}" />
          <task name="GetAnnotations" symbol="TGetAnnotations" value="103" eventGUID="{cd9f6017-7e64-4c61-b9ed-5c2fc8c4d849}" />
          <task name="SerializeAnnotation" symbol="TSerializeAnnotation" value="104" eventGUID="{0148924b-5bea-43e9-b3ed-399ca13b35eb}" />
          <task name="DeserializeAnnotation" symbol="TDeserializeAnnotation" value="105" eventGUID="{2e32c255-d6db-4de7-9e62-9586377778d5}" />
          <task name="UpdateAnnotationWithSNC" symbol="TUpdateAnnotationWithSNC" value="106" eventGUID="{205e0a58-3c7d-495d-b3ed-18c3fb38923f}" />
          <task name="UpdateSNCWithAnnotation" symbol="TUpdateSNCWithAnnotation" value="107" eventGUID="{59c337ce-9cc2-4a86-9bfa-061fe954086b}" />
          <task name="AnnotationTextChanged" symbol="TAnnotationTextChanged" value="108" eventGUID="{8bb912b9-39dd-4208-ad62-be66fe5b7ba5}" />
          <task name="AnnotationInkChanged" symbol="TAnnotationInkChanged" value="109" eventGUID="{1228e154-f171-426e-b672-5ee19b755edf}" />
          <task name="AddAttachedSN" symbol="TAddAttachedSN" value="110" eventGUID="{9ca660f6-8d7c-4a90-a92f-74482d9cc1cf}" />
          <task name="RemoveAttachedSN" symbol="TRemoveAttachedSN" value="111" eventGUID="{8c4c69f7-1185-46df-a5f5-e31ac7e96c07}" />
          <task name="AddAttachedHighlight" symbol="TAddAttachedHighlight" value="112" eventGUID="{56d2cae5-5ec0-44fb-98c2-453e87a0877b}" />
          <task name="RemoveAttachedHighlight" symbol="TRemoveAttachedHighlight" value="113" eventGUID="{4c81d490-9004-49d1-87d7-289d53a314ef}" />
          <task name="AddAttachedMH" symbol="TAddAttachedMH" value="114" eventGUID="{7ea1d548-ca17-ca17-a1a8-f1857db6302e}" />
          <task name="RemoveAttachedMH" symbol="TRemoveAttachedMH" value="115" eventGUID="{296c7961-b975-450b-8975-bf862b6c7159}" />
          <task name="WpfHostUm" symbol="TWpfHostUm_" value="116" eventGUID="{ed251760-7bbc-4b25-8328-cd7f271fee89}">
              <opcodes>
                <opcode name="WinMainStart" symbol="WINMAINSTART" value="30"/>
                <opcode name="WinMainEnd" symbol="WINMAINEND" value="31"/>
                <opcode name="InvokingBrowser" symbol="INVOKINGBROWSER" value="32"/>
                <opcode name="LaunchingRestrictedProcess" symbol="LAUNCHINGRESTRICTEDPROCESS" value="33"/>
                <opcode name="EnteringMessageLoop" symbol="ENTERINGMESSAGELOOP" value="34"/>
                <opcode name="ClassFactoryCreateInstance" symbol="CLASSFACTORYCREATEINSTANCE" value="35"/>
                <opcode name="ReadingDeplManifestStart" symbol="READINGDEPLMANIFESTSTART" value="40"/>
                <opcode name="ReadingDeplManifestEnd" symbol="READINGDEPLMANIFESTEND" value="41"/>
                <opcode name="ReadingAppManifestStart" symbol="READINGAPPMANIFESTSTART" value="42"/>
                <opcode name="ReadingAppManifestEnd" symbol="READINGAPPMANIFESTEND" value="43"/>
                <opcode name="ParsingMarkupVersionStart" symbol="PARSINGMARKUPVERSIONSTART" value="44"/>
                <opcode name="ParsingMarkupVersionEnd" symbol="PARSINGMARKUPVERSIONEND" value="45"/>
                <opcode name="IPersistFileLoad" symbol="IPERSISTFILELOAD" value="50"/>
                <opcode name="IPersistMonikerLoadStart" symbol="IPERSISTMONIKERLOADSTART" value="51"/>
                <opcode name="IPersistMonikerLoadEnd" symbol="IPERSISTMONIKERLOADEND" value="52"/>
                <opcode name="BindProgress" symbol="BINDPROGRESS" value="53"/>
                <opcode name="OnStopBinding" symbol="ONSTOPBINDING" value="54"/>
                <opcode name="VersionAttach" symbol="VERSIONATTACH" value="60"/>
                <opcode name="VersionActivateStart" symbol="VERSIONACTIVATESTART" value="61"/>
                <opcode name="VersionActivateEnd" symbol="VERSIONACTIVATEEND" value="62"/>
                <opcode name="StartingCLRStart" symbol="STARTINGCLRSTART" value="90"/>
                <opcode name="StartingCLREnd" symbol="STARTINGCLREND" value="91"/>
                <opcode name="IHlinkTargetNavigateStart" symbol="IHLINKTARGETNAVIGATESTART" value="95"/>
                <opcode name="IHlinkTargetNavigateEnd" symbol="IHLINKTARGETNAVIGATEEND" value="96"/>
                <opcode name="ReadyStateChanged" symbol="READYSTATECHANGED" value="97"/>
                <opcode name="InitDocHostStart" symbol="INITDOCHOSTSTART" value="98"/>
                <opcode name="InitDocHostEnd" symbol="INITDOCHOSTEND" value="99"/>
                <opcode name="MergingMenusStart" symbol="MERGINGMENUSSTART" value="100"/>
                <opcode name="MergingMenusEnd" symbol="MERGINGMENUSEND" value="101"/>
                <opcode name="UIActivationStart" symbol="UIACTIVATIONSTART" value="102"/>
                <opcode name="UIActivationEnd" symbol="UIACTIVATIONEND" value="103"/>
                <opcode name="LoadingResourceDLLStart" symbol="LOADINGRESOURCEDLLSTART" value="104"/>
                <opcode name="LoadingResourceDLLEnd" symbol="LOADINGRESOURCEDLLEND" value="105"/>
                <opcode name="OleCmdQueryStatusStart" symbol="OLECMDQUERYSTATUSSTART" value="106"/>
                <opcode name="OleCmdQueryStatusEnd" symbol="OLECMDQUERYSTATUSEND" value="107"/>
                <opcode name="OleCmdExecStart" symbol="OLECMDEXECSTART" value="108"/>
                <opcode name="OleCmdExecEnd" symbol="OLECMDEXECEND" value="109"/>
                <opcode name="ProgressPageShown" symbol="PROGRESSPAGESHOWN" value="110"/>
                <opcode name="AdHocProfile1Start" symbol="ADHOCPROFILE1START" value="152"/>
                <opcode name="AdHocProfile1End" symbol="ADHOCPROFILE1END" value="153"/>
                <opcode name="AdHocProfile2Start" symbol="ADHOCPROFILE2START" value="154"/>
                <opcode name="AdHocProfile2End" symbol="ADHOCPROFILE2END" value="155"/>
              </opcodes>
          </task>
          <task name="WpfHost" symbol="TWpfHost_" value="117" eventGUID="{5ff6b585-7fb9-4189-beb3-54c82ce4d7d1}">
              <opcodes>
                <opcode name="DocObjHostCreated" symbol="DOCOBJHOSTCREATED" value="10"/>
                <opcode name="IBHSRunStart" symbol="IBHSRUNSTART" value="11"/>
                <opcode name="IBHSRunEnd" symbol="IBHSRUNEND" value="12"/>
                <opcode name="XappLauncherAppStartup" symbol="XAPPLAUNCHERAPPSTARTUP" value="13"/>
                <opcode name="XappLauncherAppExit" symbol="XAPPLAUNCHERAPPEXIT" value="14"/>
                <opcode name="DocObjHostRunApplicationStart" symbol="DOCOBJHOSTRUNAPPLICATIONSTART" value="15"/>
                <opcode name="DocObjHostRunApplicationEnd" symbol="DOCOBJHOSTRUNAPPLICATIONEND" value="16"/>
                <opcode name="ClickOnceActivationStart" symbol="CLICKONCEACTIVATIONSTART" value="17"/>
                <opcode name="ClickOnceActivationEnd" symbol="CLICKONCEACTIVATIONEND" value="18"/>
                <opcode name="InitAppProxyStart" symbol="INITAPPPROXYSTART" value="19"/>
                <opcode name="InitAppProxyEnd" symbol="INITAPPPROXYEND" value="20"/>
                <opcode name="AppProxyCtor" symbol="APPPROXYCTOR" value="30"/>
                <opcode name="RootBrowserWindowSetupStart" symbol="ROOTBROWSERWINDOWSETUPSTART" value="31"/>
                <opcode name="RootBrowserWindowSetupEnd" symbol="ROOTBROWSERWINDOWSETUPEND" value="32"/>
                <opcode name="AppProxyRunStart" symbol="APPPROXYRUNSTART" value="33"/>
                <opcode name="AppProxyRunEnd" symbol="APPPROXYRUNEND" value="34"/>
                <opcode name="AppDomainManagerCctor" symbol="APPDOMAINMANAGERCCTOR" value="40"/>
                <opcode name="ApplicationActivatorCreateInstanceStart" symbol="APPLICATIONACTIVATORCREATEINSTANCESTART" value="41"/>
                <opcode name="ApplicationActivatorCreateInstanceEnd" symbol="APPLICATIONACTIVATORCREATEINSTANCEEND" value="42"/>
                <opcode name="DetermineApplicationTrustStart" symbol="DETERMINEAPPLICATIONTRUSTSTART" value="43"/>
                <opcode name="DetermineApplicationTrustEnd" symbol="DETERMINEAPPLICATIONTRUSTEND" value="44"/>
                <opcode name="FirstTimeActivation" symbol="FIRSTTIMEACTIVATION" value="50"/>
                <opcode name="GetDownloadPageStart" symbol="GETDOWNLOADPAGESTART" value="51"/>
                <opcode name="GetDownloadPageEnd" symbol="GETDOWNLOADPAGEEND" value="52"/>
                <opcode name="DownloadDeplManifestStart" symbol="DOWNLOADDEPLMANIFESTSTART" value="53"/>
                <opcode name="DownloadDeplManifestEnd" symbol="DOWNLOADDEPLMANIFESTEND" value="54"/>
                <opcode name="AssertAppRequirementsStart" symbol="ASSERTAPPREQUIREMENTSSTART" value="55"/>
                <opcode name="AssertAppRequirementsEnd" symbol="ASSERTAPPREQUIREMENTSEND" value="56"/>
                <opcode name="DownloadApplicationStart" symbol="DOWNLOADAPPLICATIONSTART" value="57"/>
                <opcode name="DownloadApplicationEnd" symbol="DOWNLOADAPPLICATIONEND" value="58"/>
                <opcode name="DownloadProgressUpdate" symbol="DOWNLOADPROGRESSUPDATE" value="59"/>
                <opcode name="XappLauncherAppNavigated" symbol="XAPPLAUNCHERAPPNAVIGATED" value="60"/>
                <opcode name="StartingFontCacheServiceStart" symbol="STARTINGFONTCACHESERVICESTART" value="61"/>
                <opcode name="StartingFontCacheServiceEnd" symbol="STARTINGFONTCACHESERVICEEND" value="62"/>
                <opcode name="UpdateBrowserCommandsStart" symbol="UPDATEBROWSERCOMMANDSSTART" value="70"/>
                <opcode name="UpdateBrowserCommandsEnd" symbol="UPDATEBROWSERCOMMANDSEND" value="71"/>
                <opcode name="PostShutdown" symbol="POSTSHUTDOWN" value="80"/>
                <opcode name="AbortingActivation" symbol="ABORTINGACTIVATION" value="81"/>
              </opcodes>
           </task>
           <task name="Navigation" symbol="TNavigation" value="118" eventGUID="{6ffb9c25-5c8a-4091-989c-5b596ab286a0}">
             <opcodes>
               <opcode name="NavigationStart" symbol="NAVIGATIONSTART" value="10"/>
               <opcode name="NavigationAsyncWorkItem" symbol="NAVIGATIONASYNCWORKITEM" value="11"/>
               <opcode name="NavigationWebResponseReceived" symbol="NAVIGATIONWEBRESPONSERECEIVED" value="12"/>
               <opcode name="NavigationLaunchBrowser" symbol="NAVIGATIONLAUNCHBROWSER" value="13"/>
               <opcode name="NavigationEnd" symbol="NAVIGATIONEND" value="14"/>
               <opcode name="NavigationContentRendered" symbol="NAVIGATIONCONTENTRENDERED" value="15"/>
               <opcode name="NavigationPageFunctionReturn" symbol="NAVIGATIONPAGEFUNCTIONRETURN" value="16"/>
             </opcodes>
           </task>
          <task name="WClientOnRender" symbol="TWClientOnRender" value="120" eventGUID="{3A475CEF-0E2A-449b-986E-EFFF5D6260E7}" />
          <task name="WClientDRXFlushPage" symbol="WClientDRXFlushPage" value="121" eventGUID="{5303d552-28ab-4dac-8bcd-0f7d5675a158}" />
          <task name="WClientDRXGetVisual" symbol="WClientDRXGetVisual" value="122" eventGUID="{5303d552-28ab-4dac-8bcd-0f7d5675a159}" />
          <task name="WClientDRXSerializeTree" symbol="WClientDRXSerializeTree" value="123" eventGUID="{5303d552-28ab-4dac-8bcd-0f7d5675a15a}" />
          <task name="WClientDRXReleaseWriter" symbol="WClientDRXReleaseWriter" value="124" eventGUID="{5303d552-28ab-4dac-8bcd-0f7d5675a15b}" />
          <task name="WClientDRXGetPrintCap" symbol="WClientDRXGetPrintCap" value="125" eventGUID="{5303d552-28ab-4dac-8bcd-0f7d5675a15c}" />
          <task name="WClientDRXPTProvider" symbol="WClientDRXPTProvider" value="126" eventGUID="{5303d552-28ab-4dac-8bcd-0f7d5675a15d}" />
          <task name="WClientDRXRaster" symbol="WClientDRXRaster" value="127" eventGUID="{5303d552-28ab-4dac-8bcd-0f7d5675a15e}" />
          <task name="UnexpectedSoftwareFallback" symbol="TUnexpectedSoftwareFallback" value="128" eventGUID="{7d2c8338-c13c-4c5c-867a-c56c980354e4}" />
          <task name="UpdateVisualState" symbol="UpdateVisualState" value="129" eventGUID="{07a7dd63-b52d-4eff-ac3f-2448daf97499}" />
          <task name="VisualCacheAlloc" symbol="TVisualCacheAlloc" value="130" eventGUID="{85EB64F6-DC84-43c6-B14C-3BD607F42C0D}" />
          <task name="VisualCacheUpdate" symbol="TVisualCacheUpdate" value="131" eventGUID="{A4FDB257-F156-48f6-B0F5-C4A944B553FB}" />
          <task name="StylusEventQueued" symbol="TStylusEventQueued" value="132" eventGUID="{41ECD0F8-F5A6-4aae-9E85-CAECE119B853}" />
          <task name="TouchDownReported" symbol="TTouchDownReported" value="133" eventGUID="{837AD37A-8CEF-4c0c-944A-AE3B1F1C2557}" />
          <task name="TouchMoveReported" symbol="TTouchMoveReported" value="134" eventGUID="{FD718E3F-5462-4227-A610-75D5BF8967A2}" />
          <task name="TouchUpReported" symbol="TTouchUpReported" value="135" eventGUID="{C2AC85A3-E16B-4d07-90DE-1E686394B831}" />
          <task name="ManipulationReportFrame" symbol="TManipulationReportFrame" value="136" eventGUID="{E185D096-6EB9-41be-81F4-75D924425872}" />
          <task name="ManipulationEventRaised" symbol="TManipulationEventRaised" value="137" eventGUID="{51F685EB-B111-400d-B3E3-46022F66A894}" />          
          <task name="WClientInterlockedRender" symbol="TWClientInterlockedRender" value="138" eventGUID="{7FE9630D-93DD-45B1-9459-21C7A4113174}" />          
          <task name="CreateOrAddOnChnl" symbol="TCreateOrAddResourceOnChannel" value="139" eventGUID="{a9ee6bda-f0df-4e2d-a3dd-25ca8fb39f1f}" />
          <task name="CreateWpfGfxResource" symbol="TCreateWpfGfxResource" value="140" eventGUID="{9de2b56b-79a4-497c-88f2-d5bedc042a9d}" />
          <task name="CreateChannel" symbol="TCreateChannel" value="141" eventGUID="{1c415c02-1446-480c-a81e-b2967ee7e20a}" />
          <task name="ReleaseOnChannel" symbol="TReleaseOnChannel" value="142" eventGUID="{8a61870b-a794-477e-9093-282e09eabe59}" />
          <task name="WPFElementID" symbol="TWPFName" value="143" eventGUID="{A060D980-4C18-4953-81DF-CFDFD345C5CA}">
              <opcodes>
                  <opcode name="ElementName" symbol="OP_WPF_ELEMENT_NAME" value="10" />
              </opcodes>
          </task>
          <!-- Tasks for KeywordHeapMeter - Currently disabled
          <task name="WpfGraphicsAlloc" symbol="TWpfGraphicsAlloc" value="10001" eventGUID="{ea873906-2175-4780-8fe2-84bf7cd0b7a7}" />
          <task name="WpfGraphicsRealloc" symbol="TWpfGraphicsRealloc" value="10002" eventGUID="{00b88fba-7bdc-4820-9231-851014c95f7b}" />
          <task name="WpfGraphicsFree" symbol="TWpfGraphicsFree" value="10003" eventGUID="{dbb60caa-6050-4659-b884-d7662a7a4155}" />
          <task name="WpfGraphicsRegisterMeterTag" symbol="TWpfGraphicsRegisterMeterTag" value="10004" eventGUID="{7ae4458c-a345-4678-a6de-b75c540ce1fd}" />
          <task name="WpfGraphicsAddMeterTag" symbol="TWpfGraphicsAddMeterTag" value="10005" eventGUID="{7315a9c0-514b-4fda-8059-78f87dac3ecd}" />
          <task name="WpfGraphicsSetMeterTag" symbol="TWpfGraphicsSetMeterTag" value="10006" eventGUID="{1ad41178-47ee-476d-a0c6-58ea45f9c0a4}" />
          -->
          <task name="WClientParseXamlBamlInfo" symbol="TWClientParseXamlBamlInfo" value="144" eventGUID="{00c117d0-8234-4efa-ace3-73ba1c655f28}" />
          <task name="WClientCreateIRT" symbol="TWClientCreateIRT" value="145" eventGUID="{d56e7b1e-e24c-4b0b-9c4a-8881f7005633}" />
          <task name="WClientPotentialIRTResource" symbol="TWClientPotentialIRTResource" value="146" eventGUID="{4055bbd6-ba41-4bd0-bc0d-6b67965229be}" />
        </tasks>

        <events>
            <event value="1"    level="win:Informational" task="WClientCreateVisual"         opcode="win:Info"        template="Template_18"         symbol="WClientCreateVisual"                   version="2" channel="DefaultChannel" keywords="KeywordGeneral"  />
            <event value="2"    level="win:Informational" task="WClientAppCtor"              opcode="win:Info"        template="Template_0"          symbol="WClientAppCtor"                        version="2" channel="DefaultChannel" keywords="KeywordGeneral KeywordPerf"  />
            <event value="3"    level="win:Informational" task="WClientAppRun"               opcode="win:Info"        template="Template_0"          symbol="WClientAppRun"                         version="2" channel="DefaultChannel" keywords="KeywordGeneral KeywordPerf"  />
            <event value="4"    level="win:Informational" task="WClientString"               opcode="win:Info"        template="InfoStringTemplate"  symbol="WClientString"                         version="2" channel="DefaultChannel" keywords="KeywordGeneral"  />
            <event value="5"    level="win:Informational" task="WClientString"               opcode="win:Start"       template="InfoStringTemplate"  symbol="WClientStringBegin"                    version="2" channel="DefaultChannel" keywords="KeywordGeneral"  />
            <event value="6"    level="win:Informational" task="WClientString"               opcode="win:Stop"        template="InfoStringTemplate"  symbol="WClientStringEnd"                      version="2" channel="DefaultChannel" keywords="KeywordGeneral"  />
            <event value="7"    level="win:Informational" task="WClientPropParentCheck"      opcode="win:Info"        template="Template_37"         symbol="WClientPropParentCheck"                version="2" channel="DefaultChannel" keywords="KeywordGeneral"  />
            <event value="8"    level="win:Informational" task="UpdateVisualState"           opcode="win:Start"       template="Template_0"          symbol="UpdateVisualStateStart"                version="0" channel="DefaultChannel" keywords="KeywordGeneral KeywordPerf"  />
            <event value="9"    level="win:Informational" task="UpdateVisualState"           opcode="win:Stop"        template="Template_0"          symbol="UpdateVisualStateEnd"                  version="0" channel="DefaultChannel" keywords="KeywordGeneral KeywordPerf"  />
            <event value="10"   level="win:Verbose"       task="WPFElementID"                opcode="ElementName"     template="PerfElementName"     symbol="PerfElementIDName"                     version="0" channel="DefaultChannel" keywords="KeywordGeneral" />
            <event value="11"   level="win:Verbose"       task="WPFElementID"                opcode="win:Info"        template="PerfElementInfo"     symbol="PerfElementIDAssignment"               version="0" channel="DefaultChannel" keywords="KeywordGeneral" />

            <event value="1001"  level="win:Informational" task="WClientFontCache"            opcode="win:Info"        template="Template_0"          symbol="WClientFontCache"                      version="2" channel="DefaultChannel" keywords="KeywordText"  />

            <event value="2001"  level="win:Informational" task="WClientInputMessage"         opcode="win:Info"        template="Template_19"         symbol="WClientInputMessage"                   version="2" channel="DefaultChannel" keywords="KeywordInput KeywordPerf" />
            <event value="2002"  level="win:Informational" task="StylusEventQueued"           opcode="win:Info"        template="ID32Template"       symbol="StylusEventQueued"                     version="0" channel="DefaultChannel" keywords="KeywordInput KeywordPerf" />
            <event value="2003"  level="win:Informational" task="TouchDownReported"           opcode="win:Info"        template="ID32Template"       symbol="TouchDownReported"                     version="0" channel="DefaultChannel" keywords="KeywordInput KeywordPerf" />
            <event value="2004"  level="win:Informational" task="TouchMoveReported"           opcode="win:Info"        template="ID32Template"       symbol="TouchMoveReported"                     version="0" channel="DefaultChannel" keywords="KeywordInput KeywordPerf" />
            <event value="2005"  level="win:Informational" task="TouchUpReported"             opcode="win:Info"        template="ID32Template"       symbol="TouchUpReported"                       version="0" channel="DefaultChannel" keywords="KeywordInput KeywordPerf" />
            <event value="2006"  level="win:Informational" task="ManipulationReportFrame"     opcode="win:Info"        template="ID32Template"       symbol="ManipulationReportFrame"               version="0" channel="DefaultChannel" keywords="KeywordInput KeywordPerf" />
            <event value="2007"  level="win:Informational" task="ManipulationEventRaised"     opcode="win:Info"        template="ID32Template"       symbol="ManipulationEventRaised"               version="0" channel="DefaultChannel" keywords="KeywordInput KeywordPerf" />

            <event value="3001"  level="win:Informational" task="CreateStickyNote"            opcode="win:Start"       template="Template_0"          symbol="CreateStickyNoteBegin"                 version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3002"  level="win:Informational" task="CreateStickyNote"            opcode="win:Stop"        template="Template_0"          symbol="CreateStickyNoteEnd"                   version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3003"  level="win:Informational" task="DeleteTextNote"              opcode="win:Start"       template="Template_0"          symbol="DeleteTextNoteBegin"                   version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3004"  level="win:Informational" task="DeleteTextNote"              opcode="win:Stop"        template="Template_0"          symbol="DeleteTextNoteEnd"                     version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3005"  level="win:Informational" task="DeleteInkNote"               opcode="win:Start"       template="Template_0"          symbol="DeleteInkNoteBegin"                    version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3006"  level="win:Informational" task="DeleteInkNote"               opcode="win:Stop"        template="Template_0"          symbol="DeleteInkNoteEnd"                      version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3007"  level="win:Informational" task="CreateHighlight"             opcode="win:Start"       template="Template_0"          symbol="CreateHighlightBegin"                  version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3008"  level="win:Informational" task="CreateHighlight"             opcode="win:Stop"        template="Template_0"          symbol="CreateHighlightEnd"                    version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3009"  level="win:Informational" task="ClearHighlight"              opcode="win:Start"       template="Template_0"          symbol="ClearHighlightBegin"                   version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3010"  level="win:Informational" task="ClearHighlight"              opcode="win:Stop"        template="Template_0"          symbol="ClearHighlightEnd"                     version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3011"  level="win:Informational" task="LoadAnnotations"             opcode="win:Start"       template="Template_0"          symbol="LoadAnnotationsBegin"                  version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3012"  level="win:Informational" task="LoadAnnotations"             opcode="win:Stop"        template="Template_0"          symbol="LoadAnnotationsEnd"                    version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3013"  level="win:Informational" task="AddAnnotation"               opcode="win:Start"       template="Template_0"          symbol="AddAnnotationBegin"                    version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3014"  level="win:Informational" task="AddAnnotation"               opcode="win:Stop"        template="Template_0"          symbol="AddAnnotationEnd"                      version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3015"  level="win:Informational" task="DeleteAnnotation"            opcode="win:Start"       template="Template_0"          symbol="DeleteAnnotationBegin"                 version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3016"  level="win:Informational" task="DeleteAnnotation"            opcode="win:Stop"        template="Template_0"          symbol="DeleteAnnotationEnd"                   version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3017"  level="win:Informational" task="GetAnnotationById"           opcode="win:Start"       template="Template_0"          symbol="GetAnnotationByIdBegin"                version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3018"  level="win:Informational" task="GetAnnotationById"           opcode="win:Stop"        template="Template_0"          symbol="GetAnnotationByIdEnd"                  version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3019"  level="win:Informational" task="GetAnnotationByLoc"          opcode="win:Start"       template="Template_0"          symbol="GetAnnotationByLocBegin"               version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3020"  level="win:Informational" task="GetAnnotationByLoc"          opcode="win:Stop"        template="Template_0"          symbol="GetAnnotationByLocEnd"                 version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3021"  level="win:Informational" task="GetAnnotations"              opcode="win:Start"       template="Template_0"          symbol="GetAnnotationsBegin"                   version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3022"  level="win:Informational" task="GetAnnotations"              opcode="win:Stop"        template="Template_0"          symbol="GetAnnotationsEnd"                     version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3023"  level="win:Informational" task="SerializeAnnotation"         opcode="win:Start"       template="Template_0"          symbol="SerializeAnnotationBegin"              version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3024"  level="win:Informational" task="SerializeAnnotation"         opcode="win:Stop"        template="Template_0"          symbol="SerializeAnnotationEnd"                version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3025"  level="win:Informational" task="DeserializeAnnotation"       opcode="win:Start"       template="Template_0"          symbol="DeserializeAnnotationBegin"            version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3026"  level="win:Informational" task="DeserializeAnnotation"       opcode="win:Stop"        template="Template_0"          symbol="DeserializeAnnotationEnd"              version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3027"  level="win:Informational" task="UpdateAnnotationWithSNC"     opcode="win:Start"       template="Template_0"          symbol="UpdateAnnotationWithSNCBegin"          version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3028"  level="win:Informational" task="UpdateAnnotationWithSNC"     opcode="win:Stop"        template="Template_0"          symbol="UpdateAnnotationWithSNCEnd"            version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3029"  level="win:Informational" task="UpdateSNCWithAnnotation"     opcode="win:Start"       template="Template_0"          symbol="UpdateSNCWithAnnotationBegin"          version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3030"  level="win:Informational" task="UpdateSNCWithAnnotation"     opcode="win:Stop"        template="Template_0"          symbol="UpdateSNCWithAnnotationEnd"            version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3031"  level="win:Informational" task="AnnotationTextChanged"       opcode="win:Start"       template="Template_0"          symbol="AnnotationTextChangedBegin"            version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3032"  level="win:Informational" task="AnnotationTextChanged"       opcode="win:Stop"        template="Template_0"          symbol="AnnotationTextChangedEnd"              version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3033"  level="win:Informational" task="AnnotationInkChanged"        opcode="win:Start"       template="Template_0"          symbol="AnnotationInkChangedBegin"             version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3034"  level="win:Informational" task="AnnotationInkChanged"        opcode="win:Stop"        template="Template_0"          symbol="AnnotationInkChangedEnd"               version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3035"  level="win:Informational" task="AddAttachedSN"               opcode="win:Start"       template="Template_0"          symbol="AddAttachedSNBegin"                    version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3036"  level="win:Informational" task="AddAttachedSN"               opcode="win:Stop"        template="Template_0"          symbol="AddAttachedSNEnd"                      version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3037"  level="win:Informational" task="RemoveAttachedSN"            opcode="win:Start"       template="Template_0"          symbol="RemoveAttachedSNBegin"                 version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3038"  level="win:Informational" task="RemoveAttachedSN"            opcode="win:Stop"        template="Template_0"          symbol="RemoveAttachedSNEnd"                   version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3039"  level="win:Informational" task="AddAttachedHighlight"        opcode="win:Start"       template="Template_0"          symbol="AddAttachedHighlightBegin"             version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3040"  level="win:Informational" task="AddAttachedHighlight"        opcode="win:Stop"        template="Template_0"          symbol="AddAttachedHighlightEnd"               version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3041"  level="win:Informational" task="RemoveAttachedHighlight"     opcode="win:Start"       template="Template_0"          symbol="RemoveAttachedHighlightBegin"          version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3042"  level="win:Informational" task="RemoveAttachedHighlight"     opcode="win:Stop"        template="Template_0"          symbol="RemoveAttachedHighlightEnd"            version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3043"  level="win:Informational" task="AddAttachedMH"               opcode="win:Start"       template="Template_0"          symbol="AddAttachedMHBegin"                    version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3044"  level="win:Informational" task="AddAttachedMH"               opcode="win:Stop"        template="Template_0"          symbol="AddAttachedMHEnd"                      version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3045"  level="win:Informational" task="RemoveAttachedMH"            opcode="win:Start"       template="Template_0"          symbol="RemoveAttachedMHBegin"                 version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />
            <event value="3046"  level="win:Informational" task="RemoveAttachedMH"            opcode="win:Stop"        template="Template_0"          symbol="RemoveAttachedMHEnd"                   version="2" channel="DefaultChannel" keywords="KeywordAnnotation"  />

            <event value="4001"  level="win:Informational" task="WClientParseBaml"            opcode="win:Start"       template="URITemplate"         symbol="WClientParseBamlBegin"                 version="2" channel="DefaultChannel" keywords="KeywordXamlBaml KeywordPerf"  />
            <event value="4002"  level="win:Informational" task="WClientParseBaml"            opcode="win:Stop"        template="URITemplate"         symbol="WClientParseBamlEnd"                   version="2" channel="DefaultChannel" keywords="KeywordXamlBaml KeywordPerf"  />
            <event value="4003"  level="win:Informational" task="WClientParseXml"             opcode="win:Start"       template="URITemplate"         symbol="WClientParseXmlBegin"                  version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4004"  level="win:Informational" task="WClientParseXml"             opcode="win:Stop"        template="URITemplate"         symbol="WClientParseXmlEnd"                    version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4005"  level="win:Verbose"       task="WClientParseFefCrInst"       opcode="win:Start"       template="Template_0"          symbol="WClientParseFefCrInstBegin"            version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4006"  level="win:Verbose"       task="WClientParseFefCrInst"       opcode="win:Stop"        template="Template_0"          symbol="WClientParseFefCrInstEnd"              version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4007"  level="win:Verbose"       task="WClientParseInstVisTree"     opcode="win:Start"       template="Template_0"          symbol="WClientParseInstVisTreeBegin"          version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4008"  level="win:Verbose"       task="WClientParseInstVisTree"     opcode="win:Stop"        template="MessageStringTemplate" symbol="WClientParseInstVisTreeEnd"          version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4009"  level="win:Verbose"       task="WClientParseRdrCrInst"       opcode="win:Start"       template="Template_0"          symbol="WClientParseRdrCrInstBegin"            version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4010"  level="win:Verbose"       task="WClientParseRdrCrInst"       opcode="win:Stop"        template="Template_0"          symbol="WClientParseRdrCrInstEnd"              version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4011"  level="win:Informational" task="WClientParseRdrCrInFTyp"     opcode="win:Start"       template="Template_0"          symbol="WClientParseRdrCrInFTypBegin"          version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4012"  level="win:Informational" task="WClientParseRdrCrInFTyp"     opcode="win:Stop"        template="TypeStringTemplate"  symbol="WClientParseRdrCrInFTypEnd"            version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4013"  level="win:Informational" task="WClientResourceFind"         opcode="win:Start"       template="KeyStringTemplate"   symbol="WClientResourceFindBegin"              version="2" channel="DefaultChannel" keywords="KeywordXamlBaml KeywordPerf"  />
            <event value="4014"  level="win:Informational" task="WClientResourceFind"         opcode="win:Stop"        template="Template_0"          symbol="WClientResourceFindEnd"                version="2" channel="DefaultChannel" keywords="KeywordXamlBaml KeywordPerf"  />
            <event value="4015"  level="win:Informational" task="WClientResourceCacheValue"   opcode="win:Info"        template="Template_0"          symbol="WClientResourceCacheValue"             version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4016"  level="win:Informational" task="WClientResourceCacheNull"    opcode="win:Info"        template="Template_0"          symbol="WClientResourceCacheNull"              version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4017"  level="win:Informational" task="WClientResourceCacheMiss"    opcode="win:Info"        template="Template_0"          symbol="WClientResourceCacheMiss"              version="2" channel="DefaultChannel" keywords="KeywordXamlBaml KeywordPerf"  />
            <event value="4018"  level="win:Informational" task="WClientResourceStock"        opcode="win:Info"        template="KeyStringTemplate"   symbol="WClientResourceStock"                  version="2" channel="DefaultChannel" keywords="KeywordXamlBaml KeywordPerf"  />
            <event value="4019"  level="win:Informational" task="WClientResourceBamlAssembly" opcode="win:Info"        template="AssemblyNameTemplate" symbol="WClientResourceBamlAssembly"          version="2" channel="DefaultChannel" keywords="KeywordXamlBaml"  />
            <event value="4020"  level="win:Informational" task="WClientParseXaml"            opcode="win:Start"       template="URITemplate"         symbol="WClientParseXamlBegin"                 version="0" channel="DefaultChannel" keywords="KeywordXamlBaml" />
            <event value="4021"  level="win:Verbose"       task="WClientParseXamlBamlInfo"    opcode="win:Info"        template="WClientParseXamlBamlInfoTemplate" symbol="WClientParseXamlBamlInfo" version="0" channel="DefaultChannel" keywords="KeywordXamlBaml" />
            <event value="4022"  level="win:Informational" task="WClientParseXaml"            opcode="win:Stop"        template="URITemplate"         symbol="WClientParseXamlEnd"                   version="0" channel="DefaultChannel" keywords="KeywordXamlBaml" />

            <event value="5001"  level="win:Informational" task="WClientDRXFlushPage"         opcode="win:Start"       template="Template_0"          symbol="WClientDRXFlushPageStart"              version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5002"  level="win:Informational" task="WClientDRXFlushPage"         opcode="win:Stop"        template="Template_0"          symbol="WClientDRXFlushPageStop"               version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5003"  level="win:Informational" task="WClientDRXSerializeTree"     opcode="win:Start"       template="Template_0"          symbol="WClientDRXSerializeTreeStart"          version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5004"  level="win:Informational" task="WClientDRXSerializeTree"     opcode="win:Stop"        template="Template_0"          symbol="WClientDRXSerializeTreeEnd"            version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5005"  level="win:Informational" task="WClientDRXGetVisual"         opcode="win:Start"       template="Template_0"          symbol="WClientDRXGetVisualStart"              version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5006"  level="win:Informational" task="WClientDRXGetVisual"         opcode="win:Stop"        template="Template_0"          symbol="WClientDRXGetVisualEnd"                version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5007"  level="win:Informational" task="WClientDRXReleaseWriter"     opcode="win:Start"       template="Template_0"          symbol="WClientDRXReleaseWriterStart"          version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5008"  level="win:Informational" task="WClientDRXReleaseWriter"     opcode="win:Stop"        template="Template_0"          symbol="WClientDRXReleaseWriterEnd"            version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5009"  level="win:Informational" task="WClientDRXGetPrintCap"       opcode="win:Start"       template="Template_0"          symbol="WClientDRXGetPrintCapStart"            version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5010"  level="win:Informational" task="WClientDRXGetPrintCap"       opcode="win:Stop"        template="Template_0"          symbol="WClientDRXGetPrintCapEnd"              version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5011"  level="win:Informational" task="WClientDRXPTProvider"        opcode="win:Start"       template="Template_0"          symbol="WClientDRXPTProviderStart"             version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5012"  level="win:Informational" task="WClientDRXPTProvider"        opcode="win:Stop"        template="Template_0"          symbol="WClientDRXPTProviderEnd"               version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5013"  level="win:Informational" task="WClientDRXRaster"            opcode="win:Start"       template="Template_0"          symbol="WClientDRXRasterStart"                 version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5014"  level="win:Informational" task="WClientDRXRaster"            opcode="win:Stop"        template="Template_0"          symbol="WClientDRXRasterEnd"                   version="0" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5015"  level="win:Informational" task="WClientDRXOpenPackage"       opcode="win:Start"       template="Template_0"          symbol="WClientDRXOpenPackageBegin"            version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5016"  level="win:Informational" task="WClientDRXOpenPackage"       opcode="win:Stop"        template="Template_0"          symbol="WClientDRXOpenPackageEnd"              version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5017"  level="win:Informational" task="WClientDRXGetStream"         opcode="win:Start"       template="Template_0"          symbol="WClientDRXGetStreamBegin"              version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5018"  level="win:Informational" task="WClientDRXGetStream"         opcode="win:Stop"        template="Template_0"          symbol="WClientDRXGetStreamEnd"                version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5019"  level="win:Informational" task="WClientDRXPageVisible"       opcode="win:Info"        template="Template_31"         symbol="WClientDRXPageVisible"                 version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5020"  level="win:Informational" task="WClientDRXPageLoaded"        opcode="win:Info"        template="Template_32"         symbol="WClientDRXPageLoaded"                  version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5021"  level="win:Informational" task="WClientDRXInvalidateView"    opcode="win:Info"        template="Template_0"          symbol="WClientDRXInvalidateView"              version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5022"  level="win:Informational" task="WClientDRXStyleCreated"      opcode="win:Info"        template="Template_0"          symbol="WClientDRXStyleCreated"                version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5023"  level="win:Informational" task="WClientDRXFind"              opcode="win:Start"       template="Template_0"          symbol="WClientDRXFindBegin"                   version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5024"  level="win:Informational" task="WClientDRXFind"              opcode="win:Stop"        template="Template_0"          symbol="WClientDRXFindEnd"                     version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5025"  level="win:Informational" task="WClientDRXZoom"              opcode="win:Info"        template="Template_35"         symbol="WClientDRXZoom"                        version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5026"  level="win:Informational" task="WClientDRXEnsureOM"          opcode="win:Start"       template="Template_0"          symbol="WClientDRXEnsureOMBegin"               version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5027"  level="win:Informational" task="WClientDRXEnsureOM"          opcode="win:Stop"        template="Template_0"          symbol="WClientDRXEnsureOMEnd"                 version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5028"  level="win:Informational" task="WClientDRXTreeFlatten"       opcode="win:Start"       template="Template_0"          symbol="WClientDRXTreeFlattenBegin"            version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5029"  level="win:Informational" task="WClientDRXTreeFlatten"       opcode="win:Stop"        template="Template_0"          symbol="WClientDRXTreeFlattenEnd"              version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5030"  level="win:Informational" task="WClientDRXAlphaFlatten"      opcode="win:Start"       template="Template_0"          symbol="WClientDRXAlphaFlattenBegin"           version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5031"  level="win:Informational" task="WClientDRXAlphaFlatten"      opcode="win:Stop"        template="Template_0"          symbol="WClientDRXAlphaFlattenEnd"             version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5032"  level="win:Informational" task="WClientDRXGetDevMode"        opcode="win:Start"       template="Template_0"          symbol="WClientDRXGetDevModeBegin"             version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5033"  level="win:Informational" task="WClientDRXGetDevMode"        opcode="win:Stop"        template="Template_0"          symbol="WClientDRXGetDevModeEnd"               version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5034"  level="win:Informational" task="WClientDRXStartDoc"          opcode="win:Start"       template="Template_0"          symbol="WClientDRXStartDocBegin"               version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5035"  level="win:Informational" task="WClientDRXStartDoc"          opcode="win:Stop"        template="Template_0"          symbol="WClientDRXStartDocEnd"                 version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5036"  level="win:Informational" task="WClientDRXEndDoc"            opcode="win:Start"       template="Template_0"          symbol="WClientDRXEndDocBegin"                 version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5037"  level="win:Informational" task="WClientDRXEndDoc"            opcode="win:Stop"        template="Template_0"          symbol="WClientDRXEndDocEnd"                   version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5038"  level="win:Informational" task="WClientDRXStartPage"         opcode="win:Start"       template="Template_0"          symbol="WClientDRXStartPageBegin"              version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5039"  level="win:Informational" task="WClientDRXStartPage"         opcode="win:Stop"        template="Template_0"          symbol="WClientDRXStartPageEnd"                version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5040"  level="win:Informational" task="WClientDRXEndPage"           opcode="win:Start"       template="Template_0"          symbol="WClientDRXEndPageBegin"                version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5041"  level="win:Informational" task="WClientDRXEndPage"           opcode="win:Stop"        template="Template_0"          symbol="WClientDRXEndPageEnd"                  version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5042"  level="win:Informational" task="WClientDRXCommitPage"        opcode="win:Start"       template="Template_0"          symbol="WClientDRXCommitPageBegin"             version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5043"  level="win:Informational" task="WClientDRXCommitPage"        opcode="win:Stop"        template="Template_0"          symbol="WClientDRXCommitPageEnd"               version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5044"  level="win:Informational" task="WClientDRXConvertFont"       opcode="win:Start"       template="Template_0"          symbol="WClientDRXConvertFontBegin"            version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5045"  level="win:Informational" task="WClientDRXConvertFont"       opcode="win:Stop"        template="Template_0"          symbol="WClientDRXConvertFontEnd"              version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5046"  level="win:Informational" task="WClientDRXConvertImage"      opcode="win:Start"       template="Template_0"          symbol="WClientDRXConvertImageBegin"           version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5047"  level="win:Informational" task="WClientDRXConvertImage"      opcode="win:Stop"        template="Template_0"          symbol="WClientDRXConvertImageEnd"             version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5048"  level="win:Informational" task="WClientDRXSaveXps"           opcode="win:Start"       template="Template_0"          symbol="WClientDRXSaveXpsBegin"                version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5049"  level="win:Informational" task="WClientDRXSaveXps"           opcode="win:Stop"        template="Template_0"          symbol="WClientDRXSaveXpsEnd"                  version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5050"  level="win:Informational" task="WClientDRXLoadPrimitive"     opcode="win:Start"       template="Template_0"          symbol="WClientDRXLoadPrimitiveBegin"          version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5051"  level="win:Informational" task="WClientDRXLoadPrimitive"     opcode="win:Stop"        template="Template_0"          symbol="WClientDRXLoadPrimitiveEnd"            version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5052"  level="win:Informational" task="WClientDRXSavePage"          opcode="win:Start"       template="Template_0"          symbol="WClientDRXSavePageBegin"               version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5053"  level="win:Informational" task="WClientDRXSavePage"          opcode="win:Stop"        template="Template_0"          symbol="WClientDRXSavePageEnd"                 version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5054"  level="win:Informational" task="WClientDRXSerialization"     opcode="win:Start"       template="Template_0"          symbol="WClientDRXSerializationBegin"          version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5055"  level="win:Informational" task="WClientDRXSerialization"     opcode="win:Stop"        template="Template_0"          symbol="WClientDRXSerializationEnd"            version="2" channel="DefaultChannel" keywords="KeywordXPS"  />            
            <event value="5056"  level="win:Verbose"       task="WClientDRXReadStream"        opcode="win:Start"       template="Counter"             symbol="WClientDRXReadStreamBegin"             version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5057"  level="win:Verbose"       task="WClientDRXReadStream"        opcode="win:Stop"        template="Template_30"         symbol="WClientDRXReadStreamEnd"               version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5058"  level="win:Informational" task="WClientDRXGetPage"           opcode="win:Start"       template="Template_0"          symbol="WClientDRXGetPageBegin"                version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5059"  level="win:Informational" task="WClientDRXGetPage"           opcode="win:Stop"        template="Template_0"          symbol="WClientDRXGetPageEnd"                  version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5060"  level="win:Informational" task="WClientDRXLineDown"          opcode="win:Info"        template="Template_33"         symbol="WClientDRXLineDown"                    version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5061"  level="win:Informational" task="WClientDRXPageDown"          opcode="win:Info"        template="Template_33"         symbol="WClientDRXPageDown"                    version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5062"  level="win:Informational" task="WClientDRXPageJump"          opcode="win:Info"        template="Template_34"         symbol="WClientDRXPageJump"                    version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5063"  level="win:Informational" task="WClientDRXLayout"            opcode="win:Start"       template="Template_0"          symbol="WClientDRXLayoutBegin"                 version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5064"  level="win:Informational" task="WClientDRXLayout"            opcode="win:Stop"        template="Template_0"          symbol="WClientDRXLayoutEnd"                   version="2" channel="DefaultChannel" keywords="KeywordXPS"  />
            <event value="5065"  level="win:Informational" task="WClientDRXInstantiated"      opcode="win:Info"        template="Template_0"          symbol="WClientDRXInstantiated"                version="2" channel="DefaultChannel" keywords="KeywordXPS"  />            

            <event value="6001"  level="win:Informational" task="WClientTimeManagerTick"      opcode="win:Start"       template="TimeTick"            symbol="WClientTimeManagerTickBegin"            version="2" channel="DefaultChannel" keywords="KeywordAnimation KeywordPerf"  />
            <event value="6002"  level="win:Informational" task="WClientTimeManagerTick"      opcode="win:Stop"        template="Template_0"          symbol="WClientTimeManagerTickEnd"             version="2" channel="DefaultChannel" keywords="KeywordAnimation KeywordPerf"  />

            <event value="7001"  level="win:Informational" task="WClientLayout"               opcode="win:Start"                 template="LayoutSourceTemplate" symbol="WClientLayoutBegin"                 version="3" channel="DefaultChannel" keywords="KeywordLayout KeywordPerf"  />
            <event value="7002"  level="win:Informational" task="WClientLayout"               opcode="win:Stop"                  template="Template_0"           symbol="WClientLayoutEnd"                   version="2" channel="DefaultChannel" keywords="KeywordLayout KeywordPerf"  />
            <event value="7005"  level="win:Informational" task="WClientMeasure"              opcode="win:Start"                 template="PerfElementID"        symbol="WClientMeasureBegin"                version="2" channel="DefaultChannel" keywords="KeywordLayout KeywordPerf"  />
            <event value="7006"  level="win:Informational" task="WClientMeasure"              opcode="MeasureAbort"              template="LayoutAborted"        symbol="WClientMeasureAbort"                version="0" channel="DefaultChannel" keywords="KeywordLayout KeywordPerf"  />
            <event value="7007"  level="win:Informational" task="WClientMeasure"              opcode="win:Stop"                  template="Counter"              symbol="WClientMeasureEnd"                  version="2" channel="DefaultChannel" keywords="KeywordLayout KeywordPerf"  />
            <event value="7008"  level="win:Verbose"       task="WClientMeasure"              opcode="MeasureElementBegin"       template="MeasureData"          symbol="WClientMeasureElementBegin"         version="0" channel="DefaultChannel" keywords="KeywordLayout" />
            <event value="7009"  level="win:Verbose"       task="WClientMeasure"              opcode="MeasureElementEnd"         template="MeasureData"          symbol="WClientMeasureElementEnd"           version="0" channel="DefaultChannel" keywords="KeywordLayout" />
            <event value="7010"  level="win:Informational" task="WClientArrange"              opcode="win:Start"                 template="PerfElementID"        symbol="WClientArrangeBegin"                version="2" channel="DefaultChannel" keywords="KeywordLayout KeywordPerf"  />
            <event value="7011"  level="win:Informational" task="WClientArrange"              opcode="ArrangeAbort"              template="LayoutAborted"        symbol="WClientArrangeAbort"                version="2" channel="DefaultChannel" keywords="KeywordLayout KeywordPerf"  />
            <event value="7012"  level="win:Informational" task="WClientArrange"              opcode="win:Stop"                  template="Counter"              symbol="WClientArrangeEnd"                  version="2" channel="DefaultChannel" keywords="KeywordLayout KeywordPerf"  />
            <event value="7013"  level="win:Verbose"       task="WClientArrange"              opcode="ArrangeElementBegin"       template="ArrangeData"          symbol="WClientArrangeElementBegin"         version="0" channel="DefaultChannel" keywords="KeywordLayout" />
            <event value="7014"  level="win:Verbose"       task="WClientArrange"              opcode="ArrangeElementEnd"         template="ArrangeData"          symbol="WClientArrangeElementEnd"           version="0" channel="DefaultChannel" keywords="KeywordLayout" />
            <event value="7015"  level="win:Informational" task="WClientLayout"               opcode="Abort"                     template="LayoutAborted"        symbol="WClientLayoutAbort"                     version="0" channel="DefaultChannel" keywords="KeywordLayout KeywordPerf" />
            <event value="7016"  level="win:Verbose"       task="WClientLayout"               opcode="FireSizeChangedBegin"      template="Template_0"           symbol="WClientLayoutFireSizeChangedBegin"      version="0" channel="DefaultChannel" keywords="KeywordLayout" />
            <event value="7017"  level="win:Verbose"       task="WClientLayout"               opcode="FireSizeChangedEnd"        template="Template_0"           symbol="WClientLayoutFireSizeChangedEnd"        version="0" channel="DefaultChannel" keywords="KeywordLayout" />
            <event value="7018"  level="win:Verbose"       task="WClientLayout"               opcode="FireLayoutUpdatedBegin"    template="Template_0"           symbol="WClientLayoutFireLayoutUpdatedBegin"    version="0" channel="DefaultChannel" keywords="KeywordLayout" />
            <event value="7019"  level="win:Verbose"       task="WClientLayout"               opcode="FireLayoutUpdatedEnd"      template="Template_0"           symbol="WClientLayoutFireLayoutUpdatedEnd"      version="0" channel="DefaultChannel" keywords="KeywordLayout" />
            <event value="7020"  level="win:Verbose"       task="WClientLayout"               opcode="FireAutomationEventsBegin" template="Template_0"           symbol="WClientLayoutFireAutomationEventsBegin" version="0" channel="DefaultChannel" keywords="KeywordLayout" />
            <event value="7021"  level="win:Verbose"       task="WClientLayout"               opcode="FireAutomationEventsEnd"   template="Template_0"           symbol="WClientLayoutFireAutomationEventsEnd"   version="0" channel="DefaultChannel" keywords="KeywordLayout" />
            <event value="7022"  level="win:Informational" task="WClientLayout"               opcode="Exception"                 template="PerfElementID"        symbol="WClientLayoutException"                 version="0" channel="DefaultChannel" keywords="KeywordLayout KeywordPerf" />
            <event value="7023"  level="win:Verbose"       task="WClientLayout"               opcode="Invalidated"               template="PerfElementID"        symbol="WClientLayoutInvalidated"               version="0" channel="DefaultChannel" keywords="KeywordLayout" />

            <event value="9003"  level="win:Informational" task="WpfHostUm"                  opcode="WinMainStart"               template="Template_0"          symbol="WpfHostUm_WinMainStart"                version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9004"  level="win:Informational" task="WpfHostUm"                  opcode="WinMainEnd"                 template="Template_HR"         symbol="WpfHostUm_WinMainEnd"                  version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9005"  level="win:Informational" task="WpfHostUm"                  opcode="InvokingBrowser"            template="Template_43"         symbol="WpfHostUm_InvokingBrowser"             version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9006"  level="win:Informational" task="WpfHostUm"                  opcode="LaunchingRestrictedProcess" template="Template_0"          symbol="WpfHostUm_LaunchingRestrictedProcess"  version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9007"  level="win:Informational" task="WpfHostUm"                  opcode="EnteringMessageLoop"        template="Template_0"          symbol="WpfHostUm_EnteringMessageLoop"         version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9008"  level="win:Informational" task="WpfHostUm"                  opcode="ClassFactoryCreateInstance" template="Template_0"          symbol="WpfHostUm_ClassFactoryCreateInstance"  version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9009"  level="win:Informational" task="WpfHostUm"                  opcode="ReadingDeplManifestStart"   template="Template_43"         symbol="WpfHostUm_ReadingDeplManifestStart"    version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9010"  level="win:Informational" task="WpfHostUm"                  opcode="ReadingDeplManifestEnd"     template="Template_43"         symbol="WpfHostUm_ReadingDeplManifestEnd"      version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9011"  level="win:Informational" task="WpfHostUm"                  opcode="ReadingAppManifestStart"    template="Template_43"         symbol="WpfHostUm_ReadingAppManifestStart"     version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9012"  level="win:Informational" task="WpfHostUm"                  opcode="ReadingAppManifestEnd"      template="Template_0"          symbol="WpfHostUm_ReadingAppManifestEnd"       version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9013"  level="win:Informational" task="WpfHostUm"                  opcode="ParsingMarkupVersionStart"  template="Template_0"          symbol="WpfHostUm_ParsingMarkupVersionStart"   version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9014"  level="win:Informational" task="WpfHostUm"                  opcode="ParsingMarkupVersionEnd"    template="Template_0"          symbol="WpfHostUm_ParsingMarkupVersionEnd"     version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9015"  level="win:Informational" task="WpfHostUm"                  opcode="IPersistFileLoad"           template="Template_43"         symbol="WpfHostUm_IPersistFileLoad"            version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9016"  level="win:Informational" task="WpfHostUm"                  opcode="IPersistMonikerLoadStart"   template="Template_0"          symbol="WpfHostUm_IPersistMonikerLoadStart"    version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9017"  level="win:Informational" task="WpfHostUm"                  opcode="IPersistMonikerLoadEnd"     template="Template_HR"         symbol="WpfHostUm_IPersistMonikerLoadEnd"      version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9018"  level="win:Informational" task="WpfHostUm"                  opcode="BindProgress"               template="Template_44"         symbol="WpfHostUm_BindProgress"                version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9019"  level="win:Informational" task="WpfHostUm"                  opcode="OnStopBinding"              template="Template_HR"         symbol="WpfHostUm_OnStopBinding"               version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9020"  level="win:Informational" task="WpfHostUm"                  opcode="VersionAttach"              template="Template_0"          symbol="WpfHostUm_VersionAttach"               version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9021"  level="win:Informational" task="WpfHostUm"                  opcode="VersionActivateStart"       template="Template_0"          symbol="WpfHostUm_VersionActivateStart"        version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9022"  level="win:Informational" task="WpfHostUm"                  opcode="VersionActivateEnd"         template="Template_0"          symbol="WpfHostUm_VersionActivateEnd"          version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9023"  level="win:Informational" task="WpfHostUm"                  opcode="StartingCLRStart"           template="Template_0"          symbol="WpfHostUm_StartingCLRStart"            version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9024"  level="win:Informational" task="WpfHostUm"                  opcode="StartingCLREnd"             template="Template_0"          symbol="WpfHostUm_StartingCLREnd"              version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9025"  level="win:Informational" task="WpfHostUm"                  opcode="IHlinkTargetNavigateStart"  template="Template_45"         symbol="WpfHostUm_IHlinkTargetNavigateStart"   version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9026"  level="win:Informational" task="WpfHostUm"                  opcode="IHlinkTargetNavigateEnd"    template="Template_0"          symbol="WpfHostUm_IHlinkTargetNavigateEnd"     version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9027"  level="win:Informational" task="WpfHostUm"                  opcode="ReadyStateChanged"          template="Template_46"         symbol="WpfHostUm_ReadyStateChanged"           version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9028"  level="win:Informational" task="WpfHostUm"                  opcode="InitDocHostStart"           template="Template_0"          symbol="WpfHostUm_InitDocHostStart"            version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9029"  level="win:Informational" task="WpfHostUm"                  opcode="InitDocHostEnd"             template="Template_0"          symbol="WpfHostUm_InitDocHostEnd"              version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9030"  level="win:Informational" task="WpfHostUm"                  opcode="MergingMenusStart"          template="Template_0"          symbol="WpfHostUm_MergingMenusStart"           version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9031"  level="win:Informational" task="WpfHostUm"                  opcode="MergingMenusEnd"            template="Template_0"          symbol="WpfHostUm_MergingMenusEnd"             version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9032"  level="win:Informational" task="WpfHostUm"                  opcode="UIActivationStart"          template="Template_0"          symbol="WpfHostUm_UIActivationStart"           version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9033"  level="win:Informational" task="WpfHostUm"                  opcode="UIActivationEnd"            template="Template_0"          symbol="WpfHostUm_UIActivationEnd"             version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9034"  level="win:Verbose"       task="WpfHostUm"                  opcode="LoadingResourceDLLStart"    template="Template_0"          symbol="WpfHostUm_LoadingResourceDLLStart"     version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9035"  level="win:Verbose"       task="WpfHostUm"                  opcode="LoadingResourceDLLEnd"      template="Template_43"         symbol="WpfHostUm_LoadingResourceDLLEnd"       version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9036"  level="win:Informational" task="WpfHostUm"                  opcode="OleCmdQueryStatusStart"     template="Template_47"         symbol="WpfHostUm_OleCmdQueryStatusStart"      version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9037"  level="win:Informational" task="WpfHostUm"                  opcode="OleCmdQueryStatusEnd"       template="Template_48"         symbol="WpfHostUm_OleCmdQueryStatusEnd"        version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9038"  level="win:Informational" task="WpfHostUm"                  opcode="OleCmdExecStart"            template="Template_47"         symbol="WpfHostUm_OleCmdExecStart"             version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9039"  level="win:Informational" task="WpfHostUm"                  opcode="OleCmdExecEnd"              template="Template_HR"         symbol="WpfHostUm_OleCmdExecEnd"               version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9040"  level="win:Informational" task="WpfHostUm"                  opcode="ProgressPageShown"          template="Template_0"          symbol="WpfHostUm_ProgressPageShown"           version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9041"  level="win:Informational" task="WpfHostUm"                  opcode="AdHocProfile1Start"         template="Template_0"          symbol="WpfHostUm_AdHocProfile1Start"          version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9042"  level="win:Informational" task="WpfHostUm"                  opcode="AdHocProfile1End"           template="Template_0"          symbol="WpfHostUm_AdHocProfile1End"            version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9043"  level="win:Informational" task="WpfHostUm"                  opcode="AdHocProfile2Start"         template="Template_45"         symbol="WpfHostUm_AdHocProfile2Start"          version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9044"  level="win:Informational" task="WpfHostUm"                  opcode="AdHocProfile2End"           template="Template_0"          symbol="WpfHostUm_AdHocProfile2End"            version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9045"  level="win:Informational" task="WpfHost"                    opcode="DocObjHostCreated"          template="Template_0"          symbol="WpfHost_DocObjHostCreated"             version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9046"  level="win:Verbose"       task="WpfHost"                    opcode="XappLauncherAppStartup"     template="Template_0"          symbol="WpfHost_XappLauncherAppStartup"        version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9047"  level="win:Verbose"       task="WpfHost"                    opcode="XappLauncherAppExit"        template="Template_53"         symbol="WpfHost_XappLauncherAppExit"           version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9048"  level="win:Verbose"       task="WpfHost"                    opcode="DocObjHostRunApplicationStart" template="Template_0"       symbol="WpfHost_DocObjHostRunApplicationStart" version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9049"  level="win:Verbose"       task="WpfHost"                    opcode="DocObjHostRunApplicationEnd" template="Template_0"         symbol="WpfHost_DocObjHostRunApplicationEnd"   version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9050"  level="win:Verbose"       task="WpfHost"                    opcode="ClickOnceActivationStart"   template="Template_51"         symbol="WpfHost_ClickOnceActivationStart"      version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9051"  level="win:Informational" task="WpfHost"                    opcode="ClickOnceActivationEnd"     template="Template_0"          symbol="WpfHost_ClickOnceActivationEnd"        version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9052"  level="win:Informational" task="WpfHost"                    opcode="InitAppProxyStart"          template="Template_0"          symbol="WpfHost_InitAppProxyStart"             version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9053"  level="win:Informational" task="WpfHost"                    opcode="InitAppProxyEnd"            template="Template_0"          symbol="WpfHost_InitAppProxyEnd"               version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9054"  level="win:Verbose"       task="WpfHost"                    opcode="AppProxyCtor"               template="Template_0"          symbol="WpfHost_AppProxyCtor"                  version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9055"  level="win:Informational" task="WpfHost"                    opcode="RootBrowserWindowSetupStart" template="Template_0"         symbol="WpfHost_RootBrowserWindowSetupStart"   version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9056"  level="win:Informational" task="WpfHost"                    opcode="RootBrowserWindowSetupEnd"  template="Template_0"          symbol="WpfHost_RootBrowserWindowSetupEnd"     version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9057"  level="win:Verbose"       task="WpfHost"                    opcode="AppProxyRunStart"           template="Template_0"          symbol="WpfHost_AppProxyRunStart"              version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9058"  level="win:Verbose"       task="WpfHost"                    opcode="AppProxyRunEnd"             template="Template_0"          symbol="WpfHost_AppProxyRunEnd"                version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9059"  level="win:Verbose"       task="WpfHost"                    opcode="AppDomainManagerCctor"      template="Template_0"          symbol="WpfHost_AppDomainManagerCctor"         version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9060"  level="win:Verbose"       task="WpfHost"                    opcode="ApplicationActivatorCreateInstanceStart" template="URITemplate" symbol="WpfHost_ApplicationActivatorCreateInstanceStart" version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9061"  level="win:Verbose"       task="WpfHost"                    opcode="ApplicationActivatorCreateInstanceEnd" template="Template_0" symbol="WpfHost_ApplicationActivatorCreateInstanceEnd" version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9062"  level="win:Verbose"       task="WpfHost"                    opcode="DetermineApplicationTrustStart" template="Template_0"      symbol="WpfHost_DetermineApplicationTrustStart" version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9063"  level="win:Verbose"       task="WpfHost"                    opcode="DetermineApplicationTrustEnd" template="Template_0"        symbol="WpfHost_DetermineApplicationTrustEnd"  version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9064"  level="win:Informational" task="WpfHost"                    opcode="FirstTimeActivation"        template="Template_0"          symbol="WpfHost_FirstTimeActivation"           version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9065"  level="win:Verbose"       task="WpfHost"                    opcode="GetDownloadPageStart"       template="Template_54"         symbol="WpfHost_GetDownloadPageStart"          version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9066"  level="win:Verbose"       task="WpfHost"                    opcode="GetDownloadPageEnd"         template="Template_0"          symbol="WpfHost_GetDownloadPageEnd"            version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9067"  level="win:Informational" task="WpfHost"                    opcode="DownloadDeplManifestStart"  template="Template_0"          symbol="WpfHost_DownloadDeplManifestStart"     version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9068"  level="win:Informational" task="WpfHost"                    opcode="DownloadDeplManifestEnd"    template="Template_0"          symbol="WpfHost_DownloadDeplManifestEnd"       version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9069"  level="win:Verbose"       task="WpfHost"                    opcode="AssertAppRequirementsStart" template="Template_0"          symbol="WpfHost_AssertAppRequirementsStart"    version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9070"  level="win:Verbose"       task="WpfHost"                    opcode="AssertAppRequirementsEnd"   template="Template_0"          symbol="WpfHost_AssertAppRequirementsEnd"      version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9071"  level="win:Informational" task="WpfHost"                    opcode="DownloadApplicationStart"   template="Template_0"          symbol="WpfHost_DownloadApplicationStart"      version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9072"  level="win:Informational" task="WpfHost"                    opcode="DownloadApplicationEnd"     template="Template_0"          symbol="WpfHost_DownloadApplicationEnd"        version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9073"  level="win:Verbose"       task="WpfHost"                    opcode="DownloadProgressUpdate"     template="Template_55"         symbol="WpfHost_DownloadProgressUpdate"        version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9074"  level="win:Verbose"       task="WpfHost"                    opcode="XappLauncherAppNavigated"   template="Template_0"          symbol="WpfHost_XappLauncherAppNavigated"      version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9075"  level="win:Informational" task="WpfHost"                    opcode="StartingFontCacheServiceStart" template="Template_0"       symbol="WpfHost_StartingFontCacheServiceStart" version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9076"  level="win:Informational" task="WpfHost"                    opcode="StartingFontCacheServiceEnd" template="Template_0"         symbol="WpfHost_StartingFontCacheServiceEnd"   version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9077"  level="win:Verbose"       task="WpfHost"                    opcode="UpdateBrowserCommandsStart" template="Template_0"          symbol="WpfHost_UpdateBrowserCommandsStart"    version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9078"  level="win:Verbose"       task="WpfHost"                    opcode="UpdateBrowserCommandsEnd"   template="Template_0"          symbol="WpfHost_UpdateBrowserCommandsEnd"      version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9079"  level="win:Informational" task="WpfHost"                    opcode="PostShutdown"               template="Template_0"          symbol="WpfHost_PostShutdown"                  version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9080"  level="win:Informational" task="WpfHost"                    opcode="AbortingActivation"         template="Template_0"          symbol="WpfHost_AbortingActivation"            version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9081"  level="win:Informational" task="WpfHost"                    opcode="IBHSRunStart"               template="Template_49"         symbol="WpfHost_IBHSRunStart"                  version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9082"  level="win:Informational" task="WpfHost"                    opcode="IBHSRunEnd"                 template="Template_50"         symbol="WpfHost_IBHSRunEnd"                    version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9083"  level="win:Informational" task="Navigation"                  opcode="NavigationAsyncWorkItem"      template="Template_0"        symbol="Wpf_NavigationAsyncWorkItem"           version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9084"  level="win:Informational" task="Navigation"                  opcode="NavigationWebResponseReceived" template="Template_0"       symbol="Wpf_NavigationWebResponseReceived"     version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9085"  level="win:Informational" task="Navigation"                  opcode="NavigationEnd"                template="Template_0"        symbol="Wpf_NavigationEnd"                     version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9086"  level="win:Informational" task="Navigation"                  opcode="NavigationContentRendered"    template="Template_0"        symbol="Wpf_NavigationContentRendered"         version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9087"  level="win:Informational" task="Navigation"                  opcode="NavigationStart"              template="Template_56"       symbol="Wpf_NavigationStart"                   version="2" channel="DefaultChannel" keywords="KeywordHosting KeywordPerf"  />
            <event value="9088"  level="win:Informational" task="Navigation"                  opcode="NavigationLaunchBrowser"      template="URITemplate"       symbol="Wpf_NavigationLaunchBrowser"           version="2" channel="DefaultChannel" keywords="KeywordHosting"  />
            <event value="9089"  level="win:Informational" task="Navigation"                  opcode="NavigationPageFunctionReturn" template="Template_57"       symbol="Wpf_NavigationPageFunctionReturn"      version="2" channel="DefaultChannel" keywords="KeywordHosting"  />

            <!-- KeywordHeapMeter - Disabled for now
            <event value="10001" level="Performance_LowImpact" task="WpfGraphicsAlloc"            opcode="win:Info" template="AllocateMeterTagTemplate"   symbol="WpfGraphicsAlloc"                  version="0" channel="DefaultChannel" keywords="KeywordHeapMeter"  />
            <event value="10002" level="Performance_LowImpact" task="WpfGraphicsRealloc"          opcode="win:Info" template="ReallocateMeterTagTemplate" symbol="WpfGraphicsRealloc"                version="0" channel="DefaultChannel" keywords="KeywordHeapMeter"  />
            <event value="10003" level="Performance_LowImpact" task="WpfGraphicsFree"             opcode="win:Info" template="FreeMeterTagTemplate"       symbol="WpfGraphicsFree"                   version="0" channel="DefaultChannel" keywords="KeywordHeapMeter"  />
            <event value="10004" level="Performance_LowImpact" task="WpfGraphicsRegisterMeterTag" opcode="win:Info" template="RegisterMeterTagTemplate"   symbol="WpfGraphicsRegisterMeterTag"        version="0" channel="DefaultChannel" keywords="KeywordHeapMeter"  />
            <event value="10005" level="Performance_LowImpact" task="WpfGraphicsAddMeterTag"      opcode="win:Info" template="AddOrSetMeterTagTemplate"   symbol="WpfGraphicsAddMeterTag"            version="0" channel="DefaultChannel" keywords="KeywordHeapMeter"  />
            <event value="10006" level="Performance_LowImpact" task="WpfGraphicsSetMeterTag"      opcode="win:Info" template="AddOrSetMeterTagTemplate"   symbol="WpfGraphicsSetMeterTag"            version="0" channel="DefaultChannel" keywords="KeywordHeapMeter"  />
            -->

            <event value="11001" level="win:Informational" task="DrawBitmap"                  opcode="win:Info"        template="Template_1"          symbol="DrawBitmapInfo"                        version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11002" level="win:Informational" task="BitmapCopy"                  opcode="win:Info"        template="Template_2"          symbol="BitmapCopyInfo"                        version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11003" level="win:Verbose"       task="SetClip"                     opcode="win:Info"        template="IntBounds"           symbol="SetClipInfo"                           version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11004" level="win:Informational" task="DWMDraw_Clear"               opcode="win:Start"       template="FloatBounds"         symbol="DWMDraw_ClearStart"                    version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11005" level="win:Informational" task="DWMDraw_Clear"               opcode="win:Stop"        template="Template_0"          symbol="DWMDraw_ClearEnd"                      version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11006" level="win:Verbose"       task="DWMDraw_"                    opcode="BitmapStart"     template="Template_6"          symbol="DWMDraw_BitmapStart"                   version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11007" level="win:Verbose"       task="DWMDraw_"                    opcode="BitmapEnd"       template="Template_6"          symbol="DWMDraw_BitmapEnd"                     version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11008" level="win:Verbose"       task="DWMDraw_"                    opcode="RectangleStart"  template="Template_6"          symbol="DWMDraw_RectangleStart"                version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11009" level="win:Verbose"       task="DWMDraw_"                    opcode="RectangleEnd"    template="Template_6"          symbol="DWMDraw_RectangleEnd"                  version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11010" level="win:Verbose"       task="DWMDraw_"                    opcode="GeometryStart"   template="Template_6"          symbol="DWMDraw_GeometryStart"                 version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11011" level="win:Verbose"       task="DWMDraw_"                    opcode="GeometryEnd"     template="Template_6"          symbol="DWMDraw_GeometryEnd"                   version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11012" level="win:Verbose"       task="DWMDraw_"                    opcode="ImageStart"      template="Template_6"          symbol="DWMDraw_ImageStart"                    version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11013" level="win:Verbose"       task="DWMDraw_"                    opcode="ImageEnd"        template="Template_6"          symbol="DWMDraw_ImageEnd"                      version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11014" level="win:Verbose"       task="DWMDraw_"                    opcode="GlyphRunStart"   template="Template_6"          symbol="DWMDraw_GlyphRunStart"                 version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11015" level="win:Verbose"       task="DWMDraw_"                    opcode="GlyphRunEnd"     template="Template_6"          symbol="DWMDraw_GlyphRunEnd"                   version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11016" level="win:Verbose"       task="DWMDraw_"                    opcode="BeginLayerStart" template="FloatBounds"         symbol="DWMDraw_BeginLayerStart"               version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11017" level="win:Verbose"       task="DWMDraw_"                    opcode="BeginLayerEnd"   template="FloatBounds"         symbol="DWMDraw_BeginLayerEnd"                 version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11018" level="win:Verbose"       task="DWMDraw_"                    opcode="EndLayerStart"   template="Template_0"          symbol="DWMDraw_EndLayerStart"                 version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11019" level="win:Verbose"       task="DWMDraw_"                    opcode="EndLayerEnd"     template="Template_0"          symbol="DWMDraw_EndLayerEnd"                   version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11020" level="win:Verbose"       task="DWMDraw_"                    opcode="ClippedBitmapStart" template="Template_6"       symbol="DWMDraw_ClippedBitmapStart"            version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11021" level="win:Verbose"       task="DWMDraw_"                    opcode="ClippedBitmapEnd" template="Template_6"         symbol="DWMDraw_ClippedBitmapEnd"              version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11022" level="win:Verbose"       task="DWMDraw_"                    opcode="win:Info"        template="FloatBounds"         symbol="DWMDraw_Info"                          version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11023" level="win:Verbose"       task="LayerEvent"                  opcode="win:Start"       template="Template_0"          symbol="LayerEventStart"                       version="2" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11024" level="win:Verbose"       task="LayerEvent"                  opcode="win:Stop"        template="Template_0"          symbol="LayerEventEnd"                         version="2" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11025" level="win:Informational" task="WClientDesktopRTCreate"      opcode="win:Start"       template="HwndTemplate"        symbol="WClientDesktopRTCreateBegin"           version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11026" level="win:Informational" task="WClientDesktopRTCreate"      opcode="win:Stop"        template="HwndTemplate"        symbol="WClientDesktopRTCreateEnd"             version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11027" level="win:Informational" task="WClientUceProcessQueue"      opcode="win:Start"       template="Template_10"         symbol="WClientUceProcessQueueBegin"           version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11028" level="win:Informational" task="WClientUceProcessQueue"      opcode="win:Stop"        template="Template_10"         symbol="WClientUceProcessQueueEnd"             version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11029" level="win:Verbose"       task="WClientUceProcessQueue"      opcode="win:Info"        template="Template_11"         symbol="WClientUceProcessQueueInfo"            version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11030" level="win:Informational" task="WClientUcePrecompute"        opcode="win:Start"       template="Template_10"         symbol="WClientUcePrecomputeBegin"             version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11031" level="win:Informational" task="WClientUcePrecompute"        opcode="win:Stop"        template="Template_10"         symbol="WClientUcePrecomputeEnd"               version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11032" level="win:Informational" task="WClientUceRender"            opcode="win:Start"       template="Template_10"         symbol="WClientUceRenderBegin"                 version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11033" level="win:Informational" task="WClientUceRender"            opcode="win:Stop"        template="Template_10"         symbol="WClientUceRenderEnd"                   version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11034" level="win:Informational" task="WClientUcePresent"           opcode="win:Start"       template="Template_12"         symbol="WClientUcePresentBegin"                version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11035" level="win:Informational" task="WClientUcePresent"           opcode="win:Stop"        template="Template_12"         symbol="WClientUcePresentEnd"                  version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11036" level="win:Informational" task="WClientUceResponse"          opcode="win:Info"        template="Template_13"         symbol="WClientUceResponse"                    version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11037" level="win:Informational" task="WClientUceCheckDeviceState"  opcode="win:Info"        template="Template_15"         symbol="WClientUceCheckDeviceStateInfo"        version="2" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11038" level="win:Informational" task="VisualCacheAlloc"            opcode="win:Info"        template="VisualCacheTemplate" symbol="VisualCacheAlloc"                      version="0" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11039" level="win:Informational" task="VisualCacheUpdate"           opcode="win:Info"        template="VisualCacheTemplate" symbol="VisualCacheUpdate"                     version="0" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11040" level="Performance_LowImpact" task="CreateChannel"           opcode="win:Info"        template="CreateChannel"       symbol="CreateChannel"                         version="0" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11041" level="Performance_LowImpact" task="CreateOrAddOnChnl"       opcode="win:Info"        template="CreateOrAddOnChnl"   symbol="CreateOrAddResourceOnChannel"          version="0" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11042" level="Performance_LowImpact" task="CreateWpfGfxResource"     opcode="win:Info"        template="CreateWpfGfxResource" symbol="CreateWpfGfxResource"                   version="0" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11043" level="Performance_LowImpact" task="ReleaseOnChannel"        opcode="win:Info"        template="ReleaseOnChannel"    symbol="ReleaseOnChannel"                      version="0" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11044" level="win:Informational" task="UnexpectedSoftwareFallback"  opcode="win:Info"        template="GfxSoftwareFallback" symbol="UnexpectedSoftwareFallback"            version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11045" level="win:Informational" task="WClientInterlockedRender"    opcode="win:Start"       template="Template_0"          symbol="WClientInterlockedRenderBegin"         version="2" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11046" level="win:Informational" task="WClientInterlockedRender"    opcode="win:Stop"        template="Template_0"          symbol="WClientInterlockedRenderEnd"           version="2" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11047" level="win:Informational" task="WClientRenderHandler"        opcode="win:Start"       template="PerfElementID"       symbol="WClientRenderHandlerBegin"             version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11048" level="win:Informational" task="WClientRenderHandler"        opcode="win:Stop"        template="Template_0"          symbol="WClientRenderHandlerEnd"               version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11049" level="win:Informational" task="WClientAnimRenderHandler"    opcode="win:Start"       template="PerfElementID"       symbol="WClientAnimRenderHandlerBegin"         version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11050" level="win:Informational" task="WClientAnimRenderHandler"    opcode="win:Stop"        template="Template_0"          symbol="WClientAnimRenderHandlerEnd"           version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11051" level="win:Informational" task="WClientMediaRender"          opcode="win:Start"       template="Template_20"         symbol="WClientMediaRenderBegin"               version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11052" level="win:Informational" task="WClientMediaRender"          opcode="win:Stop"        template="Template_0"          symbol="WClientMediaRenderEnd"                 version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11053" level="win:Informational" task="WClientPostRender"           opcode="win:Info"        template="Template_0"          symbol="WClientPostRender"                     version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11054" level="win:Informational" task="WClientQPCFrequency"         opcode="win:Info"        template="Template_21"         symbol="WClientQPCFrequency"                   version="2" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11055" level="win:Informational" task="WClientPrecomputeScene"      opcode="win:Start"       template="PerfElementID"       symbol="WClientPrecomputeSceneBegin"           version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11056" level="win:Informational" task="WClientPrecomputeScene"      opcode="win:Stop"        template="Template_0"          symbol="WClientPrecomputeSceneEnd"             version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11057" level="win:Informational" task="WClientCompileScene"         opcode="win:Start"       template="PerfElementID"       symbol="WClientCompileSceneBegin"              version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11058" level="win:Informational" task="WClientCompileScene"         opcode="win:Stop"        template="Template_0"          symbol="WClientCompileSceneEnd"                version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11059" level="win:Informational" task="WClientUIResponse"           opcode="win:Info"        template="Template_22"         symbol="WClientUIResponse"                     version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11060" level="win:Informational" task="WClientUICommitChannel"      opcode="win:Info"        template="ID32Template"        symbol="WClientUICommitChannel"                version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11061" level="win:Informational" task="WClientUceNotifyPresent"     opcode="win:Info"        template="Template_23"         symbol="WClientUceNotifyPresent"               version="2" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11062" level="win:Informational" task="WClientScheduleRender"       opcode="win:Info"        template="Template_24"         symbol="WClientScheduleRender"                 version="2" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11063" level="win:Verbose"       task="WClientOnRender"             opcode="win:Start"       template="PerfElementID"       symbol="WClientOnRenderBegin"                  version="0" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11064" level="win:Verbose"       task="WClientOnRender"             opcode="win:Stop"        template="PerfElementID"       symbol="WClientOnRenderEnd"                    version="0" channel="DefaultChannel" keywords="KeywordGraphics KeywordPerf"  />
            <event value="11065" level="Performance_MedImpact" task="WClientCreateIRT"        opcode="win:Info"        template="CreateIRT"           symbol="WClientCreateIRT"                      version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />
            <event value="11066" level="Performance_MedImpact" task="WClientPotentialIRTResource" opcode="win:Info"    template="PtrTemplate"         symbol="WClientPotentialIRTResource"           version="0" channel="DefaultChannel" keywords="KeywordGraphics"  />

            <event value="12001" level="win:Informational" task="WClientUIContextDispatch"    opcode="win:Start"       template="DispatcherMessage"   symbol="WClientUIContextDispatchBegin"         version="2" channel="DefaultChannel" keywords="KeywordDispatcher KeywordPerf"  />
            <event value="12002" level="win:Informational" task="WClientUIContextDispatch"    opcode="win:Stop"        template="Template_0"          symbol="WClientUIContextDispatchEnd"           version="2" channel="DefaultChannel" keywords="KeywordDispatcher KeywordPerf"  />
            <event value="12003" level="win:Informational" task="WClientUIContextPost"        opcode="win:Info"        template="DispatcherMessage"   symbol="WClientUIContextPost"                  version="2" channel="DefaultChannel" keywords="KeywordDispatcher KeywordPerf"  />
            <event value="12004" level="win:Informational" task="WClientUIContextAbort"       opcode="win:Info"        template="DispatcherMessage"   symbol="WClientUIContextAbort"                 version="2" channel="DefaultChannel" keywords="KeywordDispatcher"  />
            <event value="12005" level="win:Informational" task="WClientUIContextPromote"     opcode="win:Info"        template="DispatcherMessage"   symbol="WClientUIContextPromote"               version="2" channel="DefaultChannel" keywords="KeywordDispatcher"  />
            <event value="12006" level="win:Informational" task="WClientUIContextIdle"        opcode="win:Info"        template="Template_0"          symbol="WClientUIContextIdle"                  version="2" channel="DefaultChannel" keywords="KeywordDispatcher KeywordPerf"  />
        </events>
      </provider>
    </events>
  </instrumentation>
  <localization>
    <resources culture="en-US">
      <stringTable>
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.0.message" value="Inactive" />
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.1.message" value="SystemIdle" />
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.2.message" value="ApplicationIdle" />
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.3.message" value="ContextIdle" />
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.4.message" value="Background" />
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.5.message" value="Input" />
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.6.message" value="Loaded" />
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.7.message" value="Render" />
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.8.message" value="DataBind" />
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.9.message" value="Normal" />
        <string id="Microsoft-Windows-WPF.map.DispatcherPriority.10.message" value="Send" />
        <string id="UnexptectedSWFallback_NoHardwareAvailable" value="NoHardwareAvailable" />
        <string id="UnexpectedSWFallback_ResizeFailed" value="ResizeFailed" />
        <string id="UnexpectedSWFallback_OutOfVideoMemory" value="OutOfVideoMemory" />
        <string id="UnexpectedSWFallback_UnexpectedPrimitiveFallback" value="UnexpectedPrimitiveFallback" />
        <string id="Layout_LayoutManager" value="LayoutManager" />
        <string id="Layout_HwndSource_SetLayoutSize" value="HwndSource_SetLayoutSize" />
        <string id="Layout_HwndSource_WM_SIZE" value="HwndSource_WM_SIZE" />
        <string id="IRT_Clip" value="Clip" />
        <string id="IRT_ClipAndOpacity" value="Clip_and_Opacity" />
        <string id="IRT_Effect" value="Effect" />
        <string id="IRT_Opacity" value="Opacity" />
        <string id="IRT_OpacityMask" value="OpacityMask" />
        <string id="IRT_OpacityMask_Brush_Realization" value="OpacityMask_Brush_Realization" />
        <string id="IRT_ShaderEffect_Input" value="ShaderEffect_Input" />
        <string id="IRT_Software_Only_Effects" value="Software_Only_Effects" />
        <string id="IRT_TileBrush" value="TileBrush" />
      </stringTable>
    </resources>
  </localization>
</instrumentationManifest>
